/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.vistabroker.admin.dao;

import gov.va.med.lom.javaUtils.misc.DateUtils;
import gov.va.med.lom.javaUtils.misc.StringUtils;
import gov.va.med.lom.vistabroker.admin.data.SurgeryScheduleItem;
import gov.va.med.lom.vistabroker.dao.BaseDao;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SurgeryScheduleDao
extends BaseDao {
    private List<SurgeryScheduleItem> items;

    public List<SurgeryScheduleItem> fetch(GregorianCalendar date) throws Exception {
        this.setDefaultContext(null);
        this.setDefaultRpcName("ARIL GET SDATA2");
        List<String> arr = null;
        try {
            String start = String.valueOf(DateUtils.formatDate((Date)date.getTime(), (String)DateUtils.ENGLISH_DATE_FORMAT));
            Object[] params = new Object[]{start};
            arr = this.lCall(params);
        }
        catch (Exception e) {
            return null;
        }
        this.items = new ArrayList<SurgeryScheduleItem>();
        for (String x : arr) {
            SurgeryScheduleItem item = new SurgeryScheduleItem();
            item.setOperatingRoom(StringUtils.piece((String)x, (int)1));
            item.setPatientName(StringUtils.piece((String)x, (int)2));
            item.setLast4(StringUtils.piece((String)x, (int)3));
            item.setPatientLocation(StringUtils.piece((String)x, (int)4));
            item.setPrincipleProcedure(StringUtils.piece((String)x, (int)5));
            item.setOtherProcedure(StringUtils.piece((String)x, (int)6));
            item.setScheduledStartTime(StringUtils.piece((String)x, (int)7));
            item.setEstmatedCompletionTime(StringUtils.piece((String)x, (int)8));
            item.setCaseLength(StringUtils.piece((String)x, (int)9));
            item.setOperationEndTime(StringUtils.piece((String)x, (int)10));
            item.setStatus(StringUtils.piece((String)x, (int)11));
            item.setTimeInOr(StringUtils.piece((String)x, (int)13));
            item.setInductionCompletionTime(StringUtils.piece((String)x, (int)14));
            item.setActualBeginTime(StringUtils.piece((String)x, (int)15));
            item.setActualEndTime(StringUtils.piece((String)x, (int)16));
            item.setTimeOutOfOr(StringUtils.piece((String)x, (int)17));
            item.setOrOccupancyTime(StringUtils.piece((String)x, (int)18));
            item.setSurgeonName(StringUtils.piece((String)x, (int)19));
            item.setAttendingName(StringUtils.piece((String)x, (int)20));
            item.setAnesthesiologistName(StringUtils.piece((String)x, (int)21));
            item.setAnesthesiologistSupervisor(StringUtils.piece((String)x, (int)22));
            item.setCirculationNurseName(StringUtils.piece((String)x, (int)23));
            item.setScrubNurseName(StringUtils.piece((String)x, (int)24));
            item.setIen(StringUtils.piece((String)x, (int)25));
            item.setConcurrentProcedure(StringUtils.piece((String)x, (int)26));
            item.setCaseScheduleType(StringUtils.piece((String)x, (int)27));
            item.setPrincipleProcedureCpt(StringUtils.piece((String)x, (int)28));
            item.setCaseLengthLeft(StringUtils.piece((String)x, (int)29));
            this.disposition(item);
            this.items.add(item);
        }
        return this.items;
    }

    private void disposition(SurgeryScheduleItem i) {
        String x;
        if (i == null) {
            return;
        }
        if (i.getIen() == null || i.getIen().length() == 0) {
            return;
        }
        this.setDefaultContext(null);
        this.setDefaultRpcName("ALSI SURGERY DISPOSITION");
        try {
            Object[] params = new Object[]{i.getIen()};
            x = this.sCall(params);
        }
        catch (Exception e) {
            return;
        }
        i.setPatientLocation(StringUtils.piece((String)x, (int)2));
        i.setPatientDisposition(StringUtils.piece((String)x, (int)3));
    }
}

