/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.vistabroker.admin.dao;

import gov.va.med.lom.javaUtils.misc.StringUtils;
import gov.va.med.lom.vistabroker.admin.data.GenFormData;
import gov.va.med.lom.vistabroker.admin.data.GenFormListItem;
import gov.va.med.lom.vistabroker.admin.data.GenFormListParams;
import gov.va.med.lom.vistabroker.dao.BaseDao;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormGeneratorDao
extends BaseDao {
    public FormGeneratorDao() {
    }

    public FormGeneratorDao(BaseDao baseDao) {
        super(baseDao);
    }

    public List<GenFormData> putData(List<GenFormData> genFormDataList) throws Exception {
        this.setDefaultContext("ALS CLINICAL RPC");
        this.setDefaultRpcName("ALS GENFORM PUT DATA");
        ArrayList<String> list = new ArrayList<String>();
        for (GenFormData data : genFormDataList) {
            StringBuffer sb = new StringBuffer();
            sb.append(data.getFileIen());
            sb.append("^");
            if (data.getEntryIen() != null) {
                sb.append(data.getEntryIen());
            }
            sb.append("^");
            sb.append(data.getFieldIen());
            sb.append("^");
            if (data.getDataType() != null) {
                sb.append(data.getDataType());
            }
            sb.append("^");
            if (data.getIntFormat() != null) {
                sb.append(data.getIntFormat());
            } else {
                sb.append(data.getExtFormat());
            }
            sb.append("^");
            if (data.getDiNumIen() != null) {
                sb.append(data.getDiNumIen());
            }
            sb.append("^");
            if (data.getFlags() != null) {
                sb.append(data.getFlags());
            }
            list.add(sb.toString());
        }
        List<String> x = this.lCall(list);
        ArrayList<GenFormData> dataList = new ArrayList<GenFormData>();
        for (String s : x) {
            GenFormData data = new GenFormData();
            String p1 = StringUtils.piece((String)s, (int)1);
            data.setFileIen(p1);
            if (!p1.equals("-1")) {
                data.setEntryIen(StringUtils.piece((String)s, (int)2));
            } else {
                data.setMessage(StringUtils.piece((String)s, (int)2));
            }
            dataList.add(data);
        }
        return dataList;
    }

    public boolean putWpData(List<GenFormData> genFormDataList) throws Exception {
        this.setDefaultContext("ALS CLINICAL RPC");
        this.setDefaultRpcName("ALS GENFORM PUT WPS");
        ArrayList<String> list = new ArrayList<String>();
        for (GenFormData data : genFormDataList) {
            StringBuffer sb = new StringBuffer();
            sb.append("$START ");
            sb.append(data.getFileIen());
            sb.append("^");
            sb.append(data.getEntryIen());
            sb.append("^");
            sb.append(data.getFieldIen());
            list.add(sb.toString());
            String[] lines = null;
            lines = data.getIntFormat() != null ? StringUtils.pieceList((String)data.getIntFormat(), (char)'\n') : StringUtils.pieceList((String)data.getExtFormat(), (char)'\n');
            for (int i = 0; i < lines.length; ++i) {
                list.add(lines[i]);
            }
            sb.append("$END ");
            sb.append(data.getFileIen());
            sb.append("^");
            sb.append(data.getEntryIen());
            sb.append("^");
            sb.append(data.getFieldIen());
            list.add(sb.toString());
        }
        String x = this.sCall(list);
        if (StringUtils.piece((String)x, (int)1).equals("0")) {
            return true;
        }
        throw new Exception(StringUtils.piece((String)x, (int)2));
    }

    public List<GenFormData> getData(List<GenFormData> genFormDataList) throws Exception {
        this.setDefaultContext("ALS CLINICAL RPC");
        this.setDefaultRpcName("ALS GENFORM GET DATA");
        ArrayList<String> list = new ArrayList<String>();
        for (GenFormData data : genFormDataList) {
            StringBuffer sb = new StringBuffer();
            if (data.getId() != null) {
                sb.append(data.getId());
            }
            sb.append("^");
            sb.append(data.getFileIen());
            sb.append("^");
            sb.append(data.getEntryIen());
            sb.append("^");
            sb.append(data.getFieldIen());
            sb.append("^");
            if (data.getDataType() != null) {
                sb.append(data.getDataType());
            }
            list.add(sb.toString());
        }
        List<String> results = this.lCall(list);
        ArrayList<GenFormData> dataList = new ArrayList<GenFormData>();
        for (String s : results) {
            GenFormData data = new GenFormData();
            String p1 = StringUtils.piece((String)s, (int)1);
            if (p1.equals("-1")) {
                throw new Exception(StringUtils.piece((String)s, (int)2));
            }
            data.setId(StringUtils.piece((String)s, (int)1));
            data.setFileIen(StringUtils.piece((String)s, (int)2));
            data.setEntryIen(StringUtils.piece((String)s, (int)3));
            data.setFieldNumber(StringUtils.piece((String)s, (int)4));
            data.setDataType(StringUtils.piece((String)s, (int)5));
            data.setIntFormat(StringUtils.piece((String)s, (int)6));
            data.setExtFormat(StringUtils.piece((String)s, (int)7));
            dataList.add(data);
        }
        return dataList;
    }

    public List<GenFormListItem> getListValues(GenFormListParams listParams) throws Exception {
        this.setDefaultContext("ALS CLINICAL RPC");
        this.setDefaultRpcName("ALS GENFORM LIST VALUES");
        if (listParams.getIens() == null) {
            listParams.setIens("");
        }
        if (listParams.getFields() == null) {
            listParams.setFields("");
        }
        if (listParams.getFlags() == null) {
            listParams.setFlags("");
        }
        if (listParams.getNumResults() <= 0) {
            listParams.setNumResults(100);
        }
        if (listParams.getFrom() == null) {
            listParams.setFrom("");
        }
        if (listParams.getPart() == null) {
            listParams.setPart("");
        }
        if (listParams.getIndex() == null) {
            listParams.setIndex("");
        }
        if (listParams.getScreen() == null) {
            listParams.setScreen("");
        }
        if (listParams.getIdentifier() == null) {
            listParams.setIdentifier("");
        }
        Object[] rpcParams = new Object[]{StringUtils.boolToStr((boolean)listParams.isShortFormFlag(), (String)"1", (String)"0"), listParams.getFileIen(), listParams.getIens(), listParams.getFields(), listParams.getFlags(), listParams.getNumResults(), listParams.getFrom(), listParams.getPart(), listParams.getIndex(), listParams.getScreen(), listParams.getIdentifier()};
        List<String> results = this.lCall(rpcParams);
        ArrayList<GenFormListItem> listItems = new ArrayList<GenFormListItem>();
        boolean i = false;
        for (String s : results) {
            if (!i && StringUtils.piece((String)s, (int)1).equals("-1")) {
                throw new Exception(StringUtils.piece((String)s, (int)2));
            }
            GenFormListItem item = new GenFormListItem();
            item.setIen(StringUtils.piece((String)s, (int)1));
            item.setValue(StringUtils.piece((String)s, (int)2));
            item.setRpcResult(s);
            listItems.add(item);
        }
        return listItems;
    }
}

