/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.vistaLinkUtils;

import gov.va.med.authentication.kernel.LoginUserInfoVO;
import gov.va.med.exception.FoundationsException;
import gov.va.med.lom.vistaLinkUtils.VistaLinkConnectionException;
import gov.va.med.lom.vistaLinkUtils.VistaLinkRpcException;
import gov.va.med.vistalink.adapter.cci.VistaLinkAppProxyConnectionSpec;
import gov.va.med.vistalink.adapter.cci.VistaLinkConnection;
import gov.va.med.vistalink.adapter.cci.VistaLinkConnectionFactory;
import gov.va.med.vistalink.adapter.cci.VistaLinkConnectionSpec;
import gov.va.med.vistalink.adapter.cci.VistaLinkDuzConnectionSpec;
import gov.va.med.vistalink.adapter.cci.VistaLinkVpidConnectionSpec;
import gov.va.med.vistalink.institution.InstitutionMappingDelegate;
import gov.va.med.vistalink.rpc.RpcRequest;
import gov.va.med.vistalink.rpc.RpcResponse;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.resource.cci.ConnectionSpec;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VistaLinkUtils {
    private static final Log log = LogFactory.getLog(VistaLinkUtils.class);
    public static final char UP = '^';
    public static final String VISTALINK_CONNECTION_ERROR = "vistalink.connection.error";
    public static final String VISTALINK_RPC_ERROR = "vistalink.rpc.error";
    public static final String VISTALINK_FOUNDATIONS_ERROR = "vistalink.foundations.error";
    private static String jndiPrefix;

    public static VistaLinkConnection getConnectionFromUserInfo(String stationNo, String userVpid, String userDuz) throws VistaLinkConnectionException {
        try {
            Object connSpec = null;
            InitialContext ic = new InitialContext();
            connSpec = !StringUtils.isBlank((String)userVpid) ? new VistaLinkVpidConnectionSpec(stationNo, userVpid) : new VistaLinkDuzConnectionSpec(stationNo, userDuz);
            return VistaLinkUtils.getConnectionForSpec((VistaLinkConnectionSpec)connSpec, ic);
        }
        catch (Exception e) {
            log.error((Object)"Error obtaining VistaLink connection", (Throwable)e);
            throw new VistaLinkConnectionException(e);
        }
    }

    public static VistaLinkConnection getConnectionFromAppProxy(String stationNo, String appProxy) throws VistaLinkConnectionException {
        if (StringUtils.isBlank((String)stationNo)) {
            log.error((Object)"must pass in a valid stationNo");
            throw new VistaLinkConnectionException("must pass in a valid stationNo");
        }
        if (StringUtils.isBlank((String)appProxy)) {
            log.error((Object)"must pass in a valid appProxy");
            throw new VistaLinkConnectionException("must pass in a valid appProxy");
        }
        try {
            VistaLinkAppProxyConnectionSpec connSpec = null;
            InitialContext ic = new InitialContext();
            connSpec = new VistaLinkAppProxyConnectionSpec(stationNo, appProxy);
            return VistaLinkUtils.getConnectionForSpec((VistaLinkConnectionSpec)connSpec, ic);
        }
        catch (Exception e) {
            log.error((Object)"Error obtaining VistaLink connection", (Throwable)e);
            throw new VistaLinkConnectionException(e);
        }
    }

    private static VistaLinkConnection getConnectionForSpec(VistaLinkConnectionSpec connSpec, Context context) throws VistaLinkConnectionException {
        VistaLinkConnection conn = null;
        try {
            String jndiName = jndiPrefix + InstitutionMappingDelegate.getJndiConnectorNameForInstitution((String)connSpec.getDivision());
            VistaLinkConnectionFactory cf = (VistaLinkConnectionFactory)context.lookup(jndiName);
            conn = (VistaLinkConnection)cf.getConnection((ConnectionSpec)connSpec);
            conn.setTimeOut(15000);
        }
        catch (Exception e) {
            log.error((Object)"Error obtaining VistaLink connection", (Throwable)e);
            throw new VistaLinkConnectionException(e);
        }
        return conn;
    }

    public static VistaLinkConnection getConnectionFromLoginUserInfo(LoginUserInfoVO user) throws VistaLinkConnectionException {
        return VistaLinkUtils.getConnectionFromUserInfo(user.getLoginStationNumber(), user.getUserVpid(), user.getUserDuz());
    }

    public static RpcResponse call(RpcRequest req, String stationNo, String userVpid, String userDuz) throws VistaLinkRpcException, VistaLinkConnectionException {
        RpcResponse result = null;
        VistaLinkConnection conn = VistaLinkUtils.getConnectionFromUserInfo(stationNo, userVpid, userDuz);
        try {
            req.setTimeOut(conn.getTimeOut() * 2);
            result = conn.executeRPC(req);
        }
        catch (FoundationsException e) {
            log.error((Object)"RPC Error", (Throwable)e);
            throw new VistaLinkRpcException((Exception)((Object)e));
        }
        finally {
            try {
                conn.close();
            }
            catch (Exception e) {}
        }
        return result;
    }

    public static RpcResponse call(RpcRequest req, LoginUserInfoVO user) throws VistaLinkRpcException, VistaLinkConnectionException {
        RpcResponse result = null;
        VistaLinkConnection conn = VistaLinkUtils.getConnectionFromLoginUserInfo(user);
        try {
            req.setTimeOut(conn.getTimeOut() * 2);
            result = conn.executeRPC(req);
        }
        catch (FoundationsException e) {
            log.error((Object)"RPC Error", (Throwable)e);
            throw new VistaLinkRpcException((Exception)((Object)e));
        }
        finally {
            try {
                conn.close();
            }
            catch (Exception e) {}
        }
        return result;
    }

    static {
        ResourceBundle res = null;
        try {
            res = ResourceBundle.getBundle("vistalinkutils");
        }
        catch (MissingResourceException mre1) {
            try {
                res = ResourceBundle.getBundle("vistabroker");
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (res != null) {
            jndiPrefix = res.getString("jndi.prefix");
        }
        if (jndiPrefix == null) {
            jndiPrefix = "";
        }
    }
}

