/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.kaajee.jboss.security.auth;

import gov.va.med.authentication.kernel.KaajeeException;
import gov.va.med.exception.FoundationsException;
import gov.va.med.lom.kaajee.jboss.model.KaajeePrincipal;
import gov.va.med.lom.kaajee.jboss.model.json.LoginUserInfoVOJson;
import gov.va.med.lom.kaajee.jboss.security.auth.ApplicationRoleListVOSingleton;
import gov.va.med.lom.kaajee.jboss.security.auth.LoginControllerUtils;
import gov.va.med.vistalink.adapter.cci.VistaLinkConnection;
import gov.va.med.vistalink.rpc.RpcRequest;
import gov.va.med.vistalink.rpc.RpcRequestFactory;
import gov.va.med.vistalink.rpc.RpcResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RoleUtilsAjax {
    private static final Log log = LogFactory.getLog(RoleUtilsAjax.class);

    RoleUtilsAjax() {
    }

    static List<KaajeePrincipal> cacheUserRoles(VistaLinkConnection myConnection, LoginUserInfoVOJson userInfo) throws KaajeeException {
        String exceptionMessage = "";
        try {
            ApplicationRoleListVOSingleton roleListVO = ApplicationRoleListVOSingleton.getInstance();
            if (roleListVO == null) {
                throw new KaajeeException("Could not retrieve application role list, because ApplicationRoleListVOSingleton has not been initialized.");
            }
            return RoleUtilsAjax.cacheRoles(myConnection, roleListVO, userInfo);
        }
        catch (KaajeeException e) {
            LoginControllerUtils.closeVistaLinkConnection(myConnection);
            exceptionMessage = "Could not cache user roles.";
            if (log.isErrorEnabled()) {
                log.error((Object)exceptionMessage, (Throwable)((Object)e));
            }
            throw new KaajeeException(exceptionMessage, (Exception)((Object)e));
        }
    }

    private static List<KaajeePrincipal> cacheRoles(VistaLinkConnection myConnection, ApplicationRoleListVOSingleton roleListVO, LoginUserInfoVOJson userInfo) throws KaajeeException {
        ArrayList<String> userRoleListFromM = new ArrayList<String>();
        ArrayList<KaajeePrincipal> roles = new ArrayList<KaajeePrincipal>();
        try {
            roles.add(new KaajeePrincipal("AUTHENTICATED_KAAJEE_USER"));
            String rpcName = "XUS ALLKEYS";
            RpcRequest vReq = RpcRequestFactory.getRpcRequest();
            vReq.setUseProprietaryMessageFormat(true);
            vReq.setRpcContext("XUS KAAJEE WEB LOGON");
            vReq.setRpcClientTimeOut(600);
            vReq.setRpcName(rpcName);
            RpcResponse vResp = myConnection.executeRPC(vReq);
            String results = vResp.getResults();
            if (log.isDebugEnabled()) {
                log.debug((Object)("results of XUS KEY CHECK: " + results));
            }
            StringTokenizer st = new StringTokenizer(results, "\n");
            String keyname = "";
            while (st.hasMoreTokens()) {
                keyname = st.nextToken();
                userRoleListFromM.add(keyname);
                if (log.isDebugEnabled()) {
                    StringBuffer sb = new StringBuffer("Adding role '");
                    sb.append(keyname);
                    sb.append("' to role cache for username '");
                    sb.append(userInfo.getUserLoginStationNumber() + "^" + userInfo.getUserDuz());
                    sb.append("'.");
                    log.debug((Object)sb.toString());
                }
                userInfo.addRole(keyname);
                roles.add(new KaajeePrincipal(keyname));
            }
        }
        catch (FoundationsException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Could not retrieve roles.");
            }
            throw new KaajeeException((Exception)((Object)e));
        }
        return roles;
    }
}

