/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.kaajee.jboss.security.auth;

import gov.va.med.authentication.kernel.KaajeeException;
import gov.va.med.authentication.kernel.KaajeeInstitutionResourceException;
import gov.va.med.authentication.kernel.LoginUserInfoVO;
import gov.va.med.authentication.kernel.VistaDivisionVO;
import gov.va.med.crypto.VistaKernelHash;
import gov.va.med.exception.FoundationsException;
import gov.va.med.lom.kaajee.jboss.security.auth.ConfigurationVO;
import gov.va.med.lom.kaajee.jboss.security.auth.LoginControllerUtils;
import gov.va.med.lom.kaajee.jboss.security.auth.LoginUserInfoDivisionFilters;
import gov.va.med.term.access.Institution;
import gov.va.med.vistalink.adapter.cci.VistaLinkConnection;
import gov.va.med.vistalink.adapter.cci.VistaLinkConnectionSpec;
import gov.va.med.vistalink.adapter.cci.VistaLinkDuzConnectionSpec;
import gov.va.med.vistalink.adapter.record.LoginsDisabledFaultException;
import gov.va.med.vistalink.rpc.RpcRequest;
import gov.va.med.vistalink.rpc.RpcRequestFactory;
import gov.va.med.vistalink.rpc.RpcResponse;
import gov.va.med.vistalink.security.m.SecurityAccessVerifyCodePairInvalidException;
import gov.va.med.vistalink.security.m.SecurityDivisionDeterminationFaultException;
import gov.va.med.vistalink.security.m.SecurityIdentityDeterminationFaultException;
import gov.va.med.vistalink.security.m.SecurityTooManyInvalidLoginAttemptsFaultException;
import gov.va.med.vistalink.security.m.SecurityUserAuthorizationException;
import gov.va.med.vistalink.security.m.SecurityUserVerifyCodeException;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LoginUserInfoVOAssembler {
    private static final Log log = LogFactory.getLog(LoginUserInfoVOAssembler.class);
    private static String USER_INFO_RPC = "XUS KAAJEE GET USER INFO";
    private static String USER_INFO_PROXY_RPC = "XUS KAAJEE GET USER VIA PROXY";
    private static final String KERNEL_USER_INFO_RPC = "XUS GET USER INFO";

    LoginUserInfoVOAssembler() {
    }

    static LoginUserInfoVO getLoginUserInfo(VistaLinkConnection myConnection, String kajLoginDivStNum, String clientIp) throws KaajeeInstitutionResourceException, KaajeeException {
        LoginUserInfoVO returnVal = null;
        ConfigurationVO configVO = ConfigurationVO.getInstance();
        boolean retrieveNewPersonDivisions = configVO.getRetrieveNewPersonDivisions();
        boolean retrieveComputingFacilityDivisions = configVO.getRetrieveComputingFacilityDivisions();
        Institution kajLoginDivInst = null;
        try {
            kajLoginDivInst = Institution.factory.obtainByStationNumber(kajLoginDivStNum);
        }
        catch (Throwable t) {
            StringBuffer sb = new StringBuffer("Error retrieving institution. ");
            sb.append(t.getMessage());
            throw new KaajeeInstitutionResourceException(sb.toString());
        }
        Institution kajLoginDivVistaProviderInst = LoginUserInfoVOAssembler.getLoginDivisionVistaProviderInstitution(kajLoginDivStNum, kajLoginDivInst);
        String kajLoginDivVistaProviderStNum = LoginUserInfoVOAssembler.getLoginDivisionVistaProviderStationNumber(kajLoginDivStNum, kajLoginDivVistaProviderInst);
        String rpcResults = null;
        try {
            RpcRequest vReq = RpcRequestFactory.getRpcRequest();
            vReq.setRpcContext("XUS KAAJEE WEB LOGON");
            vReq.setRpcClientTimeOut(600);
            vReq.setUseProprietaryMessageFormat(true);
            vReq.setRpcName(USER_INFO_RPC);
            vReq.getParams().setParam(1, "string", (Object)clientIp);
            vReq.getParams().setParam(2, "string,", (Object)ConfigurationVO.getInstance().getHostApplicationName());
            RpcResponse vResp = myConnection.executeRPC(vReq);
            rpcResults = vResp.getResults();
        }
        catch (SecurityUserAuthorizationException e) {
            String exceptionString = "Authorization failed for your user account on the M system; could not log you on.<br>&nbsp;<br>Please contact your site manager for assistance.<br>&nbsp;<br>More details below:<br>&nbsp;<br>";
            throw new KaajeeException(exceptionString, (Exception)((Object)e));
        }
        catch (SecurityTooManyInvalidLoginAttemptsFaultException e) {
            StringBuffer sb = new StringBuffer("Login failed due to too many invalid login attempts.<br>&nbsp;<br>Please contact your site manager for assistance.<br>&nbsp;<br>More details below:<br>&nbsp;<br>");
            sb.append(e.getMessage());
            if (log.isErrorEnabled()) {
                log.error((Object)sb.toString(), (Throwable)e);
            }
            throw new KaajeeException(sb.toString(), (Exception)((Object)e));
        }
        catch (SecurityUserVerifyCodeException e) {
            String exceptionString = "Your verify code has expired or needs changing; could not log you on.<br>&nbsp;<br>Please use another application to change your verify code and then try to log on again here. Or, contact your site manager for assistance.";
            throw new KaajeeException(exceptionString);
        }
        catch (SecurityAccessVerifyCodePairInvalidException e) {
            String exceptionString = "Not a valid ACCESS CODE/VERIFY CODE pair.";
            throw new KaajeeException(exceptionString);
        }
        catch (LoginsDisabledFaultException e) {
            String exceptionString = "Logins are disabled on the M system.";
            throw new KaajeeException(exceptionString);
        }
        catch (SecurityIdentityDeterminationFaultException e) {
            StringBuffer sb = new StringBuffer("Could not match you with your M account; could not log you on.<br>&nbsp;<br>Please contact your site manager for assistance.<br>&nbsp;<br>More details below:<br>&nbsp;<br>");
            sb.append(e.getMessage());
            if (log.isErrorEnabled()) {
                log.error((Object)sb.toString(), (Throwable)e);
            }
            throw new KaajeeException(sb.toString(), (Exception)((Object)e));
        }
        catch (SecurityDivisionDeterminationFaultException e) {
            StringBuffer sb = new StringBuffer("The institution/division you selected for login is not valid for your M user account; could not log you on.<br>&nbsp;<br>Please contact your site manager for assistance.<br>&nbsp;<br>More details below:<br>&nbsp;<br>");
            sb.append(e.getMessage());
            if (log.isErrorEnabled()) {
                log.error((Object)sb.toString(), (Throwable)e);
            }
            throw new KaajeeException(sb.toString(), (Exception)((Object)e));
        }
        catch (FoundationsException e) {
            StringBuffer sb = new StringBuffer("Error logging on or retrieving user information; could not log you on.<br>&nbsp;<br>Please contact your site manager for assistance.<br>&nbsp;<br>More details below:<br>&nbsp;<br>");
            sb.append(e.getMessage());
            if (log.isErrorEnabled()) {
                log.error((Object)sb.toString(), (Throwable)e);
            }
            throw new KaajeeException(sb.toString(), (Exception)((Object)e));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("results of XUS KAAJEE GET USER INFO: " + rpcResults));
        }
        returnVal = new LoginUserInfoVO();
        StringTokenizer st = new StringTokenizer(rpcResults, "\n");
        returnVal.setUserDuz(st.nextToken());
        returnVal.setUserName01(st.nextToken());
        returnVal.setUserNameDisplay(st.nextToken());
        returnVal.setUserLastName(st.nextToken());
        returnVal.setUserFirstName(st.nextToken());
        returnVal.setUserMiddleName(st.nextToken());
        returnVal.setUserPrefix(st.nextToken());
        returnVal.setUserSuffix(st.nextToken());
        returnVal.setUserDegree(st.nextToken());
        returnVal.setLoginStationNumber(kajLoginDivStNum);
        String mLoginInstitutionStationNumber = st.nextToken();
        if (!kajLoginDivStNum.equals(mLoginInstitutionStationNumber) && log.isErrorEnabled()) {
            StringBuffer sb = new StringBuffer("Warning: For User DUZ: '");
            sb.append(returnVal.getUserDuz());
            sb.append("KAAJEE login division '");
            sb.append(kajLoginDivStNum);
            sb.append("' is different than M login division DUZ(2) value '");
            sb.append(mLoginInstitutionStationNumber);
            sb.append("'.");
            log.error((Object)sb.toString());
        }
        String mLoginDivParentStNum = st.nextToken();
        String kajLoginDivParentStNum = LoginUserInfoVOAssembler.getParentStationNumber(kajLoginDivInst, mLoginDivParentStNum);
        returnVal.setUserParentAdministrativeFacilityStationNumber(kajLoginDivParentStNum);
        if (!kajLoginDivParentStNum.equals(mLoginDivParentStNum) && log.isErrorEnabled()) {
            StringBuffer sb = new StringBuffer("Warning: For Login Station# '");
            sb.append(kajLoginDivStNum);
            sb.append("' the SDS Administrative Parent Station# '");
            sb.append(kajLoginDivParentStNum);
            sb.append("' does not match the value returned from M: '");
            sb.append(mLoginDivParentStNum);
            sb.append("'.");
            log.error((Object)sb.toString());
        }
        String mLoginDivVistaProviderStNum = st.nextToken();
        returnVal.setUserParentComputerSystemStationNumber(kajLoginDivVistaProviderStNum);
        if (!kajLoginDivVistaProviderStNum.equals(mLoginDivVistaProviderStNum) && log.isErrorEnabled()) {
            StringBuffer sb = new StringBuffer("Warning: For Login Station# '");
            sb.append(kajLoginDivStNum);
            sb.append("' the SDS VistaProvider Station# '");
            sb.append(kajLoginDivVistaProviderStNum);
            sb.append("' does not match the value returned from M: '");
            sb.append(mLoginDivVistaProviderStNum);
            sb.append("'.");
            log.error((Object)sb.toString());
        }
        returnVal.setSignonLogIen(st.nextToken());
        TreeMap<String, VistaDivisionVO> newPersonDivisions = new TreeMap<String, VistaDivisionVO>();
        int divCount = Integer.parseInt(st.nextToken());
        for (int i = 0; i < divCount; ++i) {
            VistaDivisionVO foundDivision = LoginUserInfoVOAssembler.getDivisionInfo(st.nextToken());
            if (!retrieveNewPersonDivisions) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found division: " + foundDivision.toString()));
            }
            newPersonDivisions.put(foundDivision.getNumber(), foundDivision);
        }
        if (retrieveNewPersonDivisions) {
            LoginUserInfoDivisionFilters.sameVistaProviderFilter(kajLoginDivStNum, newPersonDivisions, returnVal.getUserDuz());
            returnVal.setPermittedDivisons(newPersonDivisions);
        }
        if (retrieveComputingFacilityDivisions) {
            TreeMap<String, VistaDivisionVO> cfDivisionsMap = LoginUserInfoVOAssembler.getComputingFacilityDivisions(kajLoginDivVistaProviderInst, kajLoginDivInst);
            returnVal.setLoginDivisionVistaProviderDivisions(cfDivisionsMap);
        }
        String rpcResults2 = null;
        try {
            RpcRequest vReq2 = RpcRequestFactory.getRpcRequest();
            vReq2.setRpcContext("XUS KAAJEE WEB LOGON");
            vReq2.setRpcClientTimeOut(600);
            vReq2.setTimeOut(5000);
            vReq2.setUseProprietaryMessageFormat(true);
            vReq2.setRpcName(KERNEL_USER_INFO_RPC);
            RpcResponse vResp2 = myConnection.executeRPC(vReq2);
            rpcResults2 = vResp2.getResults();
        }
        catch (SecurityUserAuthorizationException e) {
            String exceptionString = "Authorization failed for your user account on the M system; could not log you on.<br>&nbsp;<br>Please contact your site manager for assistance.<br>&nbsp;<br>More details below:<br>&nbsp;<br>";
            throw new KaajeeException(exceptionString, (Exception)((Object)e));
        }
        catch (SecurityTooManyInvalidLoginAttemptsFaultException e) {
            StringBuffer sb = new StringBuffer("Login failed due to too many invalid login attempts.<br>&nbsp;<br>Please contact your site manager for assistance.<br>&nbsp;<br>More details below:<br>&nbsp;<br>");
            sb.append(e.getMessage());
            if (log.isErrorEnabled()) {
                log.error((Object)sb.toString(), (Throwable)e);
            }
            throw new KaajeeException(sb.toString(), (Exception)((Object)e));
        }
        catch (SecurityUserVerifyCodeException e) {
            String exceptionString = "Your verify code has expired or needs changing; could not log you on.<br>&nbsp;<br>Please use another application to change your verify code and then try to log on again here. Or, contact your site manager for assistance.";
            throw new KaajeeException(exceptionString);
        }
        catch (SecurityAccessVerifyCodePairInvalidException e) {
            String exceptionString = "Not a valid ACCESS CODE/VERIFY CODE pair.";
            throw new KaajeeException(exceptionString);
        }
        catch (LoginsDisabledFaultException e) {
            String exceptionString = "Logins are disabled on the M system.";
            throw new KaajeeException(exceptionString);
        }
        catch (SecurityIdentityDeterminationFaultException e) {
            StringBuffer sb = new StringBuffer("Could not match you with your M account; could not log you on.<br>&nbsp;<br>Please contact your site manager for assistance.<br>&nbsp;<br>More details below:<br>&nbsp;<br>");
            sb.append(e.getMessage());
            if (log.isErrorEnabled()) {
                log.error((Object)sb.toString(), (Throwable)e);
            }
            throw new KaajeeException(sb.toString(), (Exception)((Object)e));
        }
        catch (SecurityDivisionDeterminationFaultException e) {
            StringBuffer sb = new StringBuffer("The institution/division you selected for login is not valid for your M user account; could not log you on.<br>&nbsp;<br>Please contact your site manager for assistance.<br>&nbsp;<br>More details below:<br>&nbsp;<br>");
            sb.append(e.getMessage());
            if (log.isErrorEnabled()) {
                log.error((Object)sb.toString(), (Throwable)e);
            }
            throw new KaajeeException(sb.toString(), (Exception)((Object)e));
        }
        catch (FoundationsException e) {
            StringBuffer sb = new StringBuffer("Error logging on or retrieving user information; could not log you on.<br>&nbsp;<br>Please contact your site manager for assistance.<br>&nbsp;<br>More details below:<br>&nbsp;<br>");
            sb.append(e.getMessage());
            if (log.isErrorEnabled()) {
                log.error((Object)sb.toString(), (Throwable)e);
            }
            throw new KaajeeException(sb.toString(), (Exception)((Object)e));
        }
        log.debug((Object)("XUS GET USER INFO results:\n" + rpcResults2));
        String[] sToks = rpcResults2.split("\\n");
        block32: for (int i = 0; i < sToks.length; ++i) {
            String value = sToks[i];
            switch (i) {
                case 0: {
                    continue block32;
                }
                case 1: {
                    continue block32;
                }
                case 2: {
                    continue block32;
                }
                case 3: {
                    String[] val = value.split("\\^");
                    returnVal.setDivisionName(val[1]);
                    returnVal.setDivisionIEN(value.replace('^', '|'));
                    continue block32;
                }
                case 4: {
                    returnVal.setUserTitle(value);
                    continue block32;
                }
                case 5: {
                    returnVal.setUserServiceSection(value);
                    continue block32;
                }
                case 6: {
                    returnVal.setLanguage(value);
                    continue block32;
                }
                case 7: {
                    returnVal.setDateTime(value);
                    continue block32;
                }
                case 8: {
                    returnVal.setUserVpid(value);
                }
            }
        }
        LoginUserInfoVOAssembler.tidyUpNullNameValues(returnVal);
        return returnVal;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static LoginUserInfoVO getLoginUserInfoCCOW(VistaLinkConnection myConnection, String kajLoginDivStNum, String clientIp, String vistaToken) throws KaajeeInstitutionResourceException, KaajeeException {
        LoginUserInfoVO returnVal = null;
        ConfigurationVO configVO = ConfigurationVO.getInstance();
        boolean retrieveNewPersonDivisions = configVO.getRetrieveNewPersonDivisions();
        boolean retrieveComputingFacilityDivisions = configVO.getRetrieveComputingFacilityDivisions();
        Institution kajLoginDivInst = null;
        try {
            kajLoginDivInst = Institution.factory.obtainByStationNumber(kajLoginDivStNum);
        }
        catch (Throwable t) {
            StringBuffer sb = new StringBuffer("Error retrieving institution. ");
            sb.append(t.getMessage());
            throw new KaajeeInstitutionResourceException(sb.toString());
        }
        Institution kajLoginDivVistaProviderInst = LoginUserInfoVOAssembler.getLoginDivisionVistaProviderInstitution(kajLoginDivStNum, kajLoginDivInst);
        String kajLoginDivVistaProviderStNum = LoginUserInfoVOAssembler.getLoginDivisionVistaProviderStationNumber(kajLoginDivStNum, kajLoginDivVistaProviderInst);
        String rpcResults = null;
        try {
            RpcRequest vReq = RpcRequestFactory.getRpcRequest();
            vReq.setRpcContext("XUS KAAJEE PROXY LOGON");
            vReq.setRpcClientTimeOut(600);
            vReq.setUseProprietaryMessageFormat(true);
            vReq.setRpcName(USER_INFO_PROXY_RPC);
            vReq.getParams().setParam(1, "string", (Object)clientIp);
            vReq.getParams().setParam(2, "string,", (Object)ConfigurationVO.getInstance().getHostApplicationName());
            vistaToken = VistaKernelHash.encrypt((String)("~~TOK~~" + vistaToken), (boolean)true);
            vReq.getParams().setParam(3, "string", (Object)vistaToken);
            RpcResponse vResp = myConnection.executeRPC(vReq);
            rpcResults = vResp.getResults();
        }
        catch (SecurityUserAuthorizationException e) {
            String exceptionString = "Authorization failed for your user account on the M system; could not log you on.<br>&nbsp;<br>Please contact your site manager for assistance.<br>&nbsp;<br>More details below:<br>&nbsp;<br>";
            throw new KaajeeException(exceptionString, (Exception)((Object)e));
        }
        catch (SecurityTooManyInvalidLoginAttemptsFaultException e) {
            StringBuffer sb = new StringBuffer("Login failed due to too many invalid login attempts.<br>&nbsp;<br>Please contact your site manager for assistance.<br>&nbsp;<br>More details below:<br>&nbsp;<br>");
            sb.append(e.getMessage());
            if (log.isErrorEnabled()) {
                log.error((Object)sb.toString(), (Throwable)e);
            }
            throw new KaajeeException(sb.toString(), (Exception)((Object)e));
        }
        catch (SecurityUserVerifyCodeException e) {
            String exceptionString = "Your verify code has expired or needs changing; could not log you on.<br>&nbsp;<br>Please use another application to change your verify code and then try to log on again here. Or, contact your site manager for assistance.";
            throw new KaajeeException(exceptionString);
        }
        catch (SecurityAccessVerifyCodePairInvalidException e) {
            String exceptionString = "Not a valid ACCESS CODE/VERIFY CODE pair.";
            throw new KaajeeException(exceptionString);
        }
        catch (LoginsDisabledFaultException e) {
            String exceptionString = "Logins are disabled on the M system.";
            throw new KaajeeException(exceptionString);
        }
        catch (SecurityIdentityDeterminationFaultException e) {
            StringBuffer sb = new StringBuffer("Could not match you with your M account; could not log you on.<br>&nbsp;<br>Please contact your site manager for assistance.<br>&nbsp;<br>More details below:<br>&nbsp;<br>");
            sb.append(e.getMessage());
            if (log.isErrorEnabled()) {
                log.error((Object)sb.toString(), (Throwable)e);
            }
            throw new KaajeeException(sb.toString(), (Exception)((Object)e));
        }
        catch (SecurityDivisionDeterminationFaultException e) {
            StringBuffer sb = new StringBuffer("The institution/division you selected for login is not valid for your M user account; could not log you on.<br>&nbsp;<br>Please contact your site manager for assistance.<br>&nbsp;<br>More details below:<br>&nbsp;<br>");
            sb.append(e.getMessage());
            if (log.isErrorEnabled()) {
                log.error((Object)sb.toString(), (Throwable)e);
            }
            throw new KaajeeException(sb.toString(), (Exception)((Object)e));
        }
        catch (FoundationsException e) {
            StringBuffer sb = new StringBuffer("Error logging on or retrieving user information; could not log you on.<br>&nbsp;<br>Please contact your site manager for assistance.<br>&nbsp;<br>More details below:<br>&nbsp;<br>");
            sb.append(e.getMessage());
            if (log.isErrorEnabled()) {
                log.error((Object)sb.toString(), (Throwable)e);
            }
            throw new KaajeeException(sb.toString(), (Exception)((Object)e));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("results of XUS KAAJEE GET USER INFO CCOW: " + rpcResults));
        }
        returnVal = new LoginUserInfoVO();
        StringTokenizer st = new StringTokenizer(rpcResults, "\n");
        returnVal.setUserDuz(st.nextToken());
        returnVal.setUserName01(st.nextToken());
        returnVal.setUserNameDisplay(st.nextToken());
        returnVal.setUserLastName(st.nextToken());
        returnVal.setUserFirstName(st.nextToken());
        returnVal.setUserMiddleName(st.nextToken());
        returnVal.setUserPrefix(st.nextToken());
        returnVal.setUserSuffix(st.nextToken());
        returnVal.setUserDegree(st.nextToken());
        returnVal.setLoginStationNumber(kajLoginDivStNum);
        String mLoginInstitutionStationNumber = st.nextToken();
        if (!kajLoginDivStNum.equals(mLoginInstitutionStationNumber) && log.isErrorEnabled()) {
            StringBuffer sb = new StringBuffer("Warning: For User DUZ: '");
            sb.append(returnVal.getUserDuz());
            sb.append("KAAJEE login division '");
            sb.append(kajLoginDivStNum);
            sb.append("' is different than M login division DUZ(2) value '");
            sb.append(mLoginInstitutionStationNumber);
            sb.append("'.");
            log.error((Object)sb.toString());
        }
        String mLoginDivParentStNum = st.nextToken();
        String kajLoginDivParentStNum = LoginUserInfoVOAssembler.getParentStationNumber(kajLoginDivInst, mLoginDivParentStNum);
        returnVal.setUserParentAdministrativeFacilityStationNumber(kajLoginDivParentStNum);
        if (!kajLoginDivParentStNum.equals(mLoginDivParentStNum) && log.isErrorEnabled()) {
            StringBuffer sb = new StringBuffer("Warning: For Login Station# '");
            sb.append(kajLoginDivStNum);
            sb.append("' the SDS Administrative Parent Station# '");
            sb.append(kajLoginDivParentStNum);
            sb.append("' does not match the value returned from M: '");
            sb.append(mLoginDivParentStNum);
            sb.append("'.");
            log.error((Object)sb.toString());
        }
        String mLoginDivVistaProviderStNum = st.nextToken();
        returnVal.setUserParentComputerSystemStationNumber(kajLoginDivVistaProviderStNum);
        if (!kajLoginDivVistaProviderStNum.equals(mLoginDivVistaProviderStNum) && log.isErrorEnabled()) {
            StringBuffer sb = new StringBuffer("Warning: For Login Station# '");
            sb.append(kajLoginDivStNum);
            sb.append("' the SDS VistaProvider Station# '");
            sb.append(kajLoginDivVistaProviderStNum);
            sb.append("' does not match the value returned from M: '");
            sb.append(mLoginDivVistaProviderStNum);
            sb.append("'.");
            log.error((Object)sb.toString());
        }
        returnVal.setSignonLogIen(st.nextToken());
        TreeMap<String, VistaDivisionVO> newPersonDivisions = new TreeMap<String, VistaDivisionVO>();
        int divCount = Integer.parseInt(st.nextToken());
        for (int i = 0; i < divCount; ++i) {
            VistaDivisionVO foundDivision = LoginUserInfoVOAssembler.getDivisionInfo(st.nextToken());
            if (!retrieveNewPersonDivisions) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found division: " + foundDivision.toString()));
            }
            newPersonDivisions.put(foundDivision.getNumber(), foundDivision);
        }
        if (retrieveNewPersonDivisions) {
            LoginUserInfoDivisionFilters.sameVistaProviderFilter(kajLoginDivStNum, newPersonDivisions, returnVal.getUserDuz());
            returnVal.setPermittedDivisons(newPersonDivisions);
        }
        if (retrieveComputingFacilityDivisions) {
            TreeMap<String, VistaDivisionVO> cfDivisionsMap = LoginUserInfoVOAssembler.getComputingFacilityDivisions(kajLoginDivVistaProviderInst, kajLoginDivInst);
            returnVal.setLoginDivisionVistaProviderDivisions(cfDivisionsMap);
        }
        String rpcResults2 = null;
        VistaLinkConnection myConnection2 = null;
        try {
            VistaLinkDuzConnectionSpec connSpec = new VistaLinkDuzConnectionSpec(kajLoginDivStNum, returnVal.getUserDuz());
            myConnection2 = LoginControllerUtils.getVistaLinkConnection(kajLoginDivStNum, (VistaLinkConnectionSpec)connSpec);
            RpcRequest vReq2 = RpcRequestFactory.getRpcRequest();
            vReq2.setRpcContext("XUS KAAJEE WEB LOGON");
            vReq2.setRpcClientTimeOut(600);
            vReq2.setTimeOut(5000);
            vReq2.setUseProprietaryMessageFormat(true);
            vReq2.setRpcName(KERNEL_USER_INFO_RPC);
            RpcResponse vResp2 = myConnection2.executeRPC(vReq2);
            rpcResults2 = vResp2.getResults();
        }
        catch (SecurityUserAuthorizationException e) {
            try {
                String exceptionString = "Authorization failed for your user account on the M system; could not log you on.<br>&nbsp;<br>Please contact your site manager for assistance.<br>&nbsp;<br>More details below:<br>&nbsp;<br>";
                throw new KaajeeException(exceptionString, (Exception)((Object)e));
                catch (SecurityTooManyInvalidLoginAttemptsFaultException e2) {
                    StringBuffer sb = new StringBuffer("Login failed due to too many invalid login attempts.<br>&nbsp;<br>Please contact your site manager for assistance.<br>&nbsp;<br>More details below:<br>&nbsp;<br>");
                    sb.append(e2.getMessage());
                    if (log.isErrorEnabled()) {
                        log.error((Object)sb.toString(), (Throwable)e2);
                    }
                    throw new KaajeeException(sb.toString(), (Exception)((Object)e2));
                }
                catch (SecurityUserVerifyCodeException e3) {
                    exceptionString = "Your verify code has expired or needs changing; could not log you on.<br>&nbsp;<br>Please use another application to change your verify code and then try to log on again here. Or, contact your site manager for assistance.";
                    throw new KaajeeException(exceptionString);
                }
                catch (SecurityAccessVerifyCodePairInvalidException e4) {
                    exceptionString = "Not a valid ACCESS CODE/VERIFY CODE pair.";
                    throw new KaajeeException(exceptionString);
                }
                catch (LoginsDisabledFaultException e5) {
                    exceptionString = "Logins are disabled on the M system.";
                    throw new KaajeeException(exceptionString);
                }
                catch (SecurityIdentityDeterminationFaultException e6) {
                    StringBuffer sb = new StringBuffer("Could not match you with your M account; could not log you on.<br>&nbsp;<br>Please contact your site manager for assistance.<br>&nbsp;<br>More details below:<br>&nbsp;<br>");
                    sb.append(e6.getMessage());
                    if (log.isErrorEnabled()) {
                        log.error((Object)sb.toString(), (Throwable)e6);
                    }
                    throw new KaajeeException(sb.toString(), (Exception)((Object)e6));
                }
                catch (SecurityDivisionDeterminationFaultException e7) {
                    StringBuffer sb = new StringBuffer("The institution/division you selected for login is not valid for your M user account; could not log you on.<br>&nbsp;<br>Please contact your site manager for assistance.<br>&nbsp;<br>More details below:<br>&nbsp;<br>");
                    sb.append(e7.getMessage());
                    if (log.isErrorEnabled()) {
                        log.error((Object)sb.toString(), (Throwable)e7);
                    }
                    throw new KaajeeException(sb.toString(), (Exception)((Object)e7));
                }
                catch (FoundationsException e8) {
                    StringBuffer sb = new StringBuffer("Error logging on or retrieving user information; could not log you on.<br>&nbsp;<br>Please contact your site manager for assistance.<br>&nbsp;<br>More details below:<br>&nbsp;<br>");
                    sb.append(e8.getMessage());
                    if (log.isErrorEnabled()) {
                        log.error((Object)sb.toString(), (Throwable)e8);
                    }
                    throw new KaajeeException(sb.toString(), (Exception)((Object)e8));
                }
            }
            catch (Throwable throwable) {
                LoginControllerUtils.closeVistaLinkConnection(myConnection2);
                throw throwable;
            }
        }
        LoginControllerUtils.closeVistaLinkConnection(myConnection2);
        log.debug((Object)("XUS GET USER INFO CCOW results:\n" + rpcResults2));
        String[] sToks = rpcResults2.split("\\n");
        int i = 0;
        while (true) {
            if (i >= sToks.length) {
                LoginUserInfoVOAssembler.tidyUpNullNameValues(returnVal);
                return returnVal;
            }
            String value = sToks[i];
            switch (i) {
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    String[] val = value.split("\\^");
                    returnVal.setDivisionName(val[1]);
                    returnVal.setDivisionIEN(value.replace('^', '|'));
                    break;
                }
                case 4: {
                    returnVal.setUserTitle(value);
                    break;
                }
                case 5: {
                    returnVal.setUserServiceSection(value);
                    break;
                }
                case 6: {
                    returnVal.setLanguage(value);
                    break;
                }
                case 7: {
                    returnVal.setDateTime(value);
                    break;
                }
                case 8: {
                    returnVal.setUserVpid(value);
                    break;
                }
            }
            ++i;
        }
    }

    private static TreeMap<String, VistaDivisionVO> getComputingFacilityDivisions(Institution kajLoginDivVistaProviderInst, Institution kajLoginDivInst) throws KaajeeException {
        TreeMap<String, VistaDivisionVO> cfDivisionsMap = new TreeMap<String, VistaDivisionVO>();
        Institution[] instList = kajLoginDivVistaProviderInst.getChildren();
        if (log.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer("Retrieved ");
            sb.append(instList.length);
            sb.append(" child divisions for Login Division ");
            sb.append(kajLoginDivInst.getStationNumber());
            sb.append("'s Computing Provider system ");
            sb.append(kajLoginDivVistaProviderInst.getStationNumber());
            sb.append(".");
            log.debug((Object)sb.toString());
        }
        for (int i = 0; i < instList.length; ++i) {
            if (log.isDebugEnabled()) {
                StringBuffer sb = new StringBuffer("child division station #: ");
                sb.append(instList[i].getStationNumber());
                sb.append(" name: ");
                sb.append(instList[i].getName());
                log.debug((Object)sb.toString());
            }
            String stNum = instList[i].getStationNumber();
            String stName = instList[i].getName();
            Institution instVistaProvider = instList[i].getVistaProvider();
            if (instVistaProvider == null || stNum == null || stName == null) continue;
            String stVistaProviderStNum = instVistaProvider.getStationNumber();
            if (stVistaProviderStNum == null) {
                stVistaProviderStNum = "";
            }
            if (!kajLoginDivVistaProviderInst.getStationNumber().equals(stVistaProviderStNum)) {
                if (!log.isDebugEnabled()) continue;
                StringBuffer sb = new StringBuffer("Filtered out child division because its computing facility '");
                sb.append(stVistaProviderStNum);
                sb.append("' does not match the computing facility '");
                sb.append(kajLoginDivVistaProviderInst.getStationNumber());
                sb.append("' of the login division ");
                sb.append(kajLoginDivInst.getStationNumber());
                log.debug((Object)sb.toString());
                continue;
            }
            VistaDivisionVO newDiv = new VistaDivisionVO();
            newDiv.setNumber(stNum);
            newDiv.setName(stName);
            cfDivisionsMap.put(stNum, newDiv);
        }
        if (!cfDivisionsMap.containsKey(kajLoginDivInst.getStationNumber())) {
            VistaDivisionVO loginDiv = new VistaDivisionVO();
            loginDiv.setNumber(kajLoginDivInst.getStationNumber());
            loginDiv.setName(kajLoginDivInst.getName());
            cfDivisionsMap.put(kajLoginDivInst.getStationNumber(), loginDiv);
        }
        return cfDivisionsMap;
    }

    private static VistaDivisionVO getDivisionInfo(String rawDivInfo) {
        VistaDivisionVO returnVal = new VistaDivisionVO();
        int pos1 = rawDivInfo.indexOf(94);
        int pos2 = rawDivInfo.indexOf(94, pos1 + 1);
        int pos3 = rawDivInfo.indexOf(94, pos2 + 1);
        returnVal.setName(rawDivInfo.substring(pos1 + 1, pos2));
        returnVal.setNumber(rawDivInfo.substring(pos2 + 1, pos3));
        if ("1".equals(rawDivInfo.substring(pos3 + 1, rawDivInfo.length()))) {
            returnVal.setIsDefault(true);
        }
        return returnVal;
    }

    private static String getParentStationNumber(Institution kajLoginDivInst, String mParentStationNumber) {
        String returnVal = "";
        String kajLoginDivParentStNum = "";
        Institution kajLoginDivParentInst = kajLoginDivInst.getParent();
        if (kajLoginDivParentInst != null) {
            kajLoginDivParentStNum = kajLoginDivParentInst.getStationNumber();
            if (kajLoginDivParentStNum != null && kajLoginDivParentStNum.length() > 0) {
                returnVal = kajLoginDivParentStNum;
                if (!returnVal.equals(mParentStationNumber) && log.isErrorEnabled()) {
                    StringBuffer sb = new StringBuffer("Warning: for the login division '");
                    sb.append(kajLoginDivInst.getStationNumber());
                    sb.append("' the SDS Parent Division# '");
                    sb.append(kajLoginDivParentStNum);
                    sb.append("' is different than the parent division returned from M, which is: '");
                    sb.append(mParentStationNumber);
                    sb.append("'. Using the SDS Parent Division.");
                    log.error((Object)sb.toString());
                }
            } else if (kajLoginDivInst.getStationNumber().equals(mParentStationNumber) && kajLoginDivInst.getChildren().length > 0) {
                returnVal = kajLoginDivInst.getStationNumber();
            } else if (log.isErrorEnabled()) {
                StringBuffer sb = new StringBuffer("Could not determine parent station number for login station# '");
                sb.append(kajLoginDivInst.getStationNumber());
                sb.append("' the SDS Parent Division# '");
                sb.append(kajLoginDivParentStNum);
                sb.append("' has no children, or the login division is different than the parent division returned from M, which is: '");
                sb.append(mParentStationNumber);
                sb.append("'.");
                log.error((Object)sb.toString());
            }
        }
        return returnVal;
    }

    private static void tidyUpNullNameValues(LoginUserInfoVO userInfo) {
        if (userInfo.getUserLastName().equals("^")) {
            userInfo.setUserLastName("");
        }
        if (userInfo.getUserFirstName().equals("^")) {
            userInfo.setUserFirstName("");
        }
        if (userInfo.getUserMiddleName().equals("^")) {
            userInfo.setUserMiddleName("");
        }
        if (userInfo.getUserPrefix().equals("^")) {
            userInfo.setUserPrefix("");
        }
        if (userInfo.getUserSuffix().equals("^")) {
            userInfo.setUserSuffix("");
        }
        if (userInfo.getUserDegree().equals("^")) {
            userInfo.setUserDegree("");
        }
    }

    private static Institution getLoginDivisionVistaProviderInstitution(String loginStationNumber, Institution kajLoginDivInst) throws KaajeeException {
        Institution kajLoginDivVistaProviderInst = kajLoginDivInst.getVistaProvider();
        if (kajLoginDivInst == null) {
            StringBuffer sb = new StringBuffer("Vista Provider institution could not be retrieved for login division: '");
            sb.append(loginStationNumber);
            sb.append("'.");
            throw new KaajeeException(sb.toString());
        }
        return kajLoginDivVistaProviderInst;
    }

    private static String getLoginDivisionVistaProviderStationNumber(String loginStationNumber, Institution loginDivisionVistaProviderInst) throws KaajeeException {
        String kajLoginDivVistaProviderStNum = loginDivisionVistaProviderInst.getStationNumber();
        if (kajLoginDivVistaProviderStNum == null || kajLoginDivVistaProviderStNum.length() < 1) {
            StringBuffer sb = new StringBuffer("Vista Provider station # could not be identified for login division: '");
            sb.append(loginStationNumber);
            sb.append("'.");
            throw new KaajeeException(sb.toString());
        }
        return kajLoginDivVistaProviderStNum;
    }
}

