/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.kaajee.jboss.security.auth;

import gov.va.med.authentication.kernel.KaajeeException;
import gov.va.med.lom.kaajee.jboss.security.auth.ConfigurationVO;
import gov.va.med.lom.kaajee.jboss.security.auth.DivisionWithVistaProviderVO;
import gov.va.med.lom.kaajee.jboss.security.auth.LoginControllerUtils;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LoginUserInfoDivisionFilters {
    private static final Log log = LogFactory.getLog(LoginUserInfoDivisionFilters.class);

    LoginUserInfoDivisionFilters() {
    }

    static void isDivisionConfiguredInKaajeeFilter(String loginDivisionStationNumber, TreeMap<?, ?> divisionMap, String userDuz, ConfigurationVO configVO) {
        Set<?> keySet = divisionMap.keySet();
        Iterator<?> it = keySet.iterator();
        while (it.hasNext()) {
            String stationNumber = (String)it.next();
            if (configVO.isKaajeeLoginDivision(stationNumber)) continue;
            it.remove();
            if (!log.isErrorEnabled()) continue;
            StringBuffer sb = new StringBuffer("Division '");
            sb.append(stationNumber);
            sb.append("' in New Person file for user DUZ '");
            sb.append(userDuz);
            sb.append("' at facility '");
            sb.append(loginDivisionStationNumber);
            sb.append("' not configured as a KAAJEE login division. Not adding to permitted divisions.");
            log.error((Object)sb.toString());
        }
    }

    static void sameVistaProviderFilter(String loginDivisionStationNumber, TreeMap<?, ?> divisionMap, String userDuz) throws KaajeeException {
        DivisionWithVistaProviderVO loginDiv;
        if (log.isDebugEnabled()) {
            log.debug((Object)"In sameVistaProviderFilter.");
        }
        if (loginDivisionStationNumber == null || loginDivisionStationNumber.length() == 0) {
            divisionMap.clear();
            StringBuffer sb = new StringBuffer("For user DUZ '");
            sb.append(userDuz);
            sb.append("', Login Division Station Number parameter was null or of length 0. Removing all divisions from the user division list.");
            throw new KaajeeException(sb.toString());
        }
        try {
            loginDiv = LoginControllerUtils.getValidatedVistaProvider(loginDivisionStationNumber);
        }
        catch (KaajeeException e) {
            divisionMap.clear();
            throw new KaajeeException("Login Division Number passed to sameVistaProviderFilter was invalid.", (Exception)((Object)e));
        }
        Set<?> keySet = divisionMap.keySet();
        Iterator<?> it = keySet.iterator();
        while (it.hasNext()) {
            StringBuffer sb;
            DivisionWithVistaProviderVO candidateDiv;
            String stationNumber = (String)it.next();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Processing station # " + stationNumber));
            }
            try {
                candidateDiv = LoginControllerUtils.getValidatedVistaProvider(stationNumber);
            }
            catch (KaajeeException e) {
                it.remove();
                if (!log.isErrorEnabled()) continue;
                StringBuffer sb2 = new StringBuffer("Division '");
                sb2.append(stationNumber);
                sb2.append("' in New Person file for user DUZ '");
                sb2.append(userDuz);
                sb2.append("' at facility '");
                sb2.append(loginDiv.getDivisionStationNumber());
                sb2.append("' not valid as a permitted division. ");
                log.error((Object)sb2.toString(), (Throwable)((Object)e));
                continue;
            }
            if (!loginDiv.getVistaProviderStationNumber().equals(candidateDiv.getVistaProviderStationNumber())) {
                it.remove();
                if (!log.isErrorEnabled()) continue;
                sb = new StringBuffer("Division '");
                sb.append(candidateDiv.getDivisionStationNumber());
                sb.append("' in New Person file for user DUZ '");
                sb.append(userDuz);
                sb.append("' at facility '");
                sb.append(loginDiv.getDivisionStationNumber());
                sb.append("' has a different Vista Provider (");
                sb.append(candidateDiv.getVistaProviderStationNumber());
                sb.append(") identified in Institution table that identified for the login system: (");
                sb.append(loginDiv.getVistaProviderStationNumber());
                sb.append("). Not adding to permitted divisions.");
                log.error((Object)sb.toString());
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            sb = new StringBuffer("Accepted division: '");
            sb.append(candidateDiv.getDivisionStationNumber());
            sb.append("' from New Person file for user DUZ '");
            sb.append(userDuz);
            sb.append("' with Vista Provider station number: '");
            sb.append(candidateDiv.getVistaProviderStationNumber());
            sb.append("' and Login station number: ");
            sb.append(loginDiv.getDivisionStationNumber());
            sb.append("' and Login station Vista Provider station number: '");
            sb.append(loginDiv.getVistaProviderStationNumber());
            sb.append("'.");
            log.debug((Object)sb.toString());
        }
    }
}

