/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.kaajee.jboss.security.auth;

import gov.va.med.authentication.kernel.KaajeeException;
import gov.va.med.authentication.kernel.KaajeeInstitutionResourceException;
import gov.va.med.authentication.kernel.LoginUserInfoVO;
import gov.va.med.lom.kaajee.jboss.model.json.LoginUserInfoVOJson;
import gov.va.med.lom.kaajee.jboss.security.auth.ConfigurationVO;
import gov.va.med.lom.kaajee.jboss.security.auth.DivisionWithVistaProviderVO;
import gov.va.med.term.access.Institution;
import gov.va.med.vistalink.adapter.cci.VistaLinkConnection;
import gov.va.med.vistalink.adapter.cci.VistaLinkConnectionFactory;
import gov.va.med.vistalink.adapter.cci.VistaLinkConnectionSpec;
import gov.va.med.vistalink.institution.InstitutionMapNotInitializedException;
import gov.va.med.vistalink.institution.InstitutionMappingDelegate;
import gov.va.med.vistalink.institution.InstitutionMappingNotFoundException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.resource.cci.ConnectionSpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class LoginControllerUtils {
    private static Log log = LogFactory.getLog(LoginControllerUtils.class);
    static final String J_PASSWORD_PREFIX_WEB = "WEB";
    static final String J_PASSWORD_PREFIX_CACTUS = "TST";
    static final String J_USERNAME_DUZ = "DUZ_";
    static final String J_USERNAME_COMPSYS = "~CMPSYS_";

    LoginControllerUtils() {
    }

    static void closeVistaLinkConnection(VistaLinkConnection myConnection) {
        if (myConnection != null) {
            try {
                myConnection.close();
            }
            catch (ResourceException resourceException) {
                // empty catch block
            }
        }
    }

    static void checkFormInputValues(String institution, String access, String verify) throws KaajeeException {
        if (institution == null || access == null || verify == null || institution.length() < 1 || access.length() < 1 || verify.length() < 1) {
            StringBuffer sb = new StringBuffer("Problem with submitted login information: ");
            if (access == null || access.length() < 1) {
                sb.append("Access code not provided");
            }
            if (verify == null || verify.length() < 1) {
                if (sb.length() > 0) {
                    sb.append("; ");
                }
                sb.append("Verify code not provided");
            }
            if (institution == null || institution.length() < 1) {
                if (sb.length() > 0) {
                    sb.append("; ");
                }
                sb.append("Login facility not provided");
            }
            sb.append(".");
            throw new KaajeeException(sb.toString());
        }
    }

    static void validateKaajeeLoginDivision(String institutionStNum) throws KaajeeInstitutionResourceException, KaajeeException {
        log.debug((Object)("validating stationNo:  " + institutionStNum));
        LoginControllerUtils.getValidatedVistaProvider(institutionStNum);
        ConfigurationVO configVO = ConfigurationVO.getInstance();
        if (!configVO.isKaajeeLoginDivision(institutionStNum)) {
            StringBuffer sb = new StringBuffer("Selected Login Division '");
            sb.append(institutionStNum);
            sb.append("' not configured in KAAJEE for login.");
            throw new KaajeeException(sb.toString());
        }
    }

    static VistaLinkConnection getVistaLinkConnection(String institution, VistaLinkConnectionSpec connectionSpec) throws KaajeeException {
        VistaLinkConnection myConnection = null;
        try {
            String jndiConnectionName = "java:/" + InstitutionMappingDelegate.getJndiConnectorNameForInstitution((String)institution);
            log.debug((Object)("jndiConnectionName: " + jndiConnectionName));
            InitialContext context = new InitialContext();
            VistaLinkConnectionFactory cf = (VistaLinkConnectionFactory)context.lookup(jndiConnectionName);
            myConnection = (VistaLinkConnection)cf.getConnection((ConnectionSpec)connectionSpec);
        }
        catch (NamingException e) {
            LoginControllerUtils.closeVistaLinkConnection(myConnection);
            StringBuffer sb = new StringBuffer("Naming exception; Could not get a connection from connector pool for institution '");
            sb.append(institution);
            sb.append("'.");
            throw new KaajeeException(sb.toString(), e);
        }
        catch (ResourceException e) {
            LoginControllerUtils.closeVistaLinkConnection(myConnection);
            StringBuffer sb = new StringBuffer("Could not get a connection from connector pool for institution '");
            sb.append(institution);
            sb.append("'.");
            throw new KaajeeException(sb.toString(), (Exception)((Object)e));
        }
        catch (InstitutionMapNotInitializedException e) {
            StringBuffer sb = new StringBuffer("Institution mapping not initialized. Could not get a connection from connector pool for institution '");
            sb.append(institution);
            sb.append("'.");
            throw new KaajeeException(sb.toString(), (Exception)((Object)e));
        }
        catch (InstitutionMappingNotFoundException e) {
            LoginControllerUtils.closeVistaLinkConnection(myConnection);
            StringBuffer sb = new StringBuffer("Institution Mapping not found for institution '");
            sb.append(institution);
            sb.append("'. Could not get a connection from connector pool for institution.");
            throw new KaajeeException(sb.toString(), (Exception)((Object)e));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"got connection.");
        }
        return myConnection;
    }

    static DivisionWithVistaProviderVO getValidatedVistaProvider(String divisionStationNumber) throws KaajeeInstitutionResourceException, KaajeeException {
        Institution loginInst = null;
        try {
            loginInst = Institution.factory.obtainByStationNumber(divisionStationNumber);
        }
        catch (Throwable t) {
            log.error((Object)"some error occurred", t);
            StringBuffer sb = new StringBuffer("Institution validation error: Could not retrieve institution from Institution table. ");
            sb.append(t.getMessage());
            throw new KaajeeInstitutionResourceException(sb.toString());
        }
        if (loginInst == null) {
            StringBuffer sb = new StringBuffer("Institution validation error: Could not find specified division station number in Institution table: '");
            sb.append(divisionStationNumber);
            sb.append("'.");
            throw new KaajeeException(sb.toString());
        }
        Institution vistaProviderInst = loginInst.getVistaProvider();
        if (vistaProviderInst == null) {
            StringBuffer sb = new StringBuffer("Institution validation error: Could not retrieve Vista Provider institution for specified division station number in Institution table: '");
            sb.append(divisionStationNumber);
            sb.append("'.");
            throw new KaajeeException(sb.toString());
        }
        String vistaProviderInstStNum = vistaProviderInst.getStationNumber();
        if (vistaProviderInstStNum == null || vistaProviderInstStNum.length() == 0) {
            StringBuffer sb = new StringBuffer("Institution validation error: Vista Provider institution station number is null in Institution table, for specified division station number: '");
            sb.append(divisionStationNumber);
            sb.append("'.");
            throw new KaajeeException(sb.toString());
        }
        DivisionWithVistaProviderVO returnVal = new DivisionWithVistaProviderVO();
        returnVal.setDivisionStationNumber(divisionStationNumber);
        returnVal.setVistaProviderStationNumber(vistaProviderInstStNum);
        return returnVal;
    }

    public static LoginUserInfoVOJson mapJson(LoginUserInfoVO userInfo, Institution inst) {
        LoginUserInfoVOJson json = new LoginUserInfoVOJson();
        json.setUserDuz(userInfo.getUserDuz());
        json.setUserName01(userInfo.getUserName01());
        json.setUserNameDisplay(userInfo.getUserNameDisplay());
        json.setUserLoginStationNumber(inst.getStationNumber());
        json.setUserParentAdministrativeFacilityStationNumber(userInfo.getUserParentAdministrativeFacilityStationNumber());
        json.setUserParentComputerSystemStationNumber(userInfo.getUserParentComputerSystemStationNumber());
        json.setUserLastName(userInfo.getUserLastName());
        json.setUserFirstName(userInfo.getUserFirstName());
        json.setUserMiddleName(userInfo.getUserMiddleName());
        json.setUserPrefix(userInfo.getUserPrefix());
        json.setUserSuffix(userInfo.getUserSuffix());
        json.setUserDegree(userInfo.getUserDegree());
        json.setSignonLogIen(userInfo.getSignonLogIen());
        json.setUserLoginStationName(inst.getVistaName());
        return json;
    }
}

