/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.kaajee.jboss.security.auth;

import gov.va.med.authentication.kernel.KaajeeVistaLinkConnectionSpec;
import gov.va.med.authentication.kernel.LoginUserInfoVO;
import gov.va.med.lom.kaajee.jboss.model.KaajeeGroup;
import gov.va.med.lom.kaajee.jboss.model.KaajeePrincipal;
import gov.va.med.lom.kaajee.jboss.model.json.LoginUserInfoVOJson;
import gov.va.med.lom.kaajee.jboss.security.auth.LoginControllerUtils;
import gov.va.med.lom.kaajee.jboss.security.auth.LoginUserInfoVOAssembler;
import gov.va.med.lom.kaajee.jboss.security.auth.RoleUtilsAjax;
import gov.va.med.term.access.Institution;
import gov.va.med.vistalink.adapter.cci.VistaLinkCcowConnectionSpec;
import gov.va.med.vistalink.adapter.cci.VistaLinkConnection;
import gov.va.med.vistalink.adapter.cci.VistaLinkConnectionSpec;
import gov.va.med.vistalink.adapter.cci.VistaLinkDuzConnectionSpec;
import java.io.IOException;
import java.security.Principal;
import java.security.acl.Group;
import java.util.List;
import java.util.Map;
import javax.resource.ResourceException;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import javax.security.jacc.PolicyContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.security.auth.spi.AbstractServerLoginModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KaajeeLoginModule
extends AbstractServerLoginModule {
    public static final String LOGIN_RPC_CONTEXT = "XUS KAAJEE WEB LOGON";
    public static final String DEFAULT_ROLE = "AUTHENTICATED_KAAJEE_USER";
    private static final Log log = LogFactory.getLog(KaajeeLoginModule.class);
    private KaajeePrincipal user;
    private List<KaajeePrincipal> roles;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, sharedState, options);
    }

    public boolean login() throws LoginException {
        String access = null;
        String verify = null;
        String vistaToken = null;
        String userDuz = null;
        this.loginOk = false;
        try {
            String av;
            String[] avSplit;
            NameCallback nameCallback = new NameCallback("Username");
            PasswordCallback passwordCallback = new PasswordCallback("Password", false);
            Callback[] callbacks = new Callback[]{nameCallback, passwordCallback};
            this.callbackHandler.handle(callbacks);
            String username = nameCallback.getName();
            String password = null;
            String institution = null;
            char[] passwordChar = passwordCallback.getPassword();
            passwordCallback.clearPassword();
            if (passwordChar != null) {
                password = new String(passwordChar);
            }
            if (username != null) {
                String[] split = username.split(";");
                institution = split[0];
            }
            if ((avSplit = (av = password.toString()).split(";")).length == 2) {
                access = avSplit[0];
                verify = avSplit[1];
            } else if (av.startsWith("~")) {
                vistaToken = av;
            } else {
                userDuz = av;
            }
            HttpServletRequest request = (HttpServletRequest)PolicyContext.getContext((String)"javax.servlet.http.HttpServletRequest");
            LoginUserInfoVOJson userJson = this.processCredentialsAndLogIn(request, institution, access, verify, vistaToken, userDuz);
            if (userJson != null) {
                if (userJson.isSuccess()) {
                    this.loginOk = true;
                    return true;
                }
                this.loginOk = false;
                return false;
            }
            return false;
        }
        catch (Exception e) {
            log.error((Object)"Authentication Failed", (Throwable)e);
            return false;
        }
    }

    protected Principal getIdentity() {
        log.debug((Object)("getIdentity() returning: " + this.user.getName()));
        return this.user;
    }

    protected Group[] getRoleSets() throws LoginException {
        Group[] groups = new Group[]{new KaajeeGroup("Roles")};
        for (KaajeePrincipal role : this.roles) {
            groups[0].addMember((Principal)role);
        }
        return groups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private LoginUserInfoVOJson processCredentialsAndLogIn(HttpServletRequest request, String institution, String access, String verify, String vistaToken, String userDuz) throws ServletException, IOException {
        LoginUserInfoVOJson userJson;
        block29: {
            HttpSession session;
            VistaLinkConnection myConnection;
            block27: {
                VistaLinkDuzConnectionSpec connSpec;
                log.debug((Object)"processCredentialsAndLogIn");
                myConnection = null;
                LoginUserInfoVO userInfo = null;
                session = request.getSession(true);
                String clientIp = request.getRemoteAddr();
                userJson = null;
                userInfo = (LoginUserInfoVO)session.getAttribute("gov.va.med.authentication.kernel.LoginUserInfo");
                if (userInfo != null) {
                    log.debug((Object)"ccow");
                    String loginStationNumber = userInfo.getLoginStationNumber();
                    String duz = userInfo.getUserDuz();
                    VistaLinkDuzConnectionSpec connSpec2 = new VistaLinkDuzConnectionSpec(loginStationNumber, duz);
                    myConnection = LoginControllerUtils.getVistaLinkConnection(loginStationNumber, (VistaLinkConnectionSpec)connSpec2);
                } else if (access != null && verify != null) {
                    log.debug((Object)("1. institution=" + institution + ", access=" + access + ", verify=" + verify));
                    LoginControllerUtils.checkFormInputValues(institution, access, verify);
                    log.debug((Object)"2");
                    LoginControllerUtils.validateKaajeeLoginDivision(institution);
                    log.debug((Object)("3. clientIp=" + clientIp));
                    KaajeeVistaLinkConnectionSpec avConnSpec = new KaajeeVistaLinkConnectionSpec(institution, access, verify, clientIp);
                    myConnection = LoginControllerUtils.getVistaLinkConnection(institution, (VistaLinkConnectionSpec)avConnSpec);
                } else if (vistaToken != null) {
                    log.debug((Object)("4. vistaToken=" + vistaToken));
                    if (vistaToken.indexOf(94) > 0) {
                        userDuz = vistaToken.substring(vistaToken.indexOf(94) + 1, vistaToken.length());
                        vistaToken = vistaToken.substring(0, vistaToken.indexOf(94));
                    }
                    connSpec = new VistaLinkCcowConnectionSpec(vistaToken);
                    myConnection = LoginControllerUtils.getVistaLinkConnection(institution, (VistaLinkConnectionSpec)connSpec);
                } else {
                    log.debug((Object)("4. login via user duz=" + userDuz));
                    connSpec = new VistaLinkDuzConnectionSpec(institution, userDuz);
                    myConnection = LoginControllerUtils.getVistaLinkConnection(institution, (VistaLinkConnectionSpec)connSpec);
                }
                log.debug((Object)("5. VistaLinkConnection=" + myConnection));
                try {
                    userInfo = LoginUserInfoVOAssembler.getLoginUserInfo(myConnection, institution, clientIp);
                }
                catch (Exception e) {
                    Object connSpec3;
                    e.printStackTrace();
                    if (e.getMessage() != null && e.getMessage().indexOf("Different IP") > 0 && userDuz != null) {
                        connSpec3 = new VistaLinkDuzConnectionSpec(institution, userDuz);
                        myConnection = LoginControllerUtils.getVistaLinkConnection(institution, (VistaLinkConnectionSpec)connSpec3);
                        userInfo = LoginUserInfoVOAssembler.getLoginUserInfo(myConnection, institution, clientIp);
                    }
                    userJson = new LoginUserInfoVOJson();
                    userJson.setSuccess(false);
                    userJson.setErrors("Login Failed: " + e.getMessage());
                    connSpec3 = userJson;
                    if (myConnection != null) {
                        try {
                            myConnection.close();
                        }
                        catch (ResourceException e2) {
                            // empty catch block
                        }
                    }
                    session.setAttribute("gov.va.med.lom.authentication.kernel.LoginUserInfoJson", (Object)userJson);
                    return connSpec3;
                }
                session.setAttribute("gov.va.med.authentication.kernel.LoginUserInfo", (Object)userInfo);
                Institution loginInst = Institution.factory.obtainByStationNumber(institution);
                userJson = LoginControllerUtils.mapJson(userInfo, loginInst);
                log.debug((Object)("6. userJson=" + userJson));
                this.roles = RoleUtilsAjax.cacheUserRoles(myConnection, userJson);
                this.user = new KaajeePrincipal(userInfo.getLoginStationNumber().toString() + userInfo.getUserDuz().toString());
                userJson.setSuccess(true);
                log.debug((Object)("7. principal user:" + this.user.getName()));
                if (log.isDebugEnabled()) {
                    for (KaajeePrincipal role : this.roles) {
                        log.debug((Object)("   role: " + role.getName()));
                    }
                }
                if (myConnection == null) break block27;
                try {
                    myConnection.close();
                }
                catch (ResourceException e) {
                    // empty catch block
                }
            }
            session.setAttribute("gov.va.med.lom.authentication.kernel.LoginUserInfoJson", (Object)userJson);
            break block29;
            catch (Exception e) {
                block28: {
                    try {
                        String exceptionString = "Error processing login credentials: ";
                        log.debug((Object)exceptionString, (Throwable)e);
                        userJson = new LoginUserInfoVOJson();
                        userJson.setSuccess(false);
                        userJson.setErrors("Login Failed: " + e.getMessage());
                        e.printStackTrace();
                        if (myConnection == null) break block28;
                    }
                    catch (Throwable throwable) {
                        if (myConnection != null) {
                            try {
                                myConnection.close();
                            }
                            catch (ResourceException e3) {
                                // empty catch block
                            }
                        }
                        session.setAttribute("gov.va.med.lom.authentication.kernel.LoginUserInfoJson", userJson);
                        throw throwable;
                    }
                    try {
                        myConnection.close();
                    }
                    catch (ResourceException e4) {
                        // empty catch block
                    }
                }
                session.setAttribute("gov.va.med.lom.authentication.kernel.LoginUserInfoJson", (Object)userJson);
            }
        }
        return userJson;
    }
}

