/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.kaajee.jboss.security.auth;

import gov.va.med.lom.kaajee.jboss.security.auth.StartupController;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class InitKaajeeServlet
extends HttpServlet {
    private static Log log = LogFactory.getLog(InitKaajeeServlet.class);
    public static final String CONFIG_FILE_PARAM_NAME = "kaajee-config-file-location";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws ServletException {
        InputStream configFileStream = null;
        String configFileLocation = this.getInitParameter(CONFIG_FILE_PARAM_NAME);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Config File Location: " + configFileLocation));
        }
        if (configFileLocation == null) {
            if (log.isErrorEnabled()) {
                StringBuffer sb = new StringBuffer("KAAJEE configuration file location '");
                sb.append(configFileLocation);
                sb.append("' is null; can't retrieve KAAJEE settings.");
                log.error((Object)sb.toString());
            }
        } else {
            if (log.isDebugEnabled()) {
                StringBuffer sb = new StringBuffer("about to try to retrieve '");
                sb.append(configFileLocation);
                sb.append("'");
                log.debug((Object)sb.toString());
            }
            try {
                configFileStream = this.getServletContext().getResourceAsStream(configFileLocation);
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document configDocument = builder.parse(configFileStream);
                StartupController.doStartup(configDocument);
            }
            catch (FactoryConfigurationError e) {
                log.error((Object)"Problem reading configuration file.", (Throwable)e);
            }
            catch (ParserConfigurationException e) {
                log.error((Object)"Problem reading configuration file.", (Throwable)e);
            }
            catch (SAXException e) {
                log.error((Object)"Problem reading configuration file.", (Throwable)e);
            }
            catch (IOException e) {
                log.error((Object)"Problem reading configuration file.", (Throwable)e);
            }
            finally {
                block29: {
                    try {
                        configFileStream.close();
                    }
                    catch (IOException e) {
                        if (!log.isErrorEnabled()) break block29;
                        log.error((Object)"Problem closing input stream for KAAJEE configuration file.", (Throwable)e);
                    }
                }
            }
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        this.displayInfo(response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        this.displayInfo(response);
    }

    private void displayInfo(HttpServletResponse response) {
        block2: {
            try {
                PrintWriter out = response.getWriter();
                out.println("InitKaajeeServlet");
            }
            catch (IOException e) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)"Could not get a PrintWriter to display output.", (Throwable)e);
            }
        }
    }
}

