/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.kaajee.jboss.security.auth;

import gov.va.med.authentication.kernel.KaajeeInstitutionResourceException;
import gov.va.med.authentication.kernel.VistaDivisionVO;
import gov.va.med.term.access.Institution;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationVO {
    private static ConfigurationVO me = null;
    private String hostApplicationName;
    private String introductoryText;
    private String institutionLogonDropDownList;
    private String institutionLogonDropDownListByName;
    private TreeMap<String, VistaDivisionVO> institutionMap;
    private TreeMap<String, VistaDivisionVO> institutionMapByName;
    private String oracleDAOFactoryJndiDataSourceName;
    private String daoFactoryDatabaseChoice;
    private boolean retrieveUserNewPersonDivisions;
    private boolean retrieveComputingFacilityDivisions;
    private boolean cactusModeEnabled;
    private String contextName;
    private static Log logger = LogFactory.getLog(ConfigurationVO.class);
    private static Object syncObj = new Object();

    private ConfigurationVO(Document configDoc) {
        try {
            this.init(configDoc);
        }
        catch (KaajeeInstitutionResourceException e) {
            logger.error((Object)"Could not initialize institutions.", (Throwable)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfigurationVO getInstance() throws IllegalStateException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"In getInstance().");
        }
        Object object = syncObj;
        synchronized (object) {
            if (me == null) {
                String exceptionString = "ConfigurationVO singleton not yet initialized.";
                if (logger.isDebugEnabled()) {
                    logger.error((Object)exceptionString);
                }
                throw new IllegalStateException(exceptionString);
            }
            return me;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void createInstance(Document configDoc) throws IllegalStateException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"In createInstance().");
        }
        Object object = syncObj;
        synchronized (object) {
            if (me == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"creating a new ConfigurationVO.");
                }
            } else {
                String exceptionString = "ConfigurationVO instance already exists.";
                if (logger.isDebugEnabled()) {
                    logger.error((Object)exceptionString);
                }
                throw new IllegalStateException(exceptionString);
            }
            me = new ConfigurationVO(configDoc);
        }
    }

    private void init(Document configDoc) throws KaajeeInstitutionResourceException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"initializing.");
        }
        this.institutionMap = new TreeMap();
        this.institutionMapByName = new TreeMap();
        this.introductoryText = "[Introductory Text for the system not found. Adminstrators should fill in the KAAJEE settings file to furnish the required introductory text.]";
        this.hostApplicationName = "[unidentified application]";
        this.oracleDAOFactoryJndiDataSourceName = "";
        this.daoFactoryDatabaseChoice = "";
        this.institutionLogonDropDownList = "";
        this.retrieveComputingFacilityDivisions = false;
        this.retrieveUserNewPersonDivisions = false;
        this.cactusModeEnabled = false;
        this.contextName = "";
        if (configDoc == null) {
            logger.error((Object)"Configuration file document object was null. Can't retrieve KAAJEE settings.");
        } else {
            Node cfDivisionNode;
            NodeList cfDivisionNodeList;
            Node npDivisionNode;
            NamedNodeMap attributes;
            Attr retrieveAttr;
            NodeList npDivisionNodeList;
            NodeList jndiDataSourceNodeList;
            NodeList databaseChoiceNodeList;
            NodeList ContextNode;
            NodeList appNameNodeList = configDoc.getElementsByTagName("host-application-name");
            if (appNameNodeList.getLength() > 0) {
                this.hostApplicationName = ((Text)appNameNodeList.item(0).getFirstChild()).getData();
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("set host application name: " + this.hostApplicationName));
            }
            if ((ContextNode = configDoc.getElementsByTagName("context-root-name")).getLength() > 0) {
                this.contextName = ((Text)ContextNode.item(0).getFirstChild()).getData();
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("set ContextName  : " + this.contextName));
            }
            String rawText = "";
            StringBuffer sb = new StringBuffer();
            NodeList introTextNodeList = configDoc.getElementsByTagName("system-announcement");
            if (introTextNodeList.getLength() > 0) {
                rawText = ((Text)introTextNodeList.item(0).getFirstChild()).getData();
            }
            StringTokenizer st = new StringTokenizer(rawText, "~");
            while (st.hasMoreTokens()) {
                sb.append(st.nextToken());
                sb.append("&nbsp;<br>");
            }
            this.introductoryText = sb.toString();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("retrieved introductory text: " + this.introductoryText));
            }
            if ((databaseChoiceNodeList = configDoc.getElementsByTagName("database-choice")).getLength() > 0) {
                this.daoFactoryDatabaseChoice = ((Text)databaseChoiceNodeList.item(0).getFirstChild()).getData();
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("retrieved DAO database choice: " + this.daoFactoryDatabaseChoice));
            }
            if ((jndiDataSourceNodeList = configDoc.getElementsByTagName("database-jndi-data-source-name")).getLength() > 0) {
                this.oracleDAOFactoryJndiDataSourceName = ((Text)jndiDataSourceNodeList.item(0).getFirstChild()).getData();
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("retrieved Oracle DAO Factory JNDI DataSource Name: " + this.oracleDAOFactoryJndiDataSourceName));
            }
            if ((npDivisionNodeList = configDoc.getElementsByTagName("user-new-person-divisions")).getLength() > 0 && "retrieve".equals((retrieveAttr = (Attr)(attributes = (npDivisionNode = npDivisionNodeList.item(0)).getAttributes()).item(0)).getName()) && "true".equals(retrieveAttr.getValue())) {
                this.retrieveUserNewPersonDivisions = true;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Setting 'retrieve new person divisions' to true.");
                }
            }
            if ((cfDivisionNodeList = configDoc.getElementsByTagName("computing-facility-divisions")).getLength() > 0 && "retrieve".equals((retrieveAttr = (Attr)(attributes = (cfDivisionNode = cfDivisionNodeList.item(0)).getAttributes()).item(0)).getName()) && "true".equals(retrieveAttr.getValue())) {
                this.retrieveComputingFacilityDivisions = true;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Setting 'retrieve computing facility divisions' to true.");
                }
            }
            if ((cfDivisionNodeList = configDoc.getElementsByTagName("cactus-insecure-mode")).getLength() > 0 && "enabled".equals((retrieveAttr = (Attr)(attributes = (cfDivisionNode = cfDivisionNodeList.item(0)).getAttributes()).item(0)).getName()) && "true".equals(retrieveAttr.getValue())) {
                this.cactusModeEnabled = true;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Setting Cactus mode to True. This mode should NEVER be enabled for a production application.");
                }
            }
            NodeList institutionMappingNodeList = configDoc.getElementsByTagName("station-number");
            for (int i = 0; i < institutionMappingNodeList.getLength(); ++i) {
                String stationNumber = ((Text)institutionMappingNodeList.item(i).getFirstChild()).getData();
                String logonDisplayName = null;
                if (stationNumber == null) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)"Attempt to retrieve station number from KAAJEE configuration resulted in NULL station number.");
                    continue;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("retrieved station number from KAAJEE configuration: " + stationNumber));
                }
                Institution inst = null;
                try {
                    inst = Institution.factory.obtainByStationNumber(stationNumber);
                }
                catch (Throwable t) {
                    StringBuffer sb2 = new StringBuffer("Error retrieving institution. ");
                    sb2.append(t.getMessage());
                    throw new KaajeeInstitutionResourceException(sb2.toString());
                }
                if (inst == null) {
                    logonDisplayName = stationNumber + " [WARNING: NOT FOUND IN INSTITUTION TABLE]";
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("SDS returned null institution for station#: " + stationNumber));
                    continue;
                }
                logonDisplayName = inst.getName();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Used SDS for login display name: " + logonDisplayName));
                }
                VistaDivisionVO icdVO = new VistaDivisionVO();
                icdVO.setName(logonDisplayName);
                icdVO.setNumber(stationNumber);
                this.institutionMap.put(stationNumber, icdVO);
                this.institutionMapByName.put(logonDisplayName, icdVO);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("added new TreeMap entry: " + icdVO.toString()));
            }
            this.institutionLogonDropDownList = this.createJspDropDownListOptions();
            this.institutionLogonDropDownListByName = this.createJspDropDownListOptionsByName();
        }
    }

    public String getJspDropDownListLoginOptions() {
        return this.institutionLogonDropDownList;
    }

    public String getJspDropDownListLoginOptionsByName() {
        return this.institutionLogonDropDownListByName;
    }

    private String createJspDropDownListOptions() {
        Set<String> instSet = this.institutionMap.keySet();
        Iterator<String> instSetIterator = instSet.iterator();
        StringBuffer sb = new StringBuffer();
        try {
            while (true) {
                String stationNumber = instSetIterator.next();
                VistaDivisionVO im = this.institutionMap.get(stationNumber);
                sb.append("<OPTION value=");
                sb.append(im.getNumber());
                sb.append(">");
                sb.append(im.getName());
                sb.append(" (");
                sb.append(im.getNumber());
                sb.append(")");
                sb.append("</OPTION>\n");
            }
        }
        catch (NoSuchElementException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)sb.toString());
            }
            return sb.toString();
        }
    }

    private String createJspDropDownListOptionsByName() {
        Set<String> instSet = this.institutionMapByName.keySet();
        Iterator<String> instSetIterator = instSet.iterator();
        StringBuffer sb = new StringBuffer();
        try {
            while (true) {
                String logonDisplayName = instSetIterator.next();
                VistaDivisionVO im = this.institutionMapByName.get(logonDisplayName);
                sb.append("<OPTION value=");
                sb.append(im.getNumber());
                sb.append(">");
                sb.append(im.getName());
                sb.append(" (");
                sb.append(im.getNumber());
                sb.append(")");
                sb.append("</OPTION>\n");
            }
        }
        catch (NoSuchElementException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)sb.toString());
            }
            return sb.toString();
        }
    }

    public String getIntroductoryText() {
        return this.introductoryText;
    }

    public String getDaoFactoryDatabaseChoice() {
        return this.daoFactoryDatabaseChoice;
    }

    public String getOracleDAOFactoryJndiDataSourceName() {
        return this.oracleDAOFactoryJndiDataSourceName;
    }

    public boolean getRetrieveNewPersonDivisions() {
        return this.retrieveUserNewPersonDivisions;
    }

    public boolean getRetrieveComputingFacilityDivisions() {
        return this.retrieveComputingFacilityDivisions;
    }

    boolean isKaajeeLoginDivision(String stationNumber) {
        boolean returnVal = false;
        if (this.institutionMap.containsKey(stationNumber)) {
            returnVal = true;
        }
        return returnVal;
    }

    public boolean getIsCactusModeEnabled() {
        return this.cactusModeEnabled;
    }

    public String getHostApplicationName() {
        return this.hostApplicationName;
    }

    public String getContextName() {
        return this.contextName;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("; Database Choice: ");
        sb.append(this.getDaoFactoryDatabaseChoice());
        sb.append("Oracle JNDI Source Name: ");
        sb.append(this.getOracleDAOFactoryJndiDataSourceName());
        sb.append("Cactus Mode: ");
        sb.append(this.getIsCactusModeEnabled());
        sb.append("Retrieve computing facility divisions: ");
        sb.append(this.getRetrieveComputingFacilityDivisions());
        sb.append("; retreive NP divisions: ");
        sb.append(this.getRetrieveNewPersonDivisions());
        sb.append("; JSP Drop Down List Options: ");
        sb.append(this.getJspDropDownListLoginOptions());
        sb.append("; Introductory Text: ");
        sb.append(this.getIntroductoryText());
        return sb.toString();
    }

    public TreeMap<String, VistaDivisionVO> getInstitutionMap() {
        return this.institutionMap;
    }
}

