/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.kaajee.jboss.security.auth;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ApplicationRoleListVOSingleton {
    private static ApplicationRoleListVOSingleton me;
    private static Log log;
    private ArrayList<String> roleList;
    private static Object syncObj;

    private ApplicationRoleListVOSingleton(Document configDoc) {
        this.roleList = this.getRoleList(configDoc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ApplicationRoleListVOSingleton getInstance() throws IllegalStateException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"In getInstance().");
        }
        Object object = syncObj;
        synchronized (object) {
            if (me == null) {
                String exceptionString = "ApplicationRoleListVOSingleton not initialized.";
                if (log.isErrorEnabled()) {
                    log.error((Object)exceptionString);
                }
                throw new IllegalStateException(exceptionString);
            }
            return me;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void createInstance(Document configDoc) throws IllegalStateException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"In createInstance().");
        }
        Object object = syncObj;
        synchronized (object) {
            if (me == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Creating new singleton instance.");
                }
                me = new ApplicationRoleListVOSingleton(configDoc);
            }
        }
    }

    private ArrayList<String> getRoleList(Document configDoc) {
        ArrayList<String> roleList = new ArrayList<String>();
        NodeList groupsNodeList = configDoc.getElementsByTagName("groups");
        for (int i = 0; i < groupsNodeList.getLength(); ++i) {
            NodeList groupNodeList = groupsNodeList.item(i).getChildNodes();
            block1: for (int j = 0; j < groupNodeList.getLength(); ++j) {
                if (!"group".equals(groupNodeList.item(j).getNodeName())) continue;
                Node groupNode = groupNodeList.item(j);
                NamedNodeMap attributes = groupNode.getAttributes();
                for (int k = 0; k < attributes.getLength(); ++k) {
                    Attr attr = (Attr)attributes.item(k);
                    if (!"name".equals(attr.getName())) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("retrieved role from kaajee configuration file: " + attr.getValue()));
                    }
                    roleList.add(attr.getValue());
                    continue block1;
                }
            }
        }
        return roleList;
    }

    ArrayList<String> getRoleList() {
        return this.roleList;
    }

    static {
        log = LogFactory.getLog(ApplicationRoleListVOSingleton.class);
        syncObj = new Object();
    }
}

