/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.javaUtils.xml.objectxml;

import com.sun.msv.datatype.xsd.DatatypeFactory;
import com.sun.msv.datatype.xsd.XSDatatype;
import gov.va.med.lom.javaUtils.classloader.ClassLoaderStrategy;
import gov.va.med.lom.javaUtils.classloader.ClassLoaderUtil;
import gov.va.med.lom.javaUtils.misc.DateUtils;
import gov.va.med.lom.javaUtils.misc.StringUtils;
import gov.va.med.lom.javaUtils.xml.DOMDocument;
import gov.va.med.lom.javaUtils.xml.XMLDataTypes;
import gov.va.med.lom.javaUtils.xml.objectxml.annotations.ObjectXmlAlias;
import gov.va.med.lom.javaUtils.xml.objectxml.annotations.ObjectXmlAsAttribute;
import gov.va.med.lom.javaUtils.xml.objectxml.annotations.ObjectXmlAsValue;
import gov.va.med.lom.javaUtils.xml.objectxml.annotations.ObjectXmlOmitField;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.Stack;
import java.util.Vector;
import org.relaxng.datatype.DatatypeException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ObjectXml
extends XMLDataTypes {
    private ClassLoaderStrategy classLoaderStrategy;
    private Document document;
    private String currentName;
    private String currentPackage;
    private String currentType;
    private Bean currentBean;
    private String rootPath;
    private String classPackage;
    private Node currentNode;
    private Node parentNode;
    private Node root;
    private Stack<Bean> beansStack = new Stack();
    private Bean topLevelBean;
    private String nsPrefix = "oxml";
    private String nsURI = null;
    private DOMDocument domDocument;
    private boolean includeXmlProlog = true;
    private boolean prettyPrint = true;
    private String lineSeperator = "\n";
    private String indentChars = "  ";
    private boolean lowerCase = false;
    private boolean firstLetterUpperCase = false;
    private boolean includeTypeInfo = true;
    private boolean includeNullValues;

    public static Class getClassOfBean(ClassLoader classLoader, String clazz) {
        Class<?> cls = null;
        try {
            cls = classLoader.loadClass(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return cls;
    }

    public String getNsPrefix() {
        return this.nsPrefix;
    }

    public void setNsPrefix(String nsPrefix) {
        this.nsPrefix = nsPrefix;
    }

    public String getNsURI() {
        return this.nsURI;
    }

    public void setNsURI(String nsURI) {
        this.nsURI = nsURI;
    }

    public String getClassPackage() {
        return this.classPackage;
    }

    public void setClassPackage(String classPackage) {
        this.classPackage = classPackage;
    }

    public DOMDocument getDomDocument() {
        return this.domDocument;
    }

    public boolean isFirstLetterUpperCase() {
        return this.firstLetterUpperCase;
    }

    public void setFirstLetterUpperCase(boolean firstLetterUpperCase) {
        this.firstLetterUpperCase = firstLetterUpperCase;
    }

    public boolean getIncludeNullValues() {
        return this.includeNullValues;
    }

    public void setIncludeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
    }

    public boolean isIncludeTypeInfo() {
        return this.includeTypeInfo;
    }

    public void setIncludeTypeInfo(boolean includeTypeInfo) {
        this.includeTypeInfo = includeTypeInfo;
    }

    public boolean getIncludeXmlProlog() {
        return this.includeXmlProlog;
    }

    public void setIncludeXmlProlog(boolean includeXmlProlog) {
        this.includeXmlProlog = includeXmlProlog;
    }

    public String getIndentChars() {
        return this.indentChars;
    }

    public void setIndentChars(String indentChars) {
        this.indentChars = indentChars;
    }

    public String getLineSeperator() {
        return this.lineSeperator;
    }

    public void setLineSeperator(String lineSeperator) {
        this.lineSeperator = lineSeperator;
    }

    public boolean isLowerCase() {
        return this.lowerCase;
    }

    public void setLowerCase(boolean lowerCase) {
        this.lowerCase = lowerCase;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    public String serialize(Object bean) throws IntrospectionException, IllegalAccessException {
        String className = bean.getClass().getName();
        String rootElementName = null;
        if (bean.getClass().isAnnotationPresent(ObjectXmlAlias.class)) {
            Class<?> annotatedElement = bean.getClass();
            ObjectXmlAlias aliasAnnotation = annotatedElement.getAnnotation(ObjectXmlAlias.class);
            rootElementName = aliasAnnotation.value();
        }
        Package pkg = bean.getClass().getPackage();
        this.nsURI = pkg.getName();
        className = StringUtils.deleteTrailingChar(className, ';');
        StringBuffer sb = new StringBuffer(className);
        String objectName = sb.delete(0, sb.lastIndexOf(".") + 1).toString();
        this.domDocument = this.createDomDocument(objectName);
        this.document = this.domDocument.getDocument();
        Element root = this.document.getDocumentElement();
        this.getBeanElements(root, rootElementName, className, bean);
        StringBuffer xml = new StringBuffer();
        if (this.prettyPrint) {
            xml.append(this.domDocument.serialize(this.lineSeperator, this.indentChars, this.includeXmlProlog));
        } else {
            xml.append(this.domDocument.serialize(this.includeXmlProlog));
        }
        if (!this.includeTypeInfo) {
            int index = xml.indexOf(root.getNodeName());
            xml.delete(index - 1, index + root.getNodeName().length() + 2);
            xml.delete(xml.length() - root.getNodeName().length() - 4, xml.length());
        }
        return xml.toString();
    }

    public Object deserialize(Class rootClass, String xml) throws Exception {
        DOMDocument domDocument = new DOMDocument(xml);
        this.root = domDocument.getRootNode();
        if (this.classPackage == null || this.rootPath == null) {
            this.classLoaderStrategy = this.getClassLoaderStrategy(rootClass.getName());
        } else {
            this.currentPackage = this.classPackage;
            this.classLoaderStrategy = ClassLoaderUtil.getClassLoader(ClassLoaderUtil.FILE_SYSTEM_CLASS_LOADER, new String[]{this.rootPath});
        }
        return this.deserialize(this.root, true, true);
    }

    public Object deserialize(String xml) throws Exception {
        DOMDocument domDocument = new DOMDocument(xml);
        this.root = domDocument.getRootNode();
        if (this.classPackage == null || this.rootPath == null) {
            this.classLoaderStrategy = this.getClassLoaderStrategy(this.root.lookupNamespaceURI(this.nsPrefix) + "." + this.root.getLocalName());
        } else {
            this.currentPackage = this.classPackage;
            this.classLoaderStrategy = ClassLoaderUtil.getClassLoader(ClassLoaderUtil.FILE_SYSTEM_CLASS_LOADER, new String[]{this.rootPath});
        }
        return this.deserialize(this.root, true, true);
    }

    protected void getBeanElements(Element parentElement, String objectName, String objectType, Object bean) throws IntrospectionException, IllegalAccessException {
        Element element;
        if (objectName == null) {
            StringBuffer sb = new StringBuffer(bean.getClass().getName());
            sb.delete(0, sb.lastIndexOf(".") + 1);
            objectName = sb.toString();
        }
        if ((element = ObjectXml.getStandardObjectElement(this.document, bean, objectName)) != null) {
            if (this.includeNullValues || !element.getAttribute("xsi:type").equals("anyType")) {
                if (!this.includeTypeInfo) {
                    element.removeAttribute("xsi:type");
                    element.removeAttribute("xsi:null");
                }
                parentElement.appendChild(element);
            }
        } else {
            Class<?> classOfBean = null;
            if (bean != null) {
                classOfBean = bean.getClass();
            }
            if (classOfBean != null && classOfBean.isArray()) {
                String[] arrayInfo = ObjectXml.getXsdSoapArrayInfo(classOfBean.getCanonicalName(), this.nsPrefix);
                int arrayLen = Array.getLength(bean);
                StringBuffer arrayType = new StringBuffer(arrayInfo[1]);
                arrayType.insert(arrayType.indexOf("[]") + 1, arrayLen);
                if (objectName.charAt(objectName.length() - 1) == ';') {
                    objectName = new StringBuffer(objectName).deleteCharAt(objectName.length() - 1).toString();
                }
                element = this.document.createElement(objectName);
                parentElement.appendChild(element);
                for (int i = 0; i < arrayLen; ++i) {
                    Object b = Array.get(bean, i);
                    if (b != null) {
                        String name = null;
                        if (objectName.charAt(objectName.length() - 1) == 's') {
                            name = this.formatName(objectName.substring(0, objectName.length() - 1));
                        }
                        this.getBeanElements(element, name, b.getClass().getName(), b);
                    } else {
                        int index = arrayType.indexOf("[");
                        arrayType.replace(index + 1, index + 2, String.valueOf(--arrayLen));
                    }
                    if (!this.includeTypeInfo) continue;
                    element.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", "soapenc:Array");
                    element.setAttributeNS("http://schemas.xmlsoap.org/soap/encoding/", "soapenc:arrayType", arrayInfo[0] + ":" + arrayType.toString());
                }
            } else {
                int beanType = 0;
                String beanName = null;
                if (classOfBean != null) {
                    if (classOfBean == Vector.class) {
                        beanType = 1;
                        beanName = "Vector";
                    } else if (classOfBean == ArrayList.class) {
                        beanType = 2;
                        beanName = "ArrayList";
                    } else if (classOfBean == LinkedList.class) {
                        beanType = 3;
                        beanName = "LinkedList";
                    } else if (classOfBean == Hashtable.class) {
                        beanType = 4;
                        beanName = "Hashtable";
                    } else if (classOfBean == Properties.class) {
                        beanType = 5;
                        beanName = "Properties";
                    } else if (classOfBean == HashMap.class || classOfBean == SortedMap.class) {
                        beanType = 6;
                        beanName = "Map";
                    }
                }
                if (beanType > 0) {
                    String prefix = null;
                    if (beanType == 1 || beanType == 5) {
                        prefix = "soapenc";
                    }
                    prefix = beanType == 6 ? "apachesoap" : "lom";
                    element = this.document.createElement(objectName);
                    if (this.includeTypeInfo) {
                        element.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", prefix + ":" + beanName);
                        if (bean == null) {
                            element.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:null", "true");
                        }
                    }
                    parentElement.appendChild(element);
                    if (beanType >= 1 && beanType <= 3) {
                        AbstractCollection collection = (AbstractCollection)bean;
                        for (Object b : collection) {
                            String name = null;
                            if (b != null) {
                                name = objectName.charAt(objectName.length() - 1) == 's' ? this.formatName(objectName.substring(0, objectName.length() - 1)) : "item";
                            }
                            this.getBeanElements(element, name, b.getClass().getName(), b);
                        }
                    } else if (beanType == 4 || beanType == 5) {
                        Hashtable hashtable = (Hashtable)bean;
                        Enumeration en = hashtable.keys();
                        while (en.hasMoreElements()) {
                            Object key = en.nextElement();
                            String keyClassName = key.getClass().getName();
                            Object value = hashtable.get(key);
                            String beanClassName = null;
                            if (value != null) {
                                beanClassName = value.getClass().getName();
                            }
                            Element itemElement = this.document.createElement("item");
                            element.appendChild(itemElement);
                            this.getBeanElements(itemElement, "key", keyClassName, key);
                            this.getBeanElements(itemElement, "value", beanClassName, value);
                        }
                    } else if (beanType == 6) {
                        Map map = null;
                        if (classOfBean == HashMap.class) {
                            map = (HashMap)bean;
                        } else if (classOfBean == SortedMap.class) {
                            map = (SortedMap)bean;
                        }
                        Set set = map.keySet();
                        for (Object key : set) {
                            String keyClassName = key.getClass().getName();
                            Object value = map.get(key);
                            String beanClassName = null;
                            if (value != null) {
                                beanClassName = value.getClass().getName();
                            }
                            Element itemElement = this.document.createElement("item");
                            element.appendChild(itemElement);
                            this.getBeanElements(itemElement, "key", keyClassName, key);
                            this.getBeanElements(itemElement, "value", beanClassName, value);
                        }
                    }
                } else {
                    if (objectName.charAt(objectName.length() - 1) == ';') {
                        objectName = new StringBuffer(objectName).deleteCharAt(objectName.length() - 1).toString();
                    }
                    objectName = this.formatName(objectName);
                    element = this.document.createElement(objectName);
                    parentElement.appendChild(element);
                    if (this.includeTypeInfo) {
                        StringBuffer className = new StringBuffer(objectType);
                        element.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", this.nsPrefix + ":" + className.delete(0, className.lastIndexOf(".") + 1).toString());
                    }
                    if (classOfBean != null) {
                        BeanInfo bi = Introspector.getBeanInfo(classOfBean);
                        PropertyDescriptor[] pds = bi.getPropertyDescriptors();
                        for (int i = 0; i < pds.length; ++i) {
                            PropertyDescriptor pd = pds[i];
                            this.getBeanElementProperties(element, bean, pd);
                        }
                    } else if (this.includeTypeInfo) {
                        element.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:null", "true");
                    }
                }
            }
        }
    }

    protected void getBeanElementProperties(Element element, Object bean, PropertyDescriptor pd) throws IntrospectionException, IllegalAccessException {
        block24: {
            Object propertyElement = null;
            Class<?> classOfProperty = pd.getPropertyType();
            Object[] argsNone = new Object[]{};
            if (!(pd.getName().charAt(0) == 'c' && pd.getName().equals("class") || classOfProperty.equals(Class.class))) {
                boolean omittedField = false;
                try {
                    Field field = bean.getClass().getDeclaredField(pd.getName());
                    omittedField = field.isAnnotationPresent(ObjectXmlOmitField.class);
                }
                catch (NoSuchFieldException nsfe) {
                    // empty catch block
                }
                if (!omittedField) {
                    String propertyName = this.formatName(pd.getName());
                    Object propertyValue = null;
                    try {
                        Method getter = pd.getReadMethod();
                        if (getter != null) {
                            propertyValue = getter.invoke(bean, argsNone);
                        }
                    }
                    catch (Exception ex) {
                        System.err.println(ex.getMessage());
                    }
                    if (propertyElement == null) {
                        PropertyEditor propEditor = PropertyEditorManager.findEditor(classOfProperty);
                        if (propEditor != null || classOfProperty == Calendar.class || classOfProperty == Date.class) {
                            try {
                                Object object;
                                if (classOfProperty == Calendar.class || classOfProperty == Date.class) {
                                    object = propertyValue;
                                } else {
                                    propEditor.setValue(propertyValue);
                                    object = propEditor.getValue();
                                }
                                Element childElement = ObjectXml.getStandardObjectElement(this.document, object, propertyName);
                                if (!this.includeNullValues && childElement.getAttribute("xsi:type").equals("anyType")) break block24;
                                if (!this.includeTypeInfo) {
                                    childElement.removeAttribute("xsi:type");
                                    childElement.removeAttribute("xsi:null");
                                }
                                try {
                                    Field field = bean.getClass().getDeclaredField(propertyName);
                                    if (field.isAnnotationPresent(ObjectXmlAsAttribute.class)) {
                                        String attrName = null;
                                        attrName = this.includeTypeInfo ? this.nsPrefix + ":" + propertyName : propertyName;
                                        element.setAttribute(attrName, childElement.getFirstChild().getNodeValue());
                                    } else if (field.isAnnotationPresent(ObjectXmlAsValue.class)) {
                                        element.setTextContent(childElement.getFirstChild().getNodeValue());
                                    } else {
                                        element.appendChild(childElement);
                                    }
                                }
                                catch (NoSuchFieldException nfse) {
                                    element.appendChild(childElement);
                                }
                            }
                            catch (Exception e) {}
                        } else {
                            try {
                                String propertyTypeName = null;
                                if (propertyValue != null) {
                                    Class<?> propertyType = pd.getPropertyType();
                                    propertyTypeName = propertyType.getName();
                                }
                                this.getBeanElements(element, propertyName, propertyTypeName, propertyValue);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
        }
    }

    private DOMDocument createDomDocument(String rootName) {
        DOMDocument domDocument = new DOMDocument(this.nsURI, rootName, null);
        Document document = domDocument.getDocument();
        Element root = document.getDocumentElement();
        if (this.includeTypeInfo) {
            root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + this.nsPrefix, this.nsURI);
            root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
            root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:soapenc", "http://schemas.xmlsoap.org/soap/encoding/");
            root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:apachesoap", "http://xml.apache.org/xml-soap");
        }
        return domDocument;
    }

    private ClassLoaderStrategy getClassLoaderStrategy(String fullyQualifiedClassName) throws Exception {
        try {
            StringBuffer sb = new StringBuffer(fullyQualifiedClassName);
            sb.delete(sb.lastIndexOf("."), sb.length());
            this.currentPackage = sb.toString();
            String cp = System.getProperty("java.class.path");
            String sepChar = System.getProperty("path.separator");
            String[] paths = StringUtils.pieceList(cp, sepChar.charAt(0));
            ClassLoaderStrategy cl = ClassLoaderUtil.getClassLoader(ClassLoaderUtil.FILE_SYSTEM_CLASS_LOADER, new String[0]);
            String classpath = StringUtils.replaceChar(this.currentPackage, '.', File.separatorChar);
            for (int i = 0; i < paths.length; ++i) {
                Class[] classes = cl.getClasses(paths[i] + File.separatorChar + classpath, this.currentPackage);
                for (int j = 0; j < classes.length; ++j) {
                    if (!classes[j].getName().equals(fullyQualifiedClassName)) continue;
                    return ClassLoaderUtil.getClassLoader(ClassLoaderUtil.FILE_SYSTEM_CLASS_LOADER, new String[]{paths[i]});
                }
            }
            throw new Exception("Class could not be found.");
        }
        catch (Exception e) {
            System.err.println("Exception creating class loader strategy.");
            System.err.println(e.getMessage());
            throw e;
        }
    }

    private String formatName(String name) {
        StringBuffer propertyName = new StringBuffer();
        if (this.lowerCase) {
            propertyName.append(name.toLowerCase());
        } else {
            propertyName.append(name);
        }
        char c = propertyName.charAt(0);
        if (this.firstLetterUpperCase) {
            if (c >= 'a' && c <= 'z') {
                c = (char)(c - 32);
            }
        } else if (c >= 'A' && c <= 'Z') {
            c = (char)(c + 32);
        }
        propertyName.setCharAt(0, c);
        return propertyName.toString();
    }

    private Object pushBeanOnStack(String classPackage, String clazz) {
        try {
            Bean bean = new Bean(classPackage, clazz, this.classLoaderStrategy, this.topLevelBean);
            this.parentNode = this.currentNode;
            this.currentBean = this.beansStack.push(bean);
            return bean.getBeanObject();
        }
        catch (Exception e) {
            System.err.println("bean could not be created: " + classPackage + "." + clazz);
            return null;
        }
    }

    private Object popBeanOffStack() {
        if (this.parentNode != this.root && this.beansStack.size() > 0) {
            this.currentBean = this.beansStack.pop();
            return this.currentBean.getBeanObject();
        }
        return null;
    }

    private void setBeanProperty(String name, Object object) {
        Bean parentBean = null;
        if (this.beansStack.size() > 0) {
            parentBean = this.beansStack.peek();
            parentBean.setProperty(name, object);
        }
    }

    private Object createObject(Node node, String name, String classPackage, String type, String value, boolean setProperty) {
        Bean parentBean = null;
        if (this.beansStack.size() > 0) {
            parentBean = this.beansStack.peek();
        }
        Object object = null;
        XSDatatype dt = null;
        try {
            dt = DatatypeFactory.getTypeByName((String)type);
        }
        catch (DatatypeException dte) {
            // empty catch block
        }
        if (dt != null && value == null) {
            Class objType = dt.getJavaObjectType();
            if (objType == String.class) {
                value = "";
            } else if (objType == BigInteger.class || objType == Long.class || objType == Integer.class || objType == Short.class || objType == Byte.class) {
                value = "0";
            } else if (objType == BigDecimal.class || objType == Double.class || objType == Float.class) {
                value = "0.0";
            } else if (objType == Boolean.class) {
                value = "false";
            } else if (objType == Date.class) {
                value = DateUtils.getCurrentDate();
            } else if (objType == Calendar.class) {
                value = DateUtils.getCurrentDateTime();
            }
        }
        if (dt != null && dt.isValid(value, null)) {
            object = dt.createJavaObject(value, null);
            if (object instanceof Calendar && type.equals("date")) {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                try {
                    object = df.parse(value);
                }
                catch (ParseException pe) {
                    object = new Date();
                }
            }
        } else {
            if (this.topLevelBean == null) {
                this.topLevelBean = parentBean;
            }
            object = this.pushBeanOnStack(classPackage, type);
            Field[] fields = object.getClass().getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                if (!fields[i].isAnnotationPresent(ObjectXmlAsValue.class)) continue;
                try {
                    StringBuffer fieldName = new StringBuffer(fields[i].getName());
                    char c = fieldName.charAt(0);
                    if (c >= 'a' && c <= 'z') {
                        c = (char)(c - 32);
                    }
                    fieldName.setCharAt(0, c);
                    fieldName.insert(0, "set");
                    Method method = object.getClass().getMethod(fieldName.toString(), fields[i].getType());
                    method.invoke(object, value);
                    break;
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                }
            }
            NamedNodeMap nodeAttrs = node.getAttributes();
            for (int i = 0; i < nodeAttrs.getLength(); ++i) {
                String nodePrefix = nodeAttrs.item(i).getPrefix();
                if (!nodePrefix.equals(this.nsPrefix)) continue;
                String nodeName = nodeAttrs.item(i).getLocalName();
                String nodeValue = nodeAttrs.item(i).getNodeValue();
                try {
                    Field field = object.getClass().getDeclaredField(nodeName);
                    if (!field.isAnnotationPresent(ObjectXmlAsAttribute.class)) continue;
                    StringBuffer fieldName = new StringBuffer(field.getName());
                    char c = fieldName.charAt(0);
                    if (c >= 'a' && c <= 'z') {
                        c = (char)(c - 32);
                    }
                    fieldName.setCharAt(0, c);
                    fieldName.insert(0, "set");
                    Method method = object.getClass().getMethod(fieldName.toString(), field.getType());
                    if (field.getType() == String.class) {
                        method.invoke(object, nodeValue);
                        continue;
                    }
                    if (field.getType() == Boolean.TYPE) {
                        method.invoke(object, StringUtils.strToBool(nodeValue, "true"));
                        continue;
                    }
                    if (field.getType() == Byte.TYPE) {
                        method.invoke(object, (byte)Byte.valueOf(nodeValue));
                        continue;
                    }
                    if (field.getType() == Character.TYPE) {
                        method.invoke(object, Character.valueOf(nodeValue.charAt(0)));
                        continue;
                    }
                    if (field.getType() == Double.TYPE) {
                        method.invoke(object, (double)Double.valueOf(nodeValue));
                        continue;
                    }
                    if (field.getType() == Float.TYPE) {
                        method.invoke(object, Float.valueOf(Float.valueOf(nodeValue).floatValue()));
                        continue;
                    }
                    if (field.getType() == Integer.TYPE) {
                        method.invoke(object, (int)Integer.valueOf(nodeValue));
                        continue;
                    }
                    if (field.getType() == Long.TYPE) {
                        method.invoke(object, (long)Long.valueOf(nodeValue));
                        continue;
                    }
                    if (field.getType() != Short.TYPE) continue;
                    method.invoke(object, (short)Short.valueOf(nodeValue));
                    continue;
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                }
            }
        }
        if (parentBean != null && setProperty) {
            parentBean.setProperty(name, object);
        }
        return object;
    }

    private Object deserialize(Node node, boolean setProperty, boolean popBean) throws Exception {
        Object object = null;
        this.currentType = null;
        this.currentNode = node;
        this.currentName = node.getNodeName();
        boolean isNull = false;
        NamedNodeMap attrs = node.getAttributes();
        String arrayType = null;
        for (int i = 0; i < attrs.getLength(); ++i) {
            String nodeName = attrs.item(i).getNodeName();
            String nodeValue = attrs.item(i).getNodeValue();
            if (nodeName.equals("xsi:type")) {
                this.currentType = new StringBuffer(nodeValue).delete(0, nodeValue.indexOf(58) + 1).toString();
                continue;
            }
            if (nodeName.equals("soapenc:arrayType")) {
                arrayType = new StringBuffer(nodeValue).delete(0, nodeValue.indexOf(58) + 1).toString();
                continue;
            }
            if (!nodeName.equals("xsi:null")) continue;
            isNull = nodeValue.equals("true");
        }
        Class cls = null;
        if (this.currentType != null) {
            cls = ObjectXml.getXsdTypeClass(this.currentType);
        }
        if (cls != null && (cls == Array.class || cls == Vector.class || cls == ArrayList.class || cls == LinkedList.class || cls == Hashtable.class || cls == Properties.class || cls == HashMap.class || cls == SortedMap.class)) {
            this.parentNode = this.currentNode;
            String name = node.getNodeName();
            if (cls == Array.class) {
                int a = arrayType.indexOf("[");
                int b = arrayType.indexOf("]");
                String s = arrayType.substring(a + 1, b);
                int arrayLen = Integer.valueOf(s);
                Class arrayClass = ObjectXml.getXsdTypeClass(arrayType = arrayType.substring(0, a));
                if (arrayClass == null) {
                    arrayClass = ObjectXml.getClassOfBean((ClassLoader)((Object)this.classLoaderStrategy), arrayType);
                }
                object = Array.newInstance(arrayClass, arrayLen);
            } else {
                Constructor ct = cls.getConstructor(null);
                object = ct.newInstance(null);
            }
            NodeList childNodes = node.getChildNodes();
            int arrayIndex = -1;
            Node childNode = null;
            Object nodeObj = null;
            for (int i = 0; i < childNodes.getLength(); ++i) {
                NodeList htNodes;
                childNode = childNodes.item(i);
                if (childNode.getNodeType() != 1) continue;
                if (cls == Array.class || cls == Vector.class || cls == ArrayList.class || cls == LinkedList.class) {
                    nodeObj = this.deserialize(childNode, false, true);
                    if (nodeObj == null) continue;
                    if (cls == Array.class) {
                        Array.set(object, ++arrayIndex, nodeObj);
                        continue;
                    }
                    ((List)object).add(nodeObj);
                    continue;
                }
                if (cls != Hashtable.class && cls != Properties.class && cls != HashMap.class && cls != SortedMap.class || !childNode.getLocalName().equals("item") || (htNodes = childNode.getChildNodes()).getLength() != 2) continue;
                Object hashKey = this.deserialize(htNodes.item(0), false, false);
                Object hashValue = this.deserialize(htNodes.item(1), false, true);
                ((Map)object).put(hashKey, hashValue);
            }
            this.setBeanProperty(name, object);
        } else {
            NodeList childNodes = node.getChildNodes();
            if (childNodes != null && childNodes.getLength() > 0) {
                for (int i = 0; i < childNodes.getLength(); ++i) {
                    Node childNode = childNodes.item(i);
                    if (childNode.getNodeType() == 1) {
                        if (this.currentType != null) {
                            this.createObject(node, this.currentName, this.currentPackage, this.currentType, childNode.getNodeValue(), setProperty);
                        }
                        this.parentNode = node;
                        object = this.deserialize(childNode, true, true);
                    } else if (childNode.getNodeType() == 3 && this.currentType != null) {
                        object = this.createObject(node, this.currentName, this.currentPackage, this.currentType, childNode.getNodeValue(), setProperty);
                    }
                    this.currentType = null;
                }
            } else if (!isNull) {
                object = this.createObject(node, this.currentName, this.currentPackage, this.currentType, null, setProperty);
            }
            if (node.getParentNode() != this.parentNode) {
                Object bean;
                this.parentNode = node.getParentNode();
                if (popBean && (bean = this.popBeanOffStack()) != null) {
                    object = bean;
                }
            }
        }
        return object;
    }

    public class Bean {
        private BeanInfo beanInfo;
        private Object beanObject;
        private Properties propDesc;

        public Bean(String classPackage, String clazz, ClassLoaderStrategy cls, Bean topLevelBean) throws Exception {
            try {
                Class classOfBean = ObjectXml.getClassOfBean((ClassLoader)((Object)cls), classPackage + "." + clazz);
                Constructor ct = null;
                if (classOfBean.getEnclosingClass() != null) {
                    ct = classOfBean.getConstructor(classOfBean.getEnclosingClass());
                    this.beanObject = ct.newInstance(topLevelBean.getBeanObject());
                } else {
                    ct = classOfBean.getConstructor(null);
                    this.beanObject = ct.newInstance(null);
                }
                this.beanInfo = Introspector.getBeanInfo(classOfBean);
                PropertyDescriptor[] pds = this.beanInfo.getPropertyDescriptors();
                this.propDesc = new Properties();
                for (int i = 0; i < pds.length; ++i) {
                    this.propDesc.put(pds[i].getName(), pds[i]);
                }
            }
            catch (Exception e) {
                System.err.println("Exception creating bean: " + e.getMessage());
                e.printStackTrace();
                throw e;
            }
        }

        public String getPropertyName(String name) {
            StringBuffer propertyName = new StringBuffer(name);
            char c = propertyName.charAt(0);
            if (c >= 'A' && c <= 'Z') {
                c = (char)(c + 32);
                propertyName.setCharAt(0, c);
            }
            return propertyName.toString();
        }

        public PropertyDescriptor getPropertyDescriptor(String name) {
            return (PropertyDescriptor)this.propDesc.get(this.getPropertyName(name));
        }

        public Class getPropertyType(String name) {
            PropertyDescriptor pd = this.getPropertyDescriptor(name);
            return pd.getPropertyType();
        }

        public void setProperty(String name, Object object) {
            PropertyDescriptor pd = this.getPropertyDescriptor(name);
            if (pd != null) {
                Object[] args = new Object[]{object};
                Object propertyValue = null;
                try {
                    Method setter = pd.getWriteMethod();
                    if (setter != null) {
                        propertyValue = setter.invoke(this.beanObject, args);
                    }
                }
                catch (Exception e) {
                    System.err.println("Exception setting bean property: " + e.getMessage());
                    System.err.println("Property name: " + name);
                    System.err.println("Property value: " + propertyValue);
                }
            }
        }

        public Object getBeanObject() {
            return this.beanObject;
        }
    }
}

