/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.javaUtils.xml;

import gov.va.med.lom.javaUtils.file.TextFile;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class XslTransform {
    private static Properties transformers = new Properties();

    public static Transformer createTransformer(String xsltFile) throws TransformerException, TransformerConfigurationException {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer(new StreamSource(xsltFile));
        return transformer;
    }

    public static String transformWithStoredXslt(String xml, String name) throws TransformerException, TransformerConfigurationException, IOException {
        Transformer transformer = (Transformer)transformers.get(name);
        if (transformer != null) {
            return XslTransform.transform(xml, transformer);
        }
        return xml;
    }

    public static String transform(String xml, Transformer transformer) throws TransformerException, TransformerConfigurationException, IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        StringReader reader = new StringReader(xml);
        transformer.transform(new StreamSource(reader), new StreamResult(outputStream));
        return outputStream.toString();
    }

    public static String transform(String xml, String xslt) throws TransformerException, TransformerConfigurationException {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        StreamSource xsltSource = new StreamSource(new StringReader(xslt));
        Transformer transformer = tFactory.newTransformer(xsltSource);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        StringReader reader = new StringReader(xml);
        transformer.transform(new StreamSource(reader), new StreamResult(outputStream));
        return outputStream.toString();
    }

    public static String transformFile(String xmlFile, String xsltFile) throws TransformerException, TransformerConfigurationException {
        Transformer transformer = XslTransform.createTransformer(xsltFile);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        transformer.transform(new StreamSource(xmlFile), new StreamResult(outputStream));
        return outputStream.toString();
    }

    public static void main(String[] args) throws TransformerException, TransformerConfigurationException, IOException {
        if (args.length != 3) {
            System.out.println("Usage: java Transform <infile> <outfile> <xslt>");
            return;
        }
        String inFile = args[0];
        String outFile = args[1];
        String xslFile = args[2];
        TextFile xmlFile = new TextFile(inFile);
        Transformer transformer = XslTransform.createTransformer(xslFile);
        String result = XslTransform.transform(xmlFile.getText(), transformer);
        TextFile textFile = new TextFile();
        textFile.setText(result);
        textFile.saveFile(outFile);
    }
}

