/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.javaUtils.xml;

import gov.va.med.lom.javaUtils.misc.StringUtils;

public class XMLTable {
    private StringBuffer records;
    private boolean withProlog = false;
    private String title = null;
    private String subtitle = null;
    private String datetime = null;
    private String additionalContent = null;
    private String clinicName;
    private String userName;
    private int numRecords = -1;
    private String[] fieldNames = null;
    private String[] fieldWidths = null;
    private String[] fieldAlignments = null;
    private String[] fieldHeaders = null;
    private String[] fieldTargets = null;
    private long targetEntityID = 0L;

    public XMLTable(boolean withProlog) {
        this.withProlog = withProlog;
        this.reset();
    }

    public void reset() {
        this.title = null;
        this.subtitle = null;
        this.datetime = null;
        this.additionalContent = null;
        this.clinicName = null;
        this.userName = null;
        this.numRecords = -1;
        this.fieldNames = null;
        this.fieldWidths = null;
        this.fieldAlignments = null;
        this.fieldHeaders = null;
        this.fieldTargets = null;
        this.targetEntityID = 0L;
        this.records = new StringBuffer();
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setSubtitle(String subtitle) {
        this.subtitle = subtitle;
    }

    public void setDatetime(String datetime) {
        this.datetime = datetime;
    }

    public void setAdditionalContent(String additionalContent) {
        this.additionalContent = additionalContent;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setClinicName(String clinicName) {
        this.clinicName = clinicName;
    }

    public void setNumRecords(int numRecords) {
        this.numRecords = numRecords;
    }

    public void setFieldNames(String[] fieldNames) {
        this.fieldNames = fieldNames;
    }

    public void setFieldWidths(String[] fieldWidths) {
        this.fieldWidths = fieldWidths;
    }

    public void setFieldAlignments(String[] fieldAlignments) {
        this.fieldAlignments = fieldAlignments;
    }

    public void setFieldHeaders(String[] fieldHeaders) {
        this.fieldHeaders = fieldHeaders;
    }

    public void setFieldTargets(long targetEntityID, String[] fieldTargets) {
        this.targetEntityID = targetEntityID;
        this.fieldTargets = fieldTargets;
    }

    public void newRecord(String[] fieldValues, String rowColor) {
        this.records.append("<record color=\"" + rowColor + "\">");
        for (int col = 0; col < fieldValues.length; ++col) {
            this.records.append("<field ");
            if (this.fieldNames != null) {
                this.records.append("name=\"" + this.fieldNames[col] + "\" ");
            }
            if (this.fieldTargets != null && this.fieldTargets[col].length() > 0) {
                this.records.append("target=\"" + this.targetEntityID + ";" + this.fieldTargets[col] + "\" ");
            }
            if (this.fieldAlignments != null && this.fieldAlignments[col].length() > 0) {
                this.records.append("align=\"" + this.fieldAlignments[col] + "\" ");
            }
            this.records.append(">");
            this.records.append(StringUtils.escapeEntities(fieldValues[col]));
            this.records.append("</field>");
        }
        this.records.append("</record>");
    }

    public void newRecord(String[] fieldValues) {
        this.newRecord(fieldValues, "");
    }

    public String toString() {
        StringBuffer xml = new StringBuffer();
        if (this.withProlog) {
            xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        }
        xml.append("<data>");
        if (this.title != null) {
            xml.append("<title>" + this.title + "</title>");
        } else {
            xml.append("<title />");
        }
        if (this.subtitle != null) {
            xml.append("<subtitle>" + this.subtitle + "</subtitle>");
        } else {
            xml.append("<subtitle />");
        }
        if (this.clinicName != null) {
            xml.append("<clinic_name>" + this.clinicName + "</clinic_name>");
        } else {
            xml.append("<clinic_name />");
        }
        if (this.userName != null) {
            xml.append("<user_name>" + this.userName + "</user_name>");
        } else {
            xml.append("<user_name />");
        }
        if (this.datetime != null) {
            xml.append("<datetime>" + this.datetime + "</datetime>");
        } else {
            xml.append("<datetime />");
        }
        if (this.numRecords >= 0) {
            xml.append("<num_records>" + this.numRecords + "</num_records>");
        } else {
            xml.append("<num_records />");
        }
        if (this.additionalContent != null) {
            xml.append("<additional_content><![CDATA[" + this.additionalContent + "]]></additional_content>");
        } else {
            xml.append("<additional_content />");
        }
        if (this.fieldHeaders != null) {
            xml.append("<header>");
            for (int i = 0; i < this.fieldHeaders.length; ++i) {
                xml.append("<col");
                if (this.fieldWidths != null) {
                    xml.append(" width=\"" + this.fieldWidths[i] + "\"");
                }
                if (this.fieldAlignments != null) {
                    xml.append(" align=\"" + this.fieldAlignments[i] + "\"");
                }
                xml.append(">" + this.fieldHeaders[i] + "</col>");
            }
            xml.append("</header>");
        }
        xml.append("<records>");
        xml.append(this.records.toString());
        xml.append("</records>");
        xml.append("</data>");
        return xml.toString();
    }
}

