/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.javaUtils.xml;

import gov.va.med.lom.javaUtils.misc.Base64Encoder;
import gov.va.med.lom.javaUtils.misc.StringUtils;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Vector;
import org.apache.axis.Constants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLDataTypes {
    public static final String DEFAULT_NS_PREFIX = "lom";
    public static final String DEFAULT_NS_URI = "gov.va.med.lom.xml";
    public static HashMap XSD_SOAP_TYPES_MAP = new HashMap();
    public static HashMap STANDARD_TYPES_MAP = new HashMap();
    public static HashMap XSD_SOAP_ARRAY_TYPES_MAP = new HashMap();
    public static HashMap PRIMITIVE_TYPES_MAP = new HashMap();

    public static Class getXsdTypeClass(String xsdType) {
        Class cls = (Class)XSD_SOAP_TYPES_MAP.get(xsdType);
        return cls;
    }

    public static Class getPrimitiveTypeClass(String type) {
        Class cls = (Class)PRIMITIVE_TYPES_MAP.get(type);
        return cls;
    }

    public static String[] getXsdSoapArrayInfo(String arrayType, String defaultNsPrefix) {
        String[] results;
        int colonIndex = arrayType.indexOf(58);
        if (colonIndex > 0) {
            arrayType.substring(colonIndex + 1);
        }
        if ((results = (String[])XSD_SOAP_ARRAY_TYPES_MAP.get(arrayType)) != null) {
            return results;
        }
        if (arrayType.indexOf(46) >= 0) {
            arrayType = new StringBuffer(arrayType).substring(arrayType.lastIndexOf(46) + 1, arrayType.length());
        }
        return new String[]{defaultNsPrefix, arrayType};
    }

    public static Element getStandardObjectElement(Document document, Object object, String name) {
        SimpleDateFormat ansiFormatter;
        String type = null;
        String value = null;
        if (object instanceof String) {
            type = "xsd:" + Constants.XSD_STRING.getLocalPart();
            value = StringUtils.escapeEntities(((String)object).toString());
        } else if (object instanceof Boolean) {
            type = "xsd:" + Constants.XSD_BOOLEAN.getLocalPart();
            value = ((Boolean)object).toString();
        } else if (object instanceof BigDecimal) {
            type = "xsd:" + Constants.XSD_DECIMAL.getLocalPart();
            value = ((BigDecimal)object).toString();
        } else if (object instanceof Float) {
            type = "xsd:" + Constants.XSD_FLOAT.getLocalPart();
            value = ((Float)object).toString();
        } else if (object instanceof Double) {
            type = "xsd:" + Constants.XSD_DOUBLE.getLocalPart();
            value = ((Double)object).toString();
        } else if (object instanceof BigInteger) {
            type = "xsd:" + Constants.XSD_INTEGER.getLocalPart();
            value = ((BigInteger)object).toString();
        } else if (object instanceof Integer) {
            type = "xsd:" + Constants.XSD_INT.getLocalPart();
            value = ((Integer)object).toString();
        } else if (object instanceof Long) {
            type = "xsd:" + Constants.XSD_LONG.getLocalPart();
            value = ((Long)object).toString();
        } else if (object instanceof Short) {
            type = "xsd:" + Constants.XSD_SHORT.getLocalPart();
            value = ((Short)object).toString();
        } else if (object instanceof Byte) {
            type = "xsd:" + Constants.XSD_BYTE.getLocalPart();
            value = ((Byte)object).toString();
        } else if (object instanceof byte[]) {
            type = "xsd:" + Constants.XSD_BASE64.getLocalPart();
            value = Base64Encoder.toBase64String((byte[])object);
        } else if (object instanceof java.util.Date) {
            type = "xsd:" + Constants.XSD_DATE.getLocalPart();
            ansiFormatter = new SimpleDateFormat("yyyy-MM-dd");
            value = ansiFormatter.format((java.util.Date)object);
        } else if (object instanceof Date) {
            type = "xsd:" + Constants.XSD_DATE.getLocalPart();
            ansiFormatter = new SimpleDateFormat("yyyy-MM-dd");
            value = ansiFormatter.format((Date)object);
        } else if (object instanceof Time) {
            type = "xsd:" + Constants.XSD_TIME.getLocalPart();
            ansiFormatter = new SimpleDateFormat("hh:mm:ss");
            value = ansiFormatter.format((Time)object);
        } else if (object instanceof Calendar) {
            type = "xsd:" + Constants.XSD_DATETIME.getLocalPart();
            ansiFormatter = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss.S");
            value = ansiFormatter.format(((Calendar)object).getTime());
        }
        if (type == null && value == null && object != null) {
            return null;
        }
        Element childElement = document.createElement(name);
        if (type == null || type.length() == 0) {
            type = "anyType";
            childElement.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:null", "true");
        }
        childElement.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", type);
        if (value != null) {
            childElement.setTextContent(value);
        }
        return childElement;
    }

    public static boolean isStandardType(String type) {
        Class cls = XMLDataTypes.getXsdTypeClass(type);
        return cls != null;
    }

    public static boolean isPrimitiveType(String type) {
        Class cls = XMLDataTypes.getPrimitiveTypeClass(type);
        return cls != null;
    }

    public static String[] getXsdSoapType(Class cls) {
        return (String[])STANDARD_TYPES_MAP.get(cls);
    }

    public static String[] getXsdSoapType(String type) {
        Class cls = null;
        try {
            cls = (Class)XSD_SOAP_TYPES_MAP.get(type);
            return (String[])STANDARD_TYPES_MAP.get(cls);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void main(String[] args) {
    }

    static {
        XSD_SOAP_TYPES_MAP.put(Constants.XSD_STRING.getLocalPart(), String.class);
        XSD_SOAP_TYPES_MAP.put("java.lang.String", String.class);
        XSD_SOAP_TYPES_MAP.put(Constants.XSD_BOOLEAN.getLocalPart(), Boolean.TYPE);
        XSD_SOAP_TYPES_MAP.put("java.lang.Boolean", Boolean.TYPE);
        XSD_SOAP_TYPES_MAP.put(Constants.XSD_DECIMAL.getLocalPart(), BigDecimal.class);
        XSD_SOAP_TYPES_MAP.put("java.math.BigDecimal", BigDecimal.class);
        XSD_SOAP_TYPES_MAP.put(Constants.XSD_FLOAT.getLocalPart(), Float.TYPE);
        XSD_SOAP_TYPES_MAP.put("java.lang.Float", Float.TYPE);
        XSD_SOAP_TYPES_MAP.put(Constants.XSD_DOUBLE.getLocalPart(), Double.TYPE);
        XSD_SOAP_TYPES_MAP.put("java.lang.Double", Double.TYPE);
        XSD_SOAP_TYPES_MAP.put(Constants.XSD_INTEGER.getLocalPart(), BigInteger.class);
        XSD_SOAP_TYPES_MAP.put("java.math.BigInteger", BigInteger.class);
        XSD_SOAP_TYPES_MAP.put(Constants.XSD_INT.getLocalPart(), Integer.TYPE);
        XSD_SOAP_TYPES_MAP.put("java.lang.Integer", Integer.TYPE);
        XSD_SOAP_TYPES_MAP.put(Constants.XSD_LONG.getLocalPart(), Long.TYPE);
        XSD_SOAP_TYPES_MAP.put("java.lang.Long", Long.TYPE);
        XSD_SOAP_TYPES_MAP.put(Constants.XSD_SHORT.getLocalPart(), Short.TYPE);
        XSD_SOAP_TYPES_MAP.put("java.lang.Short", Short.TYPE);
        XSD_SOAP_TYPES_MAP.put(Constants.XSD_BYTE.getLocalPart(), Byte.TYPE);
        XSD_SOAP_TYPES_MAP.put("java.lang.Byte", Byte.TYPE);
        XSD_SOAP_TYPES_MAP.put(Constants.XSD_BASE64.getLocalPart(), byte[].class);
        XSD_SOAP_TYPES_MAP.put("byte[]", byte[].class);
        XSD_SOAP_TYPES_MAP.put(Constants.XSD_DATE.getLocalPart(), java.util.Date.class);
        XSD_SOAP_TYPES_MAP.put("java.util.Date", java.util.Date.class);
        XSD_SOAP_TYPES_MAP.put("java.sql.Date", Date.class);
        XSD_SOAP_TYPES_MAP.put(Constants.XSD_TIME.getLocalPart(), Time.class);
        XSD_SOAP_TYPES_MAP.put("java.sql.Time", Time.class);
        XSD_SOAP_TYPES_MAP.put(Constants.XSD_DATETIME.getLocalPart(), Calendar.class);
        XSD_SOAP_TYPES_MAP.put("java.util.Calendar", Calendar.class);
        XSD_SOAP_TYPES_MAP.put("java.util.GregorianCalendar", Calendar.class);
        XSD_SOAP_TYPES_MAP.put(Constants.SOAP_MAP.getLocalPart(), HashMap.class);
        XSD_SOAP_TYPES_MAP.put("java.util.HashMap", HashMap.class);
        XSD_SOAP_TYPES_MAP.put(Constants.SOAP_VECTOR.getLocalPart(), Vector.class);
        XSD_SOAP_TYPES_MAP.put("java.util.Vector", Vector.class);
        XSD_SOAP_TYPES_MAP.put(Constants.SOAP_ELEMENT.getLocalPart(), Element.class);
        XSD_SOAP_TYPES_MAP.put("org.w3c.dom.Element", Element.class);
        XSD_SOAP_TYPES_MAP.put(Constants.SOAP_ARRAY.getLocalPart(), Array.class);
        XSD_SOAP_TYPES_MAP.put("char", Character.TYPE);
        XSD_SOAP_TYPES_MAP.put("ArrayList", ArrayList.class);
        XSD_SOAP_TYPES_MAP.put("LinkedList", LinkedList.class);
        XSD_SOAP_TYPES_MAP.put("Hashtable", Hashtable.class);
        XSD_SOAP_TYPES_MAP.put("Properties", Properties.class);
        STANDARD_TYPES_MAP.put(String.class, new String[]{"xsd", Constants.XSD_STRING.getLocalPart()});
        STANDARD_TYPES_MAP.put(Character.TYPE, new String[]{"xsd", Constants.XSD_STRING.getLocalPart()});
        STANDARD_TYPES_MAP.put(Character.class, new String[]{"xsd", Constants.XSD_STRING.getLocalPart()});
        STANDARD_TYPES_MAP.put(Boolean.TYPE, new String[]{"xsd", Constants.XSD_BOOLEAN.getLocalPart()});
        STANDARD_TYPES_MAP.put(Boolean.class, new String[]{"xsd", Constants.XSD_BOOLEAN.getLocalPart()});
        STANDARD_TYPES_MAP.put(BigDecimal.class, new String[]{"xsd", Constants.XSD_DECIMAL.getLocalPart()});
        STANDARD_TYPES_MAP.put(Float.TYPE, new String[]{"xsd", Constants.XSD_FLOAT.getLocalPart()});
        STANDARD_TYPES_MAP.put(Float.class, new String[]{"xsd", Constants.XSD_FLOAT.getLocalPart()});
        STANDARD_TYPES_MAP.put(Double.TYPE, new String[]{"xsd", Constants.XSD_DOUBLE.getLocalPart()});
        STANDARD_TYPES_MAP.put(Double.class, new String[]{"xsd", Constants.XSD_DOUBLE.getLocalPart()});
        STANDARD_TYPES_MAP.put(BigInteger.class, new String[]{"xsd", Constants.XSD_INTEGER.getLocalPart()});
        STANDARD_TYPES_MAP.put(Integer.TYPE, new String[]{"xsd", Constants.XSD_INT.getLocalPart()});
        STANDARD_TYPES_MAP.put(Integer.class, new String[]{"xsd", Constants.XSD_INT.getLocalPart()});
        STANDARD_TYPES_MAP.put(Long.TYPE, new String[]{"xsd", Constants.XSD_LONG.getLocalPart()});
        STANDARD_TYPES_MAP.put(Long.class, new String[]{"xsd", Constants.XSD_LONG.getLocalPart()});
        STANDARD_TYPES_MAP.put(Short.TYPE, new String[]{"xsd", Constants.XSD_SHORT.getLocalPart()});
        STANDARD_TYPES_MAP.put(Short.class, new String[]{"xsd", Constants.XSD_SHORT.getLocalPart()});
        STANDARD_TYPES_MAP.put(Byte.TYPE, new String[]{"xsd", Constants.XSD_BYTE.getLocalPart()});
        STANDARD_TYPES_MAP.put(Byte.class, new String[]{"xsd", Constants.XSD_BYTE.getLocalPart()});
        STANDARD_TYPES_MAP.put(byte[].class, new String[]{"xsd", Constants.XSD_BASE64.getLocalPart()});
        STANDARD_TYPES_MAP.put(java.util.Date.class, new String[]{"xsd", Constants.XSD_DATE.getLocalPart()});
        STANDARD_TYPES_MAP.put(Date.class, new String[]{"xsd", Constants.XSD_DATE.getLocalPart()});
        STANDARD_TYPES_MAP.put(Time.class, new String[]{"xsd", Constants.XSD_TIME.getLocalPart()});
        STANDARD_TYPES_MAP.put(Calendar.class, new String[]{"xsd", Constants.XSD_DATETIME.getLocalPart()});
        STANDARD_TYPES_MAP.put(GregorianCalendar.class, new String[]{"xsd", Constants.XSD_DATETIME.getLocalPart()});
        STANDARD_TYPES_MAP.put(HashMap.class, new String[]{"apachesoap", Constants.SOAP_MAP.getLocalPart()});
        STANDARD_TYPES_MAP.put(Vector.class, new String[]{"soapenc", Constants.SOAP_VECTOR.getLocalPart()});
        STANDARD_TYPES_MAP.put(Element.class, new String[]{"soapenc", Constants.SOAP_ELEMENT.getLocalPart()});
        STANDARD_TYPES_MAP.put(Array.class, new String[]{"soapenc", Constants.SOAP_ARRAY.getLocalPart()});
        STANDARD_TYPES_MAP.put(ArrayList.class, new String[]{DEFAULT_NS_PREFIX, "ArrayList"});
        STANDARD_TYPES_MAP.put(LinkedList.class, new String[]{DEFAULT_NS_PREFIX, "LinkedList"});
        STANDARD_TYPES_MAP.put(Hashtable.class, new String[]{DEFAULT_NS_PREFIX, "Hashtable"});
        STANDARD_TYPES_MAP.put(Properties.class, new String[]{DEFAULT_NS_PREFIX, "Properties"});
        XSD_SOAP_ARRAY_TYPES_MAP.put("boolean[]", new String[]{"xsd", "boolean[]"});
        XSD_SOAP_ARRAY_TYPES_MAP.put("java.lang.Boolean[]", new String[]{"xsd", "boolean[]"});
        XSD_SOAP_ARRAY_TYPES_MAP.put("byte[]", new String[]{"xsd", "byte[]"});
        XSD_SOAP_ARRAY_TYPES_MAP.put("java.lang.Byte[]", new String[]{"xsd", "byte[]"});
        XSD_SOAP_ARRAY_TYPES_MAP.put("char[]", new String[]{"xsd", "char[]"});
        XSD_SOAP_ARRAY_TYPES_MAP.put("java.lang.Char[]", new String[]{"xsd", "char[]"});
        XSD_SOAP_ARRAY_TYPES_MAP.put("short[]", new String[]{"xsd", "short[]"});
        XSD_SOAP_ARRAY_TYPES_MAP.put("java.lang.Short[]", new String[]{"xsd", "short[]"});
        XSD_SOAP_ARRAY_TYPES_MAP.put("int[]", new String[]{"xsd", "int[]"});
        XSD_SOAP_ARRAY_TYPES_MAP.put("java.lang.Integer[]", new String[]{"xsd", "int[]"});
        XSD_SOAP_ARRAY_TYPES_MAP.put("float[]", new String[]{"xsd", "float[]"});
        XSD_SOAP_ARRAY_TYPES_MAP.put("java.lang.Float[]", new String[]{"xsd", "float[]"});
        XSD_SOAP_ARRAY_TYPES_MAP.put("long[]", new String[]{"xsd", "long[]"});
        XSD_SOAP_ARRAY_TYPES_MAP.put("java.lang.Long[]", new String[]{"xsd", "long[]"});
        XSD_SOAP_ARRAY_TYPES_MAP.put("double[]", new String[]{"xsd", "double[]"});
        XSD_SOAP_ARRAY_TYPES_MAP.put("java.lang.Double[]", new String[]{"xsd", "double[]"});
        XSD_SOAP_ARRAY_TYPES_MAP.put("java.lang.String[]", new String[]{"xsd", "string[]"});
        XSD_SOAP_ARRAY_TYPES_MAP.put("void[]", new String[]{"xsd", "void[]"});
        XSD_SOAP_ARRAY_TYPES_MAP.put("java.util.Calendar[]", new String[]{"xsd", "dateTime[]"});
        XSD_SOAP_ARRAY_TYPES_MAP.put("java.util.GregorianCalendar[]", new String[]{"xsd", "dateTime[]"});
        XSD_SOAP_ARRAY_TYPES_MAP.put("java.util.Date[]", new String[]{"xsd", "date[]"});
        XSD_SOAP_ARRAY_TYPES_MAP.put("java.sql.Date[]", new String[]{"xsd", "date[]"});
        XSD_SOAP_ARRAY_TYPES_MAP.put("java.sql.Time[]", new String[]{"xsd", "time[]"});
        XSD_SOAP_ARRAY_TYPES_MAP.put("java.math.BigDecimal[]", new String[]{"xsd", "decimal[]"});
        XSD_SOAP_ARRAY_TYPES_MAP.put("java.math.BigInteger[]", new String[]{"xsd", "integer[]"});
        XSD_SOAP_ARRAY_TYPES_MAP.put("javax.xml.namespace.QName[]", new String[]{"xsd", "QName[]"});
        XSD_SOAP_ARRAY_TYPES_MAP.put("java.util.Vector[]", new String[]{"xsd", "Vector[]"});
        XSD_SOAP_ARRAY_TYPES_MAP.put("java.util.HashMap[]", new String[]{"apachesoap", "Map[]"});
        XSD_SOAP_ARRAY_TYPES_MAP.put("org.w3c.dom.Element[]", new String[]{"xsd", "Element[]"});
        XSD_SOAP_ARRAY_TYPES_MAP.put("java.util.ArrayList[]", new String[]{DEFAULT_NS_PREFIX, "ArrayList[]"});
        XSD_SOAP_ARRAY_TYPES_MAP.put("java.util.LinkedList[]", new String[]{DEFAULT_NS_PREFIX, "LinkedList[]"});
        XSD_SOAP_ARRAY_TYPES_MAP.put("java.util.Hashtable[]", new String[]{DEFAULT_NS_PREFIX, "Hashtable[]"});
        XSD_SOAP_ARRAY_TYPES_MAP.put("java.util.Properties[]", new String[]{DEFAULT_NS_PREFIX, "Properties[]"});
        PRIMITIVE_TYPES_MAP.put("java.lang.String", String.class);
        PRIMITIVE_TYPES_MAP.put("char", Character.class);
        PRIMITIVE_TYPES_MAP.put("boolean", Boolean.class);
        PRIMITIVE_TYPES_MAP.put("float", Float.class);
        PRIMITIVE_TYPES_MAP.put("double", Double.class);
        PRIMITIVE_TYPES_MAP.put("int", Integer.class);
        PRIMITIVE_TYPES_MAP.put("long", Long.class);
        PRIMITIVE_TYPES_MAP.put("short", Short.class);
        PRIMITIVE_TYPES_MAP.put("byte", Byte.class);
    }
}

