/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.javaUtils.xml;

import gov.va.med.lom.javaUtils.xml.ElementImpl;
import gov.va.med.lom.javaUtils.xml.NodeDOMException;
import gov.va.med.lom.javaUtils.xml.NodeListImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HashMapElement
extends ElementImpl {
    protected HashMap children = null;

    public HashMapElement() {
        this.children = new HashMap();
    }

    public HashMapElement(HashMapElement element) {
        super(element);
        this.children = element.children;
    }

    public HashMapElement(Document ownerDoc, String name) {
        super(ownerDoc, name);
        this.children = new HashMap();
    }

    protected HashMapElement(Document ownerDoc, String nodeName, short type, String value) {
        super(ownerDoc, nodeName, type, value);
    }

    public HashMapElement(Node node) {
        this(node, true);
    }

    public HashMapElement(Node node, boolean deep) {
        super(node, false);
        this.children = new HashMap();
        if (deep) {
            this.initNodeImplChildren(node);
        }
    }

    protected Node newElementInstance(Node node) {
        return new HashMapElement(node);
    }

    public static Element newInstance(Document document) {
        Element root = document.getDocumentElement();
        return new HashMapElement(root);
    }

    public Node insertBefore(Node newChild, Node refChild) {
        super.insertBefore(newChild, refChild);
        if (newChild.getNodeType() == 1) {
            HashMapElement newChildNode = (HashMapElement)newChild;
            ArrayList<HashMapElement> list = (ArrayList<HashMapElement>)this.children.get(newChildNode.getTagName());
            if (list == null) {
                list = new ArrayList<HashMapElement>();
            }
            list.add(newChildNode);
            this.children.put(newChildNode.getTagName(), list);
        }
        return newChild;
    }

    public Node replaceChild(Node newChild, Node oldChild) {
        HashMapElement oldChildNode;
        List<HashMapElement> list;
        super.replaceChild(newChild, oldChild);
        if (oldChild.getNodeType() == 1 && (list = (ArrayList<HashMapElement>)this.children.get((oldChildNode = (HashMapElement)oldChild).getTagName())) != null) {
            int index = list.indexOf(oldChildNode);
            if (index != -1) {
                list.remove(index);
            }
            if (list.size() == 0) {
                this.children.remove(oldChildNode.getTagName());
            }
        }
        if (newChild.getNodeType() == 1) {
            HashMapElement newChildNode = (HashMapElement)newChild;
            list = (List)this.children.get(newChildNode.getTagName());
            if (list == null) {
                list = new ArrayList<HashMapElement>();
            }
            list.add(newChildNode);
            this.children.put(newChildNode.getTagName(), list);
        }
        return oldChild;
    }

    public Node removeChild(Node oldChild) {
        HashMapElement oldChildNode;
        List list;
        super.removeChild(oldChild);
        if (oldChild.getNodeType() == 1 && (list = (List)this.children.get((oldChildNode = (HashMapElement)oldChild).getTagName())) != null) {
            int index = list.indexOf(oldChildNode);
            if (index != -1) {
                list.remove(index);
            }
            if (list.size() == 0) {
                this.children.remove(oldChildNode.getTagName());
            }
        }
        return oldChild;
    }

    public Node cloneNode(boolean deep) {
        return new HashMapElement(this, deep);
    }

    public NodeList getElementsByTagName(String name) {
        ArrayList<HashMapElement> list = new ArrayList<HashMapElement>();
        if (this.nodeName.equals(name)) {
            list.add(this);
        }
        this.getElementsByTagName(name, list);
        return new NodeListImpl(list);
    }

    private void getElementsByTagName(String name, List list) {
        if (this.numChildren == 0) {
            return;
        }
        List fList2 = (List)this.children.get(name);
        if (fList2 != null) {
            // empty if block
        }
        list.addAll(fList2);
        for (List fList2 : this.children.values()) {
            for (int i = 0; i < fList2.size(); ++i) {
                ((HashMapElement)fList2.get(i)).getElementsByTagName(name, list);
            }
        }
    }

    public boolean hasElementChildNodes() {
        return this.children.size() > 0;
    }

    public NodeList getChildrenByTagName(String name) {
        List list = (List)this.children.get(name);
        if (list != null) {
            return new NodeListImpl(list);
        }
        return null;
    }

    public Element getFirstChildByTagName(String name) {
        NodeList children = this.getChildrenByTagName(name);
        if (children != null && children.getLength() > 0) {
            return (HashMapElement)children.item(0);
        }
        return null;
    }

    public Element getNextSameNameNode() {
        try {
            HashMapElement parent = (HashMapElement)this.getParentNode();
            List tagList = (List)parent.children.get(this.nodeName);
            int index = tagList.indexOf(this);
            if (++index <= tagList.size()) {
                return (HashMapElement)tagList.get(index);
            }
        }
        catch (NullPointerException e) {
            throw new NodeDOMException(8, "Root node doesn't have a successor");
        }
        return null;
    }

    public String getText() {
        String text = "";
        for (Node child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 3) continue;
            text = text + child.getNodeValue();
        }
        if (!text.equals("")) {
            return text;
        }
        return null;
    }

    public void setText(String text) {
        Node child = this.getFirstChild();
        if (child != null) {
            child.setNodeValue(text);
            child = child.getNextSibling();
            while (child != null) {
                if (child.getNodeType() == 3) {
                    Node temp = child;
                    child = child.getNextSibling();
                    this.removeChild(temp);
                    continue;
                }
                child = child.getNextSibling();
            }
        }
    }
}

