/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.javaUtils.xml;

import gov.va.med.lom.javaUtils.xml.AttrImpl;
import gov.va.med.lom.javaUtils.xml.HashMapNamedNodeMap;
import gov.va.med.lom.javaUtils.xml.Indent;
import gov.va.med.lom.javaUtils.xml.NodeDOMException;
import gov.va.med.lom.javaUtils.xml.NodeImpl;
import gov.va.med.lom.javaUtils.xml.NodeListImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;

public class ElementImpl
extends NodeImpl
implements Element {
    protected HashMap attributes = null;

    public ElementImpl() {
        this.attributes = new HashMap();
        this.type = 1;
    }

    public ElementImpl(ElementImpl element) {
        super(element);
        this.attributes = element.attributes;
        this.type = 1;
    }

    public ElementImpl(Document ownerDoc, String name) {
        super(ownerDoc, name, (short)1);
        this.attributes = new HashMap();
    }

    protected ElementImpl(Document ownerDoc, String nodeName, short type, String value) {
        super(ownerDoc, nodeName, type, value);
    }

    public ElementImpl(Node node) {
        this(node, true);
    }

    public ElementImpl(Node node, boolean deep) {
        super(node, false);
        this.attributes = new HashMap();
        NamedNodeMap attrs = node.getAttributes();
        if (attrs != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                AttrImpl attr = new AttrImpl((Attr)attrs.item(i));
                this.attributes.put(attr.getName(), attr);
            }
        }
        if (deep) {
            this.initNodeImplChildren(node);
        }
    }

    public static Element newInstance(Document document) {
        Element root = document.getDocumentElement();
        return new ElementImpl(root);
    }

    public Node insertBefore(Node newChild, Node refChild) {
        super.insertBefore(newChild, refChild);
        return newChild;
    }

    public Node replaceChild(Node newChild, Node oldChild) {
        super.replaceChild(newChild, oldChild);
        return oldChild;
    }

    public Node removeChild(Node oldChild) {
        super.removeChild(oldChild);
        return oldChild;
    }

    public Node cloneNode(boolean deep) {
        return new ElementImpl(this, deep);
    }

    public String getTagName() {
        return this.nodeName;
    }

    public NamedNodeMap getAttributes() {
        return new HashMapNamedNodeMap(this.attributes);
    }

    public String getAttribute(String name) {
        Attr attr = this.getAttributeNode(name);
        if (attr == null) {
            return "";
        }
        return attr.getValue();
    }

    public String getAttributeNS(String namespaceURI, String localName) {
        return this.getAttribute(localName);
    }

    public void setAttribute(String name, String value) {
        this.attributes.put(name, new AttrImpl(this, name, value));
    }

    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) {
        this.setAttribute(qualifiedName, value);
    }

    public void removeAttribute(String name) {
        if (this.type != 1) {
            throw new NodeDOMException(9, "Node doesn't have attributes");
        }
        this.removeAttribute(name, true);
    }

    private void removeAttribute(String name, boolean checkPresent) {
        if (this.attributes.remove(name) != null) {
            return;
        }
        if (checkPresent) {
            throw new NodeDOMException(8, "No such attribute!");
        }
    }

    public boolean hasAttributes() {
        return this.attributes.size() > 0;
    }

    public boolean hasAttribute(String name) {
        return this.getAttributeNode(name) != null;
    }

    public void removeAttributeNS(String namespaceURI, String localName) {
        this.removeAttribute(localName);
    }

    public Attr getAttributeNode(String name) {
        return (Attr)this.attributes.get(name);
    }

    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        return this.getAttributeNode(localName);
    }

    public Attr setAttributeNode(Attr newAttr) throws DOMException {
        AttrImpl attr = newAttr instanceof AttrImpl ? (AttrImpl)newAttr : new AttrImpl(newAttr);
        this.attributes.put(attr.getName(), attr);
        return attr;
    }

    public Attr setAttributeNodeNS(Attr newAttr) {
        return this.setAttributeNode(newAttr);
    }

    public Attr removeAttributeNode(Attr oldAttr) {
        this.removeAttribute(oldAttr.getName());
        return oldAttr;
    }

    public boolean hasAttributeNS(String namespaceURI, String localName) {
        return this.hasAttribute(localName);
    }

    public NodeList getElementsByTagName(String name) {
        ArrayList list = new ArrayList();
        this.getElementsByTagName(name, list);
        return new NodeListImpl(list);
    }

    private void getElementsByTagName(String name, List list) {
        if (this.nodeName.equals(name)) {
            list.add(this);
        }
        for (Node child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            ((ElementImpl)child).getElementsByTagName(name, list);
        }
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        return this.getElementsByTagName(localName);
    }

    public boolean hasElementChildNodes() {
        for (Node child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            return true;
        }
        return false;
    }

    protected void beginToString(StringBuffer sb, Indent indent) {
        sb.append("\n" + indent + "<" + this.nodeName);
        for (Attr attr : this.attributes.values()) {
            sb.append(" " + attr.getNodeName() + "=\"" + attr.getNodeValue() + "\"");
        }
        if (this.hasChildNodes()) {
            sb.append(">");
            indent.increment();
        } else {
            sb.append("/>");
        }
    }

    protected void endToString(StringBuffer sb, Indent indent) {
        if (this.hasChildNodes()) {
            indent.decrement();
            if (this.hasElementChildNodes()) {
                sb.append("\n" + indent + "</" + this.nodeName + ">");
            } else {
                sb.append("</" + this.nodeName + ">");
            }
        }
    }

    public TypeInfo getSchemaTypeInfo() {
        return null;
    }

    public void setIdAttribute(String name, boolean isId) throws DOMException {
    }

    public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
    }

    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
    }
}

