/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.javaUtils.xml;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMSerializer {
    public static final String XML_PROLOG = "<?xml version=\"1.0\" standalone = \"yes\"?>";
    private String indent = "";
    private String lineSeperator = "";

    public void setLineSeperator(String lineSeperator) {
        this.lineSeperator = lineSeperator;
    }

    public void setIndentation(String indent) {
        this.indent = indent;
    }

    public void serialize(Document doc, OutputStream out) throws IOException {
        this.serialize(doc, out, true);
    }

    public void serialize(Document doc, OutputStream out, boolean includeXmlProlog) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(out);
        this.serialize(doc, writer, includeXmlProlog);
    }

    public void serialize(Document doc, File file) throws IOException {
        this.serialize(doc, file, true);
    }

    public void serialize(Document doc, File file, boolean includeXmlProlog) throws IOException {
        FileWriter writer = new FileWriter(file);
        this.serialize(doc, writer, includeXmlProlog);
    }

    public void serialize(Document doc, Writer writer) throws IOException {
        this.serialize(doc, writer, true);
    }

    public void serialize(Document doc, Writer writer, boolean includeXmlProlog) throws IOException {
        this.serializeNode(doc, writer, this.indent, includeXmlProlog);
        writer.flush();
        writer.close();
    }

    public void serializeNode(Node node, Writer writer, String indentLevel) throws IOException {
        this.serializeNode(node, writer, indentLevel, true);
    }

    public void serializeNode(Node node, Writer writer, String indentLevel, boolean includeXmlProlog) throws IOException {
        switch (node.getNodeType()) {
            case 9: {
                if (includeXmlProlog) {
                    writer.write(XML_PROLOG);
                }
                writer.write(this.lineSeperator);
                NodeList nodes = node.getChildNodes();
                if (nodes == null) break;
                for (int i = 0; i < nodes.getLength(); ++i) {
                    this.serializeNode(nodes.item(i), writer, "", includeXmlProlog);
                }
                break;
            }
            case 1: {
                String name = node.getNodeName();
                writer.write(indentLevel + "<" + name);
                NamedNodeMap attributes = node.getAttributes();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Node current = attributes.item(i);
                    writer.write(" " + current.getNodeName() + "=\"" + current.getNodeValue() + "\"");
                }
                writer.write(">");
                NodeList children = node.getChildNodes();
                if (children != null) {
                    if (children.item(0) != null && children.item(0).getNodeType() == 1) {
                        writer.write(this.lineSeperator);
                    }
                    for (int i = 0; i < children.getLength(); ++i) {
                        this.serializeNode(children.item(i), writer, indentLevel + this.indent);
                    }
                    if (children.item(0) != null && children.item(children.getLength() - 1).getNodeType() == 1) {
                        writer.write(indentLevel);
                    }
                }
                writer.write("</" + name + ">");
                writer.write(this.lineSeperator);
                break;
            }
            case 3: {
                writer.write(node.getNodeValue());
                break;
            }
            case 4: {
                writer.write("<![CDATA[" + node.getNodeValue() + "]]>");
                break;
            }
            case 8: {
                writer.write(indentLevel + "<!-- " + node.getNodeValue() + " -->");
                writer.write(this.lineSeperator);
                break;
            }
            case 7: {
                writer.write("<?" + node.getNodeName() + " " + node.getNodeValue() + "?>");
                writer.write(this.lineSeperator);
                break;
            }
            case 5: {
                writer.write("&" + node.getNodeName() + ";");
                break;
            }
            case 10: {
                DocumentType docType = (DocumentType)node;
                writer.write("<!DOCTYPE " + docType.getName());
                if (docType.getPublicId() != null) {
                    System.out.print(" PUBLIC \"" + docType.getPublicId() + "\" ");
                } else {
                    writer.write(" SYSTEM ");
                }
                writer.write("\"" + docType.getSystemId() + "\">");
                writer.write(this.lineSeperator);
            }
        }
    }
}

