/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.javaUtils.xml;

import gov.va.med.lom.javaUtils.xml.DOMSerializer;
import java.io.File;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import org.apache.xerces.jaxp.DocumentBuilderFactoryImpl;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.InputSource;

public class DOMDocument {
    private Document document;

    public DOMDocument(String namespaceURI, String qualifiedName, DocumentType docType) {
        try {
            DocumentBuilder db = new DocumentBuilderFactoryImpl().newDocumentBuilder();
            DOMImplementation domImpl = db.getDOMImplementation();
            this.document = domImpl.createDocument(namespaceURI, qualifiedName, docType);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    public DOMDocument(File file) {
        try {
            DOMParser parser = new DOMParser();
            parser.parse(file.toURL().toString());
            this.document = parser.getDocument();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    public DOMDocument(Document document) {
        this.document = document;
    }

    public DOMDocument(String xml) {
        try {
            StringReader reader = new StringReader(xml);
            DOMParser parser = new DOMParser();
            parser.parse(new InputSource(reader));
            this.document = parser.getDocument();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public Document getDocument() {
        return this.document;
    }

    public Node getRootNode() {
        return this.document.getDocumentElement();
    }

    public Properties getAtributes(Node node) {
        Properties props = new Properties();
        NamedNodeMap attributes = node.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node current = attributes.item(i);
            props.put(current.getNodeName(), current.getNodeValue());
        }
        return props;
    }

    public NodeList getNodeList(String tagName) {
        Element root = this.document.getDocumentElement();
        NodeList nodeList = root.getElementsByTagName(tagName);
        return nodeList;
    }

    public NodeIterator getNodeIterator(NodeList nodeList) {
        Element element = (Element)nodeList.item(0);
        return ((DocumentTraversal)((Object)this.document)).createNodeIterator(element, -1, null, true);
    }

    public NodeIterator getNodeIterator(String tagName) {
        return this.getNodeIterator(this.getNodeList(tagName));
    }

    public int getNumElements(NodeList nodeList) {
        return nodeList.getLength();
    }

    public String getValue(NodeList nodeList, int index) {
        if (index >= 0 && index < nodeList.getLength()) {
            Node node = nodeList.item(index);
            Node textNode = node.getFirstChild();
            if (textNode != null && textNode.getNodeType() == 3) {
                return textNode.getNodeValue();
            }
            return null;
        }
        return null;
    }

    public int getIndex(NodeList nodeList, String value) {
        int i;
        String[] values = this.getValueList(nodeList);
        int count = values.length;
        for (i = 0; i < count && !values[i].equalsIgnoreCase(value); ++i) {
        }
        if (i < count) {
            return i;
        }
        return -1;
    }

    public String[] getValueList(NodeList nodeList) {
        int count = this.getNumElements(nodeList);
        String[] values = new String[count];
        for (int i = 0; i < count; ++i) {
            values[i] = this.getValue(nodeList, i);
        }
        return values;
    }

    public void serialize(Writer writer, String lineSeperator, String indent, boolean includeXmlProlog) {
        DOMSerializer serializer = new DOMSerializer();
        try {
            serializer.setLineSeperator(lineSeperator);
            serializer.setIndentation(indent);
            serializer.serialize(this.getDocument(), writer, includeXmlProlog);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    public void serialize(Writer writer, String lineSeperator, String indent) {
        this.serialize(writer, lineSeperator, indent, true);
    }

    public void serialize(Writer writer, boolean includeXmlProlog) {
        this.serialize(writer, "", "", includeXmlProlog);
    }

    public void serialize(Writer writer) {
        this.serialize(writer, true);
    }

    public String serialize(String lineSeperator, String indent, boolean includeXmlProlog) {
        StringWriter writer = new StringWriter();
        this.serialize(writer, lineSeperator, indent, includeXmlProlog);
        return writer.toString();
    }

    public String serialize(String lineSeperator, String indent) {
        return this.serialize(lineSeperator, indent, true);
    }

    public String serialize(boolean includeXmlProlog) {
        return this.serialize("", "", includeXmlProlog);
    }

    public String serialize() {
        return this.serialize(true);
    }
}

