/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.javaUtils.xml;

import gov.va.med.lom.javaUtils.misc.StringUtils;
import gov.va.med.lom.javaUtils.xml.DOMDocument;
import gov.va.med.lom.javaUtils.xml.XMLDataTypes;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BeanSerializer
extends XMLDataTypes {
    public static DOMDocument serializeBeans(Object[] beans, String nsPrefix, String nsURI, String name, String[] ignoredFields) throws IntrospectionException, IllegalAccessException {
        HashMap<String, String> hashedIgnoredFields = new HashMap<String, String>();
        if (ignoredFields != null) {
            for (int i = 0; i < ignoredFields.length; ++i) {
                hashedIgnoredFields.put(ignoredFields[i], ignoredFields[i]);
            }
        }
        DOMDocument domDocument = BeanSerializer.createDomDocument(name, nsPrefix, nsURI);
        Document document = domDocument.getDocument();
        Element root = document.getDocumentElement();
        for (int i = 0; i < beans.length; ++i) {
            BeanSerializer.getBeanElements(document, root, null, nsPrefix, beans[i].getClass().getName(), beans[i], hashedIgnoredFields);
        }
        return domDocument;
    }

    public static DOMDocument serializeBeans(Object[] beans, String name, String[] ignoredFields) throws IntrospectionException, IllegalAccessException {
        return BeanSerializer.serializeBeans(beans, "lom", "gov.va.med.lom.xml", name, ignoredFields);
    }

    public static DOMDocument serializeBean(Object bean, String nsPrefix, String nsURI, String[] ignoredFields) throws IntrospectionException, IllegalAccessException {
        HashMap<String, String> hashedIgnoredFields = new HashMap<String, String>();
        if (ignoredFields != null) {
            for (int i = 0; i < ignoredFields.length; ++i) {
                hashedIgnoredFields.put(ignoredFields[i], ignoredFields[i]);
            }
        }
        String className = bean.getClass().getName();
        className = StringUtils.deleteTrailingChar(className, ';');
        StringBuffer objectName = new StringBuffer(className);
        objectName.delete(0, objectName.lastIndexOf(".") + 1);
        DOMDocument domDocument = BeanSerializer.createDomDocument(objectName.toString(), nsPrefix, nsURI);
        Document document = domDocument.getDocument();
        Element root = document.getDocumentElement();
        BeanSerializer.getBeanElements(document, root, null, nsPrefix, className, bean, hashedIgnoredFields);
        return domDocument;
    }

    public static DOMDocument serializeBean(Object bean, String nsPrefix, String nsURI) throws IntrospectionException, IllegalAccessException {
        return BeanSerializer.serializeBean(bean, nsPrefix, nsURI, new String[0]);
    }

    public static DOMDocument serializeBean(Object bean, String[] ignoredFields) throws IntrospectionException, IllegalAccessException {
        return BeanSerializer.serializeBean(bean, "lom", "gov.va.med.lom.xml", ignoredFields);
    }

    public static DOMDocument serializeBean(Object bean) throws IntrospectionException, IllegalAccessException {
        return BeanSerializer.serializeBean(bean, null);
    }

    protected static void getBeanElements(Document document, Element parentElement, String objectName, String nsPrefix, String objectType, Object bean, HashMap hashedIgnoredFields) throws IntrospectionException, IllegalAccessException {
        Element element;
        if (objectName == null) {
            StringBuffer sb = new StringBuffer(bean.getClass().getName());
            sb.delete(0, sb.lastIndexOf(".") + 1);
            objectName = sb.toString();
        }
        if ((element = BeanSerializer.getStandardObjectElement(document, bean, objectName)) != null) {
            parentElement.appendChild(element);
        } else {
            Class<?> classOfBean = null;
            if (bean != null) {
                classOfBean = bean.getClass();
            }
            if (classOfBean != null && classOfBean.isArray()) {
                String[] arrayInfo = BeanSerializer.getXsdSoapArrayInfo(classOfBean.getCanonicalName(), nsPrefix);
                int arrayLen = Array.getLength(bean);
                StringBuffer arrayType = new StringBuffer(arrayInfo[1]);
                arrayType.insert(arrayType.indexOf("[]") + 1, arrayLen);
                if (objectName.charAt(objectName.length() - 1) == ';') {
                    objectName = new StringBuffer(objectName).deleteCharAt(objectName.length() - 1).toString();
                }
                element = document.createElement(objectName);
                parentElement.appendChild(element);
                for (int i = 0; i < arrayLen; ++i) {
                    Object b = Array.get(bean, i);
                    if (b != null) {
                        BeanSerializer.getBeanElements(document, element, null, arrayInfo[0], b.getClass().getName(), b, hashedIgnoredFields);
                    } else {
                        int index = arrayType.indexOf("[");
                        arrayType.replace(index + 1, index + 2, String.valueOf(--arrayLen));
                    }
                    element.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", "soapenc:Array");
                    element.setAttributeNS("http://schemas.xmlsoap.org/soap/encoding/", "soapenc:arrayType", arrayInfo[0] + ":" + arrayType.toString());
                }
            } else {
                int beanType = 0;
                String beanName = null;
                if (classOfBean != null) {
                    if (classOfBean == Vector.class) {
                        beanType = 1;
                        beanName = "Vector";
                    } else if (classOfBean == ArrayList.class) {
                        beanType = 2;
                        beanName = "ArrayList";
                    } else if (classOfBean == LinkedList.class) {
                        beanType = 3;
                        beanName = "LinkedList";
                    } else if (classOfBean == Hashtable.class) {
                        beanType = 4;
                        beanName = "Hashtable";
                    } else if (classOfBean == Properties.class) {
                        beanType = 5;
                        beanName = "Properties";
                    } else if (classOfBean == HashMap.class || classOfBean == SortedMap.class) {
                        beanType = 6;
                        beanName = "Map";
                    }
                }
                if (beanType > 0) {
                    String prefix = null;
                    if (beanType == 1 || beanType == 5) {
                        prefix = "soapenc";
                    }
                    prefix = beanType == 6 ? "apachesoap" : "lom";
                    element = document.createElement(objectName);
                    element.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", prefix + ":" + beanName);
                    if (bean == null) {
                        element.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:null", "true");
                    }
                    parentElement.appendChild(element);
                    if (beanType >= 1 && beanType <= 3) {
                        AbstractCollection collection = (AbstractCollection)bean;
                        for (Object b : collection) {
                            String beanClassName = null;
                            if (b != null) {
                                beanClassName = b.getClass().getName();
                            }
                            BeanSerializer.getBeanElements(document, element, "item", nsPrefix, beanClassName, b, hashedIgnoredFields);
                        }
                    } else if (beanType == 4 || beanType == 5) {
                        Hashtable hashtable = (Hashtable)bean;
                        Enumeration en = hashtable.keys();
                        while (en.hasMoreElements()) {
                            Object key = en.nextElement();
                            String keyClassName = key.getClass().getName();
                            Object value = hashtable.get(key);
                            String beanClassName = null;
                            if (value != null) {
                                beanClassName = value.getClass().getName();
                            }
                            Element itemElement = document.createElement("item");
                            element.appendChild(itemElement);
                            BeanSerializer.getBeanElements(document, itemElement, "key", nsPrefix, keyClassName, key, hashedIgnoredFields);
                            BeanSerializer.getBeanElements(document, itemElement, "value", nsPrefix, beanClassName, value, hashedIgnoredFields);
                        }
                    } else if (beanType == 6) {
                        Map map = null;
                        if (classOfBean == HashMap.class) {
                            map = (HashMap)bean;
                        } else if (classOfBean == SortedMap.class) {
                            map = (SortedMap)bean;
                        }
                        Set set = map.keySet();
                        for (Object key : set) {
                            String keyClassName = key.getClass().getName();
                            Object value = map.get(key);
                            String beanClassName = null;
                            if (value != null) {
                                beanClassName = value.getClass().getName();
                            }
                            Element itemElement = document.createElement("item");
                            element.appendChild(itemElement);
                            BeanSerializer.getBeanElements(document, itemElement, "key", nsPrefix, keyClassName, key, hashedIgnoredFields);
                            BeanSerializer.getBeanElements(document, itemElement, "value", nsPrefix, beanClassName, value, hashedIgnoredFields);
                        }
                    }
                } else {
                    if (objectName.charAt(objectName.length() - 1) == ';') {
                        objectName = new StringBuffer(objectName).deleteCharAt(objectName.length() - 1).toString();
                    }
                    element = document.createElement(objectName);
                    parentElement.appendChild(element);
                    StringBuffer className = new StringBuffer(objectType);
                    element.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", nsPrefix + ":" + className.delete(0, className.lastIndexOf(".") + 1).toString());
                    if (classOfBean != null) {
                        BeanInfo bi = Introspector.getBeanInfo(classOfBean);
                        PropertyDescriptor[] pds = bi.getPropertyDescriptors();
                        for (int i = 0; i < pds.length; ++i) {
                            PropertyDescriptor pd = pds[i];
                            BeanSerializer.getBeanElementProperties(document, element, nsPrefix, bean, pd, hashedIgnoredFields);
                        }
                    } else {
                        element.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:null", "true");
                    }
                }
            }
        }
    }

    protected static void getBeanElementProperties(Document document, Element element, String nsPrefix, Object bean, PropertyDescriptor pd, HashMap hashedIgnoredFields) throws IntrospectionException, IllegalAccessException {
        Object propertyElement = null;
        Class<?> classOfProperty = pd.getPropertyType();
        Object[] argsNone = new Object[]{};
        if (!pd.getName().equals("class") && !classOfProperty.equals(Class.class) && hashedIgnoredFields.get(pd.getName()) == null) {
            StringBuffer propertyName = new StringBuffer(pd.getName());
            char c = propertyName.charAt(0);
            if (c >= 'a' && c <= 'z') {
                c = (char)(c - 32);
                propertyName.setCharAt(0, c);
            }
            Object propertyValue = null;
            try {
                Method getter = pd.getReadMethod();
                if (getter != null) {
                    propertyValue = getter.invoke(bean, argsNone);
                }
            }
            catch (InvocationTargetException ex) {
                System.err.println(ex.getMessage());
            }
            if (propertyElement == null) {
                PropertyEditor propEditor = PropertyEditorManager.findEditor(classOfProperty);
                if (propEditor != null || classOfProperty == Calendar.class || classOfProperty == Date.class) {
                    try {
                        Object object;
                        if (classOfProperty == Calendar.class || classOfProperty == Date.class) {
                            object = propertyValue;
                        } else {
                            propEditor.setValue(propertyValue);
                            object = propEditor.getValue();
                        }
                        Element childElement = BeanSerializer.getStandardObjectElement(document, object, propertyName.toString());
                        element.appendChild(childElement);
                    }
                    catch (Exception e) {}
                } else {
                    try {
                        String propertyTypeName = null;
                        if (propertyValue != null) {
                            Class<?> propertyType = pd.getPropertyType();
                            propertyTypeName = propertyType.getName();
                        }
                        BeanSerializer.getBeanElements(document, element, propertyName.toString(), nsPrefix, propertyTypeName, propertyValue, hashedIgnoredFields);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private static DOMDocument createDomDocument(String rootName, String nsPrefix, String nsURI) {
        DOMDocument domDocument = new DOMDocument(nsURI, nsPrefix + ":" + rootName, null);
        Document document = domDocument.getDocument();
        Element root = document.getDocumentElement();
        root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + nsPrefix, nsURI);
        root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
        root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:soapenc", "http://schemas.xmlsoap.org/soap/encoding/");
        root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:apachesoap", "http://xml.apache.org/xml-soap");
        return domDocument;
    }
}

