/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.javaUtils.xml;

import com.sun.msv.datatype.xsd.DatatypeFactory;
import com.sun.msv.datatype.xsd.XSDatatype;
import gov.va.med.lom.javaUtils.classloader.ClassLoaderStrategy;
import gov.va.med.lom.javaUtils.classloader.ClassLoaderUtil;
import gov.va.med.lom.javaUtils.xml.DOMDocument;
import gov.va.med.lom.javaUtils.xml.XMLDataTypes;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.Stack;
import java.util.Vector;
import org.relaxng.datatype.DatatypeException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BeanDeserializer
extends XMLDataTypes {
    private ClassLoaderStrategy classLoaderStrategy;
    private String[] classLoaderArgs;
    private String[] classPackages;
    private String currentName;
    private String currentType;
    private Bean currentBean;
    private Node currentNode;
    private Node parentNode;
    private Node root;
    private Stack beansStack = new Stack();

    public BeanDeserializer(String strategy, String[] classLoaderArgs, String[] classPackages) throws Exception {
        this.classLoaderArgs = classLoaderArgs;
        this.classPackages = classPackages;
        try {
            this.classLoaderStrategy = ClassLoaderUtil.getClassLoader(strategy, classLoaderArgs);
        }
        catch (Exception e) {
            System.err.println("Exception creating class loader strategy: " + strategy);
            System.err.println(e.getMessage());
            throw e;
        }
    }

    public static Class getClassOfBean(ClassLoader classLoader, String[] classesPackages, String classType) {
        Class<?> cls = null;
        for (int i = 0; i < classesPackages.length; ++i) {
            try {
                cls = classLoader.loadClass(classesPackages[i] + "." + classType);
                break;
            }
            catch (ClassNotFoundException cnfe) {
                continue;
            }
        }
        return cls;
    }

    public Object deserialize(String xml) throws Exception {
        DOMDocument domDocument = new DOMDocument(xml);
        this.root = domDocument.getRootNode();
        return this.deserialize(this.root);
    }

    public Class getClassOfBean(String classType) throws ClassNotFoundException {
        return BeanDeserializer.getClassOfBean((ClassLoader)((Object)this.classLoaderStrategy), this.classPackages, classType);
    }

    public Bean createBean(String classType) throws Exception {
        return new Bean(classType, this.classLoaderStrategy, this.classLoaderArgs);
    }

    private Object pushBeanOnStack(String type) {
        try {
            Bean bean = new Bean(type, this.classLoaderStrategy, this.classLoaderArgs);
            this.parentNode = this.currentNode;
            this.currentBean = this.beansStack.push(bean);
            return bean.getBeanObject();
        }
        catch (Exception e) {
            System.err.println("bean could not be created: " + type);
            return null;
        }
    }

    private Object popBeanOffStack(Node node) {
        if (this.parentNode != this.root && this.beansStack.size() > 0) {
            this.currentBean = (Bean)this.beansStack.pop();
            return this.currentBean.getBeanObject();
        }
        return null;
    }

    private void setBeanProperty(String name, Object object) {
        Bean parentBean = null;
        if (this.beansStack.size() > 0) {
            parentBean = (Bean)this.beansStack.peek();
            parentBean.setProperty(name, object);
        }
    }

    private Object createObject(String name, String type, String value, boolean setProperty) {
        Bean parentBean = null;
        if (this.beansStack.size() > 0) {
            parentBean = (Bean)this.beansStack.peek();
        }
        Object object = null;
        XSDatatype dt = null;
        try {
            dt = DatatypeFactory.getTypeByName((String)type);
        }
        catch (DatatypeException dte) {
            // empty catch block
        }
        if (dt != null && dt.isValid(value, null)) {
            object = dt.createJavaObject(value, null);
            if (object instanceof Calendar && type.equals("date")) {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                try {
                    object = df.parse(value);
                }
                catch (ParseException pe) {
                    object = new Date();
                }
            }
        } else {
            object = this.pushBeanOnStack(type);
        }
        if (parentBean != null && setProperty) {
            parentBean.setProperty(name, object);
        }
        return object;
    }

    private Object deserialize(Node node) throws Exception {
        return this.deserialize(node, true, true);
    }

    private Object deserialize(Node node, boolean setProperty, boolean popBean) throws Exception {
        Object object = null;
        this.currentType = null;
        this.currentNode = node;
        this.currentName = node.getNodeName();
        NamedNodeMap attrs = node.getAttributes();
        String arrayType = null;
        for (int i = 0; i < attrs.getLength(); ++i) {
            String nodeName = attrs.item(i).getNodeName();
            String nodeValue = attrs.item(i).getNodeValue();
            if (nodeName.equals("xsi:type")) {
                this.currentType = new StringBuffer(nodeValue).delete(0, nodeValue.indexOf(58) + 1).toString();
                continue;
            }
            if (!nodeName.equals("soapenc:arrayType")) continue;
            arrayType = new StringBuffer(nodeValue).delete(0, nodeValue.indexOf(58) + 1).toString();
        }
        Class cls = null;
        if (this.currentType != null) {
            cls = BeanDeserializer.getXsdTypeClass(this.currentType);
        }
        if (cls != null && (cls == Array.class || cls == Vector.class || cls == ArrayList.class || cls == LinkedList.class || cls == Hashtable.class || cls == Properties.class || cls == HashMap.class || cls == SortedMap.class)) {
            this.parentNode = this.currentNode;
            String name = node.getNodeName();
            if (cls == Array.class) {
                int a = arrayType.indexOf("[");
                int b = arrayType.indexOf("]");
                String s = arrayType.substring(a + 1, b);
                int arrayLen = Integer.valueOf(s);
                Class arrayClass = BeanDeserializer.getXsdTypeClass(arrayType = arrayType.substring(0, a));
                if (arrayClass == null) {
                    arrayClass = BeanDeserializer.getClassOfBean((ClassLoader)((Object)this.classLoaderStrategy), this.classPackages, arrayType);
                }
                object = Array.newInstance(arrayClass, arrayLen);
            } else {
                Constructor ct = cls.getConstructor(null);
                object = ct.newInstance(null);
            }
            NodeList childNodes = node.getChildNodes();
            int arrayIndex = -1;
            Node childNode = null;
            Object nodeObj = null;
            for (int i = 0; i < childNodes.getLength(); ++i) {
                NodeList htNodes;
                childNode = childNodes.item(i);
                if (childNode.getNodeType() != 1) continue;
                if (cls == Array.class || cls == Vector.class || cls == ArrayList.class || cls == LinkedList.class) {
                    nodeObj = this.deserialize(childNode, false, true);
                    if (nodeObj == null) continue;
                    if (cls == Array.class) {
                        Array.set(object, ++arrayIndex, nodeObj);
                        continue;
                    }
                    ((List)object).add(nodeObj);
                    continue;
                }
                if (cls != Hashtable.class && cls != Properties.class && cls != HashMap.class && cls != SortedMap.class || !childNode.getLocalName().equals("item") || (htNodes = childNode.getChildNodes()).getLength() != 2) continue;
                Object hashKey = this.deserialize(htNodes.item(0), false, false);
                Object hashValue = this.deserialize(htNodes.item(1), false, true);
                ((Map)object).put(hashKey, hashValue);
            }
            this.setBeanProperty(name, object);
        } else {
            NodeList childNodes = node.getChildNodes();
            if (childNodes != null) {
                for (int i = 0; i < childNodes.getLength(); ++i) {
                    Node childNode = childNodes.item(i);
                    if (childNode.getNodeType() == 1) {
                        if (this.currentType != null) {
                            this.createObject(this.currentName, this.currentType, childNode.getNodeValue(), setProperty);
                        }
                        this.parentNode = node;
                        object = this.deserialize(childNode, true, true);
                    } else if (childNode.getNodeType() == 3 && this.currentType != null) {
                        object = this.createObject(this.currentName, this.currentType, childNode.getNodeValue(), setProperty);
                    }
                    this.currentType = null;
                }
            }
            if (node.getParentNode() != this.parentNode) {
                Object bean;
                this.parentNode = node.getParentNode();
                if (popBean && (bean = this.popBeanOffStack(node)) != null) {
                    object = bean;
                }
            }
        }
        return object;
    }

    public class Bean {
        private BeanInfo beanInfo;
        private Object beanObject;
        private Properties propDesc;

        public Bean(String classType, ClassLoaderStrategy cls, String[] classLoaderArgs) throws Exception {
            try {
                Class classOfBean = BeanDeserializer.getClassOfBean((ClassLoader)((Object)cls), BeanDeserializer.this.classPackages, classType);
                Constructor ct = classOfBean.getConstructor(null);
                this.beanObject = ct.newInstance(null);
                this.beanInfo = Introspector.getBeanInfo(classOfBean);
                PropertyDescriptor[] pds = this.beanInfo.getPropertyDescriptors();
                this.propDesc = new Properties();
                for (int i = 0; i < pds.length; ++i) {
                    this.propDesc.put(pds[i].getName(), pds[i]);
                }
            }
            catch (Exception e) {
                System.err.println("Exception creating bean: " + e.getMessage());
                e.printStackTrace();
                throw e;
            }
        }

        public String getPropertyName(String name) {
            StringBuffer propertyName = new StringBuffer(name);
            char c = propertyName.charAt(0);
            if (c >= 'A' && c <= 'Z') {
                c = (char)(c + 32);
                propertyName.setCharAt(0, c);
            }
            return propertyName.toString();
        }

        public PropertyDescriptor getPropertyDescriptor(String name) {
            return (PropertyDescriptor)this.propDesc.get(this.getPropertyName(name));
        }

        public Class getPropertyType(String name) {
            PropertyDescriptor pd = this.getPropertyDescriptor(name);
            return pd.getPropertyType();
        }

        public void setProperty(String name, Object object) {
            PropertyDescriptor pd = this.getPropertyDescriptor(name);
            if (pd != null) {
                Object[] args = new Object[]{object};
                Object propertyValue = null;
                try {
                    Method setter = pd.getWriteMethod();
                    if (setter != null) {
                        propertyValue = setter.invoke(this.beanObject, args);
                    }
                }
                catch (Exception e) {
                    System.err.println("Exception setting bean property: " + e.getMessage());
                    System.err.println("Property name: " + name);
                    System.err.println("Property value: " + propertyValue);
                }
            }
        }

        public Object getBeanObject() {
            return this.beanObject;
        }
    }
}

