/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.javaUtils.persistent;

import gov.va.med.lom.javaUtils.persistent.LoaderObjectInputStream;
import gov.va.med.lom.javaUtils.persistent.PersistentStore;
import gov.va.med.lom.javaUtils.persistent.PersistentStoreException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class FilePersistentStore
implements PersistentStore {
    private final String DEFAULT_DIR_PROPERTY = "user.dir";
    private final String FILE_SEPARATOR_PROPERTY = "file.separator";
    private final String SERIAL_SUFFIX = ".srl";
    private String fileSeparator;
    private String storeDirectory;
    private Constructor objectInputStreamConstructor;
    private ClassLoader loader;
    private static final char[] HexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public FilePersistentStore() throws PersistentStoreException {
        this.init(null, null);
    }

    public FilePersistentStore(ClassLoader loader) throws IOException, SecurityException, PersistentStoreException {
        this.init(null, loader);
    }

    public FilePersistentStore(String storeDirectory) throws PersistentStoreException {
        this.init(storeDirectory, null);
    }

    public FilePersistentStore(String storeDirectory, ClassLoader loader) throws PersistentStoreException {
        this.init(storeDirectory, loader);
    }

    private void init(String storeDirectory, ClassLoader loader) throws PersistentStoreException {
        try {
            this.loader = loader;
            this.fileSeparator = System.getProperty("file.separator");
            if (storeDirectory == null) {
                this.setStoreDirectory(this.fileSeparator + "tmp");
            } else {
                this.setStoreDirectory(storeDirectory);
            }
        }
        catch (Exception e) {
            throw new PersistentStoreException(e);
        }
    }

    private void setStoreDirectory(String storeDirectory) throws IOException, SecurityException {
        File f = new File(storeDirectory);
        if (f.exists() && !f.isDirectory()) {
            throw new IOException(storeDirectory + " already exists but is not a directory.");
        }
        if (!f.exists() && !f.mkdirs()) {
            throw new IOException("Unable to create directory " + storeDirectory);
        }
        this.storeDirectory = storeDirectory;
    }

    public String getStoreDirectory() {
        return this.storeDirectory;
    }

    private String filename(String key) {
        return this.storeDirectory + this.fileSeparator + this.convertKeyToHex(key) + ".srl";
    }

    private String convertKeyToHex(String key) {
        byte[] bytes = key.getBytes();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            sb.append(HexChars[bytes[i] >> 4 & 0xF]);
            sb.append(HexChars[bytes[i] & 0xF]);
        }
        return new String(sb);
    }

    private String convertHexToKey(String hex) {
        char[] chars = new char[hex.length()];
        hex.getChars(0, hex.length(), chars, 0);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < chars.length / 2; ++i) {
            int idx = 2 * i;
            sb.append((char)((this.hexCharToByte(chars[idx]) << 4) + this.hexCharToByte(chars[idx + 1])));
        }
        return new String(sb);
    }

    private byte hexCharToByte(char c) {
        switch (c) {
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': 
            case 'a': {
                return 10;
            }
            case 'B': 
            case 'b': {
                return 11;
            }
            case 'C': 
            case 'c': {
                return 12;
            }
            case 'D': 
            case 'd': {
                return 13;
            }
            case 'E': 
            case 'e': {
                return 14;
            }
            case 'F': 
            case 'f': {
                return 15;
            }
        }
        return 0;
    }

    public void store(String key, Serializable obj) throws PersistentStoreException {
        if (this.exists(key)) {
            throw new PersistentStoreException("An object is already stored as " + key);
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(this.filename(key));
            ObjectOutputStream objOut = new ObjectOutputStream(out);
            objOut.writeObject(obj);
            objOut.flush();
            out.close();
        }
        catch (Exception ex) {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.delete(key);
            throw new PersistentStoreException(ex);
        }
    }

    public Object retrieve(String key) throws PersistentStoreException {
        if (!this.exists(key)) {
            return null;
        }
        try {
            FileInputStream in = new FileInputStream(this.filename(key));
            LoaderObjectInputStream objIn = new LoaderObjectInputStream(in, this.loader);
            Object obj = objIn.readObject();
            objIn.close();
            return obj;
        }
        catch (Exception ex) {
            throw new PersistentStoreException(ex);
        }
    }

    public boolean exists(String key) throws PersistentStoreException {
        File f = new File(this.filename(key));
        return f.exists();
    }

    public Object remove(String key) throws PersistentStoreException {
        Object obj = this.retrieve(key);
        this.delete(key);
        return obj;
    }

    public void delete(String key) {
        File f = new File(this.filename(key));
        if (f.exists()) {
            f.delete();
        }
    }

    public Enumeration keys() throws PersistentStoreException {
        File dir = new File(this.storeDirectory);
        FileStoreFilter filter = new FileStoreFilter(".srl");
        String[] hexKeys = dir.list(filter);
        String[] keys = new String[hexKeys.length];
        for (int idx = 0; idx < hexKeys.length; ++idx) {
            int suffixIdx = hexKeys[idx].lastIndexOf(".srl");
            if (suffixIdx >= 0) {
                hexKeys[idx] = hexKeys[idx].substring(0, suffixIdx);
            }
            keys[idx] = this.convertHexToKey(hexKeys[idx]);
        }
        return new FilePersistentStoreKeys(keys);
    }

    private class FileStoreFilter
    implements FilenameFilter {
        private String suffix = "";

        FileStoreFilter(String suffix) {
            this.suffix = suffix;
        }

        public boolean accept(File dir, String name) {
            return name.endsWith(this.suffix);
        }
    }

    private class FilePersistentStoreKeys
    implements Enumeration {
        private String[] keys;
        private int idx = 0;

        FilePersistentStoreKeys() {
            this.keys = new String[0];
        }

        FilePersistentStoreKeys(String[] keys) {
            this.keys = keys;
        }

        public boolean hasMoreElements() {
            return this.idx < this.keys.length;
        }

        public Object nextElement() throws NoSuchElementException {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException("no more elements");
            }
            String k = this.keys[this.idx];
            ++this.idx;
            return k;
        }
    }
}

