/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.javaUtils.net;

import gov.va.med.lom.javaUtils.net.ISocketEventsCallback;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;

public class SocketConnection
implements Cloneable {
    private InetAddress addr = null;
    private String host = null;
    private int port = 0;
    private Socket clientSocket = null;
    private PrintWriter out = null;
    private BufferedReader in = null;
    private IOException lastException;
    private ISocketEventsCallback callback;

    public SocketConnection() {
    }

    public SocketConnection(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public SocketConnection(Socket socket) throws IOException {
        this.clientSocket = socket;
        this.out = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(this.clientSocket.getOutputStream())), true);
        this.in = new BufferedReader(new InputStreamReader(this.clientSocket.getInputStream()));
    }

    public boolean connect() throws IOException {
        try {
            this.addr = InetAddress.getByName(this.host);
            this.clientSocket = new Socket(this.addr, this.port);
            this.clientSocket.setKeepAlive(true);
            this.out = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(this.clientSocket.getOutputStream())), true);
            this.in = new BufferedReader(new InputStreamReader(this.clientSocket.getInputStream()));
            if (this.callback != null) {
                this.callback.onSocketConnect();
            }
            return this.isConnected();
        }
        catch (IOException ioe) {
            this.lastException = ioe;
            if (this.callback != null) {
                this.callback.onSocketException(ioe);
            }
            throw ioe;
        }
    }

    public void setSocketEventsCallback(ISocketEventsCallback callback) {
        this.callback = callback;
    }

    public Socket getSocket() {
        return this.clientSocket;
    }

    public String getLocalHostAddress() {
        return this.clientSocket.getLocalAddress().getHostAddress();
    }

    public String getLocalHostName() {
        return this.clientSocket.getLocalAddress().getCanonicalHostName();
    }

    public int getLocalPort() {
        return this.clientSocket.getLocalPort();
    }

    public String getRemoteHostAddress() {
        return this.clientSocket.getInetAddress().getHostAddress();
    }

    public String getRemoteHostName() {
        return this.clientSocket.getInetAddress().getCanonicalHostName();
    }

    public int getRemotePort() {
        return this.clientSocket.getPort();
    }

    public void setSocketOptionLinger(boolean enabled, int linger) {
        try {
            this.clientSocket.setSoLinger(enabled, linger);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    public void print(boolean b) throws IOException {
        this.out.print(b);
        this.checkWriterError();
    }

    public void print(char c) throws IOException {
        this.out.print(c);
        this.checkWriterError();
    }

    public void print(char[] s) throws IOException {
        this.out.print(s);
        this.checkWriterError();
    }

    public void print(double d) throws IOException {
        this.out.print(d);
        this.checkWriterError();
    }

    public void print(float f) throws IOException {
        this.out.print(f);
        this.checkWriterError();
    }

    public void print(int i) throws IOException {
        this.out.print(i);
        this.checkWriterError();
    }

    public void print(long l) throws IOException {
        this.out.print(l);
        this.checkWriterError();
    }

    public void print(Object o) throws IOException {
        this.out.print(o);
        this.checkWriterError();
    }

    public void print(String s) throws IOException {
        this.out.print(s);
        this.checkWriterError();
    }

    public void println() throws IOException {
        this.out.println();
        this.checkWriterError();
    }

    public void println(boolean x) throws IOException {
        this.out.println(x);
        this.checkWriterError();
    }

    public void println(char x) throws IOException {
        this.out.println(x);
        this.checkWriterError();
    }

    public void println(char[] x) throws IOException {
        this.out.println(x);
        this.checkWriterError();
    }

    public void println(double x) throws IOException {
        this.out.println(x);
        this.checkWriterError();
    }

    public void println(float x) throws IOException {
        this.out.println(x);
        this.checkWriterError();
    }

    public void println(int x) throws IOException {
        this.out.println(x);
        this.checkWriterError();
    }

    public void println(long x) throws IOException {
        this.out.println(x);
        this.checkWriterError();
    }

    public void println(Object x) throws IOException {
        this.out.println(x);
        this.checkWriterError();
    }

    public void println(String x) throws IOException {
        this.out.println(x);
        this.checkWriterError();
    }

    public void write(char[] buf) throws IOException {
        this.out.write(buf);
        this.checkWriterError();
    }

    public void write(char[] buf, int off, int len) throws IOException {
        this.out.write(buf, off, len);
        this.checkWriterError();
    }

    public void write(int c) throws IOException {
        this.out.write(c);
        this.checkWriterError();
    }

    public void write(String s) throws IOException {
        this.out.write(s);
        this.checkWriterError();
    }

    public void write(String s, int off, int len) throws IOException {
        this.out.write(s, off, len);
        this.checkWriterError();
    }

    public int read() throws IOException {
        try {
            return this.in.read();
        }
        catch (IOException ioe) {
            this.lastException = ioe;
            throw ioe;
        }
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        try {
            return this.in.read(cbuf, off, len);
        }
        catch (IOException ioe) {
            this.lastException = ioe;
            throw ioe;
        }
    }

    public String readLine() throws IOException {
        try {
            return this.in.readLine();
        }
        catch (IOException ioe) {
            this.lastException = ioe;
            throw ioe;
        }
    }

    public boolean isConnected() {
        return this.clientSocket.isConnected();
    }

    public boolean isClosed() {
        return this.clientSocket.isClosed();
    }

    public boolean close() throws IOException {
        try {
            this.out.close();
            this.checkWriterError();
            this.in.close();
            if (this.callback != null && this.isClosed()) {
                this.callback.onSocketDisconnect();
            }
            return this.isClosed();
        }
        catch (IOException ioe) {
            this.lastException = ioe;
            if (this.callback != null) {
                this.callback.onSocketException(ioe);
            }
            throw ioe;
        }
    }

    public InetAddress getAddr() {
        return this.addr;
    }

    public String getHost() {
        return this.host;
    }

    public IOException getLastException() {
        return this.lastException;
    }

    public boolean outputError() {
        return this.out.checkError();
    }

    public int getPort() {
        return this.port;
    }

    public Object clone() {
        Object clone = null;
        try {
            clone = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        ((SocketConnection)clone).host = new String(this.host);
        return clone;
    }

    private void checkWriterError() throws IOException {
        if (this.out.checkError()) {
            this.lastException = new IOException("Writer Error.");
            throw this.lastException;
        }
    }
}

