/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.javaUtils.misc;

import gov.va.med.lom.javaUtils.misc.Format;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtils {
    public static final char UP = '^';

    public static String piece(String x, char d, int piece) {
        int index = 0;
        int i = 0;
        int len = x.length();
        StringBuffer sb = new StringBuffer();
        if (--piece >= 0 && len > 0) {
            while (i < piece && index < len) {
                if (x.charAt(index++) != d) continue;
                ++i;
            }
            while (index < len && x.charAt(index) != d) {
                sb.append(x.charAt(index++));
            }
        }
        return sb.toString();
    }

    public static String piece(String x, int piece) {
        return StringUtils.piece(x, '^', piece);
    }

    public static String setPiece(String x, char d, int piece, String value) {
        int index = 0;
        int i = 0;
        int len = x.length();
        StringBuffer sb = new StringBuffer(x);
        if (--piece >= 0 && len > 0) {
            int end;
            while (i < piece && index < len) {
                if (x.charAt(index++) != d) continue;
                ++i;
            }
            for (end = index; end < len && x.charAt(end) != d; ++end) {
            }
            sb.replace(index, end, value);
        }
        return sb.toString();
    }

    public static String piece(String x, String del, int piece1, int piece2) {
        int pieceNum = 1;
        StringBuffer resVal = new StringBuffer();
        StringBuffer str = new StringBuffer(x);
        if (piece1 == 0) {
            piece1 = 1;
        }
        if (piece2 == 0) {
            piece2 = piece1;
        }
        do {
            int delIndex;
            if ((delIndex = str.indexOf(del)) > 0 || pieceNum > piece1 - 1 && pieceNum < piece2 + 1) {
                if (pieceNum > piece1 - 1 && pieceNum < piece2 + 1) {
                    if (pieceNum > piece1 && str.length() > 0) {
                        resVal.append(del);
                    }
                    if (delIndex > 0) {
                        resVal.append(str.substring(0, delIndex));
                        str.delete(0, delIndex + del.length());
                        continue;
                    }
                    resVal.append(str.toString());
                    str.delete(0, str.length());
                    continue;
                }
                str.delete(0, delIndex + del.length());
                continue;
            }
            if (str.length() <= 0) continue;
            str.delete(0, str.length());
        } while (++pieceNum <= piece2);
        return resVal.toString();
    }

    public static String pieces(String s, char delim, int first, int last) {
        StringBuffer sb = new StringBuffer();
        for (int i = first; i <= last; ++i) {
            sb.append(StringUtils.piece(s, delim, i));
        }
        return sb.toString();
    }

    public static String padString(String text, int len) {
        StringBuffer sb = new StringBuffer();
        sb.append(text);
        for (int i = 0; i < len - text.length(); ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    public static String wrapLine(String str, int wrapLength) {
        return StringUtils.wrapLine(str, wrapLength, ' ', null, false);
    }

    public static String wrapLine(String str, int wrapLength, char delimChar, String newLineStr, boolean wrapLongWords) {
        if (str == null) {
            return null;
        }
        if (newLineStr == null) {
            newLineStr = System.getProperty("line.separator");
        }
        if (wrapLength < 1) {
            wrapLength = 1;
        }
        int inputLineLength = str.length();
        int offset = 0;
        StringBuffer wrappedLine = new StringBuffer(inputLineLength + 32);
        while (inputLineLength - offset > wrapLength) {
            if (str.charAt(offset) == delimChar) {
                ++offset;
                continue;
            }
            int spaceToWrapAt = str.lastIndexOf(delimChar, wrapLength + offset);
            if (spaceToWrapAt >= offset) {
                wrappedLine.append(str.substring(offset, spaceToWrapAt + 1));
                wrappedLine.append(newLineStr);
                offset = spaceToWrapAt + 1;
                continue;
            }
            if (wrapLongWords) {
                wrappedLine.append(str.substring(offset, wrapLength + offset));
                wrappedLine.append(newLineStr);
                offset += wrapLength;
                continue;
            }
            spaceToWrapAt = str.indexOf(delimChar, wrapLength + offset);
            if (spaceToWrapAt >= 0) {
                wrappedLine.append(str.substring(offset, spaceToWrapAt));
                wrappedLine.append(newLineStr);
                offset = spaceToWrapAt + 1;
                continue;
            }
            wrappedLine.append(str.substring(offset));
            offset = inputLineLength;
        }
        wrappedLine.append(str.substring(offset));
        return wrappedLine.toString();
    }

    private static boolean isWrappableChar(char c) {
        return c == ' ' || c == ',' || c == ';' || c == ':' || c == '?' || c == '!';
    }

    public static String[] sortStrings(String[] strings) {
        int h = 1;
        while (h * 3 + 1 < strings.length) {
            h = 3 * h + 1;
        }
        while (h > 0) {
            for (int i = h - 1; i < strings.length; ++i) {
                String B = strings[i];
                int j = i;
                for (j = i; j >= h && strings[j - h].compareToIgnoreCase(B) > 0; j -= h) {
                    strings[j] = strings[j - h];
                }
                strings[j] = B;
            }
            h /= 3;
        }
        return strings;
    }

    public static List<String> sortByPiece(List list, char delim, int pieceNum) {
        String[] strings = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            strings[i] = StringUtils.piece((String)list.get(i), delim, pieceNum) + delim + (String)list.get(i);
        }
        strings = StringUtils.sortStrings(strings);
        ArrayList<String> aList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            aList.add(strings[i].substring(strings[i].indexOf(delim) + 1));
        }
        return aList;
    }

    public static List<String> sortByPiece(List<String> list, int pieceNum) {
        return StringUtils.sortByPiece(list, '^', pieceNum);
    }

    private static int comparePieces(String p1, String p2, int[] pieces, char delim, boolean caseInsensitive) {
        int result = 0;
        for (int i = 0; i < pieces.length; ++i) {
            result = caseInsensitive ? StringUtils.piece(p1, delim, pieces[i]).compareToIgnoreCase(StringUtils.piece(p2, delim, pieces[i])) : StringUtils.piece(p1, delim, pieces[i]).compareTo(StringUtils.piece(p2, delim, pieces[i]));
            if (result == 0) {
                continue;
            }
            return result;
        }
        return 0;
    }

    private static String[] sortByPieces(String[] strings, int[] pieces, char delim, int l, int r) {
        int i;
        do {
            i = l;
            int j = r;
            String p = strings[l + r >> 1];
            while (true) {
                if (StringUtils.comparePieces(strings[i], p, pieces, delim, true) < 0) {
                    ++i;
                    continue;
                }
                while (StringUtils.comparePieces(strings[j], p, pieces, delim, true) > 0) {
                    --j;
                }
                if (i <= j) {
                    String temp = strings[i];
                    strings[i] = strings[j];
                    strings[j] = temp;
                    ++i;
                    --j;
                }
                if (i > j) break;
            }
            if (l < j) {
                StringUtils.sortByPieces(strings, pieces, delim, l, j);
            }
            l = i;
        } while (i < r);
        return strings;
    }

    public static List<String> sortByPieces(List<String> list, int[] pieces, char delim) {
        String[] strings = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            strings[i] = list.get(i);
        }
        strings = StringUtils.sortByPieces(strings, pieces, delim, 0, list.size() - 1);
        ArrayList<String> aList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            aList.add(strings[i]);
        }
        return aList;
    }

    public static List<String> sortByPieces(List<String> list, int[] pieces) {
        return StringUtils.sortByPieces(list, pieces, '^');
    }

    public static String translate(String passedString, String identifier, String associator) {
        StringBuffer newString = new StringBuffer();
        for (int i = 0; i < passedString.length(); ++i) {
            String substr = passedString.substring(i, i + 1);
            int position = identifier.indexOf(substr);
            if (position >= 0) {
                newString.append(associator.substring(position, position + 1));
                continue;
            }
            newString.append(passedString.substring(i, i + 1));
        }
        return newString.toString();
    }

    public static String[] extractSection(List list, String section, boolean mixed) {
        int i = -1;
        while (i++ == list.size() || ((String)list.get(i)).equals(section)) {
        }
        Vector<String> v = new Vector<String>();
        while (i < list.size() && !((String)list.get(i)).equals("$$END")) {
            if (mixed) {
                v.add(StringUtils.mixedCase((String)list.get(i)));
            } else {
                v.add((String)list.get(i));
            }
            ++i;
        }
        String[] results = new String[v.size()];
        for (int j = 0; j < results.length; ++j) {
            results[j] = (String)v.get(j);
        }
        return results;
    }

    public static String extractDefault(List<String> source, String section) {
        int i;
        String result = "";
        for (i = 0; i < source.size() && !source.get(i).equals("~" + section); ++i) {
        }
        if (++i < source.size() && source.get(i).charAt(0) != '~') {
            do {
                if (source.get(i).charAt(0) != 'd') continue;
                result = source.get(i).substring(1, source.get(i).length());
            } while (++i < source.size() && source.get(i).charAt(0) != '~' && result.length() == 0);
        }
        return result;
    }

    public static List<String> extractItems(List<String> source, String section) {
        int i;
        ArrayList<String> result = new ArrayList<String>();
        for (i = 0; i < source.size() && !source.get(i).equals("~" + section); ++i) {
        }
        if (++i < source.size() && source.get(i).charAt(0) != '~') {
            do {
                if (source.get(i).charAt(0) != 'i') continue;
                result.add(source.get(i).substring(1, source.get(i).length()));
            } while (++i < source.size() && source.get(i).charAt(0) != '~');
        }
        return result;
    }

    public static List<String> extractText(List<String> source, String section) {
        return StringUtils.extractText(source, section, 1);
    }

    public static List<String> extractText(List<String> source, String section, int index) {
        int i = 0;
        int num = 0;
        ArrayList<String> result = new ArrayList<String>();
        while (num < index) {
            while (i < source.size() && !source.get(i).equals("~" + section)) {
                ++i;
            }
            if (++i < source.size() && source.get(i).charAt(0) != '~') {
                ++num;
                do {
                    if (num != index || source.get(i).charAt(0) != 't') continue;
                    result.add(source.get(i).substring(1, source.get(i).length()));
                } while (++i < source.size() && source.get(i).charAt(0) != '~');
            }
            if (i < source.size()) continue;
            index = 0;
        }
        return result;
    }

    public static String[] pieceList(String from, char delim) {
        Vector<String> vect = new Vector<String>();
        int startIndex = 0;
        int endIndex = from.indexOf(delim, startIndex);
        while (startIndex <= endIndex) {
            vect.add(from.substring(startIndex, endIndex));
            startIndex = endIndex + 1;
            endIndex = from.indexOf(delim, startIndex);
        }
        vect.add(from.substring(startIndex));
        String[] result = new String[vect.size()];
        for (int i = 0; i < vect.size(); ++i) {
            result[i] = (String)vect.elementAt(i);
        }
        return result;
    }

    public static String delimitString(String[] lines, char delim) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < lines.length; ++i) {
            sb.append(lines[i]);
            if (i >= lines.length - 1) continue;
            sb.append(delim);
        }
        return sb.toString();
    }

    public static boolean getBoolean(String value) {
        String v = value.toUpperCase();
        return v.equals("Y") || v.equals("YES") || v.equals("TRUE") || v.equals("T");
    }

    public static String boolToStr(boolean bool, String sTrue, String sFalse) {
        if (bool) {
            return sTrue;
        }
        return sFalse;
    }

    public static boolean strToBool(String str, String[] sTrue) {
        for (int i = 0; i < sTrue.length; ++i) {
            if (!str.equalsIgnoreCase(sTrue[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean strToBool(String str, String sTrue) {
        return str.equalsIgnoreCase(sTrue);
    }

    public static boolean isInDelimList(String from, String value, char delim) {
        int startIndex = 0;
        int endIndex = from.indexOf(delim, startIndex);
        boolean found = false;
        while (startIndex <= endIndex && !found) {
            found = from.substring(startIndex, endIndex).equalsIgnoreCase(value);
            startIndex = endIndex + 1;
            endIndex = from.indexOf(delim, startIndex);
        }
        if (!found) {
            found = from.substring(startIndex, from.length()).equalsIgnoreCase(value);
        }
        return found;
    }

    public static String parseDelimitedSSN(String ssn, String delim) {
        StringBuffer sb = new StringBuffer();
        int startIndex = 0;
        int endIndex = ssn.indexOf(delim, startIndex);
        while (startIndex <= endIndex) {
            sb.append(ssn.substring(startIndex, endIndex));
            startIndex = endIndex + 1;
            endIndex = ssn.indexOf(delim, startIndex);
        }
        sb.append(ssn.substring(startIndex));
        return sb.toString();
    }

    public static String formatSSN(String ssn, char delim) {
        StringBuffer sb = new StringBuffer(ssn);
        if (sb.length() == 9 || sb.length() == 10) {
            sb.insert(3, delim);
            sb.insert(6, delim);
            return sb.toString();
        }
        return ssn;
    }

    public static String unformatSSN(String text, char delim) {
        StringBuffer sb = new StringBuffer(text);
        for (int i = 0; i < sb.length(); ++i) {
            if (sb.charAt(i) != delim) continue;
            sb.deleteCharAt(i);
        }
        return sb.toString();
    }

    public static String formatPhoneNumber(String str, String areaCode) {
        if (str != null && !str.equals("")) {
            if (str.charAt(3) != '-' || str.charAt(7) != '-') {
                if (str.substring(0, 2).equals("1-")) {
                    str = str.substring(2, str.length());
                }
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < str.length(); ++i) {
                    char c = str.charAt(i);
                    if (!Character.isDigit(c)) continue;
                    sb.append(c);
                }
                if (sb.length() == 10) {
                    sb.insert(3, '-');
                    sb.insert(7, '-');
                    return sb.toString();
                }
                if (sb.length() == 7) {
                    sb.insert(0, areaCode + "-");
                    sb.insert(7, "-");
                    return sb.toString();
                }
                return "";
            }
            return str;
        }
        return "";
    }

    public static String escapeSingleQuotes(String text) {
        if (text == null) {
            return text;
        }
        if (text.indexOf(39) == -1) {
            return text;
        }
        char[] vec = text.toCharArray();
        int veclen = text.length();
        char[] out = new char[veclen * 2];
        int outindex = 0;
        for (int i = 0; i < veclen; ++i) {
            char c = vec[i];
            if (c == '\'') {
                out[outindex++] = 39;
            }
            out[outindex++] = c;
        }
        return new String(out, 0, outindex);
    }

    public static String escapeDoubleQuotes(String text) {
        if (text == null) {
            return text;
        }
        if (text.indexOf(34) == -1) {
            return text;
        }
        char[] vec = text.toCharArray();
        int veclen = text.length();
        char[] out = new char[veclen * 2];
        int outindex = 0;
        for (int i = 0; i < veclen; ++i) {
            char c = vec[i];
            if (c == '\"') {
                out[outindex++] = 34;
            }
            out[outindex++] = c;
        }
        return new String(out, 0, outindex);
    }

    public static String filterText(String text) {
        if (text != null && text.length() > 0) {
            StringBuffer sb = new StringBuffer(text);
            int index = 0;
            while (index != -1) {
                if ((index = sb.indexOf("'", index)) < 0) continue;
                sb.replace(index, index + 1, "\\'");
                index += 2;
            }
            index = 0;
            while (index != -1) {
                if ((index = sb.indexOf("\\", index)) < 0) continue;
                if (index < sb.length() - 1) {
                    char c;
                    if ((c = sb.charAt(index++)) == 'n' || c == 'r' || c == '\"' || c == '\\') continue;
                    sb.replace(index, index + 1, "");
                    continue;
                }
                sb.replace(index, index + 1, "");
            }
            return sb.toString();
        }
        return text;
    }

    public static String filterExtASCII(String text) {
        if (text != null && text.length() > 0) {
            StringBuffer sb = new StringBuffer(text);
            for (int i = 0; i < sb.length(); ++i) {
                if (sb.charAt(i) <= '\u007f') continue;
                sb.replace(i, i + 1, "");
            }
            return sb.toString();
        }
        return text;
    }

    public static String filterControlChars(String text) {
        if (text != null && text.length() > 0) {
            StringBuffer sb = new StringBuffer(text);
            char[] c = new char[]{'\u00bd', '\u00bc', '\u00be', '\u00b1', '\u00f2', '\u00f3', '\u00f6', '\u00f7'};
            String[] s = new String[]{"1/2", "1/4", "3/4", "+/-", ">=", ",+", "/", "=", "n"};
            for (int i = 0; i < c.length; ++i) {
                int index = 0;
                while (index != -1) {
                    index = sb.toString().indexOf(c[i], index);
                    if (index < 0) continue;
                    sb.replace(index, index + 1, s[i]);
                    index += s.length;
                }
            }
            return sb.toString();
        }
        return text;
    }

    public static String escapeEntities(String text) {
        if (text != null) {
            String[] entities = new String[]{"&", "<", ">", "'", "\""};
            String[] references = new String[]{"&amp;", "&lt;", "&gt;", "&apos;", "&quot;"};
            StringBuffer sb = new StringBuffer(text);
            for (int i = 0; i < entities.length; ++i) {
                int index = 0;
                while (index != -1) {
                    if ((index = sb.indexOf(entities[i], index)) < 0) continue;
                    sb.replace(index, index + 1, references[i]);
                    index += references[i].length();
                }
            }
            return sb.toString();
        }
        return text;
    }

    public static String escapeQuotes(String text) {
        if (text != null) {
            String[] entities = new String[]{"'"};
            String[] references = new String[]{"''"};
            StringBuffer sb = new StringBuffer(text);
            for (int i = 0; i < entities.length; ++i) {
                int index = 0;
                while (index != -1) {
                    if ((index = sb.indexOf(entities[i], index)) < 0) continue;
                    sb.replace(index, index + 1, references[i]);
                    index += references[i].length();
                }
            }
            return sb.toString();
        }
        return text;
    }

    public static String crnlToBR(String text) {
        StringBuffer sb = new StringBuffer(text);
        int index = 0;
        while (index != -1) {
            if ((index = sb.indexOf("\\", index)) < 0) continue;
            if (index < sb.length() - 1) {
                char c;
                if ((c = sb.charAt(index++)) != 'n' && c != 'r') continue;
                sb.replace(index, index + 1, "<BR>");
                continue;
            }
            sb.replace(index, index + 1, "");
        }
        return sb.toString();
    }

    public static String replaceString(String inString, String oldStr, String newStr) {
        StringBuffer sb = new StringBuffer(inString);
        int index = 0;
        while (index != -1) {
            if ((index = sb.indexOf(oldStr, index)) <= -1) continue;
            sb.replace(index, index + oldStr.length(), newStr);
            index += newStr.length();
        }
        return sb.toString();
    }

    public static String replaceChar(String text, char originalChar, char replacementChar) {
        StringBuffer sb = new StringBuffer(text);
        for (int i = 0; i < sb.length(); ++i) {
            if (sb.charAt(i) != originalChar) continue;
            sb.setCharAt(i, replacementChar);
        }
        return sb.toString();
    }

    public static String deleteChar(String text, char c) {
        StringBuffer sb = new StringBuffer(text);
        for (int i = 0; i < sb.length(); ++i) {
            if (sb.charAt(i) != c) continue;
            sb.deleteCharAt(i);
        }
        return sb.toString();
    }

    public static String deleteTrailingChar(String text, char c) {
        StringBuffer sb = new StringBuffer(text);
        if (text.length() > 0) {
            if (sb.charAt(text.length() - 1) == c) {
                sb.deleteCharAt(text.length() - 1);
            }
            return sb.toString();
        }
        return text;
    }

    public static boolean containsNumber(String text) {
        char[] nums = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        for (int i = 0; i < text.length(); ++i) {
            for (int j = 0; j < nums.length; ++j) {
                if (text.charAt(i) != nums[j]) continue;
                return true;
            }
        }
        return false;
    }

    public static String removeAlphaChars(String text) {
        if (text != null && text.length() > 0) {
            StringBuffer sb = new StringBuffer(text);
            for (int i = 0; i < sb.length(); ++i) {
                char c = sb.charAt(i);
                if (c == '.' || c >= '0' && c <= '9') continue;
                sb.replace(i, i + 1, "");
            }
            return sb.toString();
        }
        return text;
    }

    public static String mixedCase(String x) {
        StringBuffer result = new StringBuffer();
        if (x != null && x.length() > 0) {
            result.append(x.charAt(0));
            for (int i = 1; i < x.length(); ++i) {
                char c1 = x.charAt(i - 1);
                char c2 = x.charAt(i);
                if (c1 != ' ' && c1 != '\'' && c1 != '(' && c1 != ',' && c1 != '-' && c1 != '.' && c1 != '/' && c1 != '^' && c2 >= 'A' && c2 <= 'Z') {
                    char c = (char)(x.charAt(i) + 32);
                    result.append(c);
                    continue;
                }
                result.append(x.charAt(i));
            }
        }
        return result.toString();
    }

    public static List<String> mixedCaseList(List<String> list) {
        ArrayList<String> aList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            aList.add(StringUtils.mixedCase(list.get(i)));
        }
        return aList;
    }

    public static String parseDelimitedSSN(String ssn) {
        String delim = "-";
        StringBuffer sb = new StringBuffer();
        int startIndex = 0;
        int endIndex = ssn.indexOf(delim, startIndex);
        while (startIndex <= endIndex) {
            sb.append(ssn.substring(startIndex, endIndex));
            startIndex = endIndex + 1;
            endIndex = ssn.indexOf(delim, startIndex);
        }
        sb.append(ssn.substring(startIndex));
        return sb.toString();
    }

    public static String formatSSN(String ssn) {
        char delim = '-';
        StringBuffer sb = new StringBuffer(ssn);
        if (sb.length() == 9 || sb.length() == 10) {
            sb.insert(3, delim);
            sb.insert(6, delim);
            return sb.toString();
        }
        return ssn;
    }

    public static String unformatSSN(String text) {
        char delim = '-';
        StringBuffer sb = new StringBuffer(text);
        for (int i = 0; i < sb.length(); ++i) {
            if (sb.charAt(i) != delim) continue;
            sb.deleteCharAt(i);
        }
        return sb.toString();
    }

    public static ArrayList<String> getArrayList(String text) {
        return (ArrayList)StringUtils.getStringList(text);
    }

    public static List<String> getStringList(String text) {
        BufferedReader br = new BufferedReader(new StringReader(text));
        ArrayList<String> list = new ArrayList<String>();
        String line = null;
        try {
            while ((line = br.readLine()) != null) {
                list.add(line);
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return list;
    }

    public static int getCharCount(String text, char c) {
        int num = 0;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) != c) continue;
            ++num;
        }
        return num;
    }

    public static int toInt(String s, int def) {
        try {
            if (s == null) {
                return def;
            }
            return Integer.valueOf(s);
        }
        catch (NumberFormatException nfe) {
            return def;
        }
    }

    public static long toLong(String s, long def) {
        try {
            if (s == null) {
                return def;
            }
            return Long.valueOf(s);
        }
        catch (NumberFormatException nfe) {
            return def;
        }
    }

    public static double toDouble(String s, double def) {
        try {
            if (s == null) {
                return def;
            }
            return Double.valueOf(s);
        }
        catch (NumberFormatException nfe) {
            return def;
        }
    }

    public static String getSubstringWithEllipsis(String str, int length) {
        if (str.length() <= length) {
            return str;
        }
        return str.subSequence(0, length - 3) + "...";
    }

    public static String firstCharToUpper(String text) {
        StringBuffer name = new StringBuffer(text);
        char c = name.charAt(0);
        if (c >= 'a' && c <= 'z') {
            c = (char)(c - 32);
            name.setCharAt(0, c);
        }
        return name.toString();
    }

    public static String firstCharToLower(String text) {
        StringBuffer name = new StringBuffer(text);
        char c = name.charAt(0);
        if (c >= 'A' && c <= 'Z') {
            c = (char)(c + 32);
            name.setCharAt(0, c);
        }
        return name.toString();
    }

    public static String formatCurrency(double value) {
        return StringUtils.formatCurrency(value, 2);
    }

    public static String formatCurrency(double value, int numSigDigits) {
        boolean neg;
        boolean bl = neg = value < 0.0;
        if (neg) {
            value = Math.abs(value);
        }
        StringBuffer sb = new StringBuffer(new Format("%." + numSigDigits + "f").format(value));
        sb.insert(0, "$");
        if (neg) {
            sb.insert(0, "-");
        }
        if (numSigDigits == 0) {
            sb.deleteCharAt(sb.indexOf("."));
        }
        return sb.toString();
    }

    public static int getRandomInt(int lo, int hi) {
        Random rn = new Random();
        int n = hi - lo + 1;
        int i = rn.nextInt() % n;
        if (i < 0) {
            i = -i;
        }
        return lo + i;
    }

    public static String getRandomString(int lo, int hi) {
        int n = StringUtils.getRandomInt(lo, hi);
        byte[] b = new byte[n];
        for (int i = 0; i < n; ++i) {
            b[i] = (byte)StringUtils.getRandomInt(97, 122);
        }
        try {
            return new String(b, "US-ASCII");
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void main(String[] args) {
        System.out.println(StringUtils.getRandomString(9, 9));
    }
}

