/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.javaUtils.misc;

import java.util.Vector;

public class Statistics {
    public static double min(double[] data) {
        double low = Double.MAX_VALUE;
        for (int i = 0; i < data.length; ++i) {
            if (!(data[i] < low)) continue;
            low = data[i];
        }
        return low;
    }

    public static double max(double[] data) {
        double high = Double.MIN_VALUE;
        for (int i = 0; i < data.length; ++i) {
            if (!(data[i] > high)) continue;
            high = data[i];
        }
        return high;
    }

    public static double sum(double[] data) {
        double sum = 0.0;
        for (int i = 0; i < data.length; ++i) {
            sum += data[i];
        }
        return sum;
    }

    public static double sum(Double[] data) {
        double sum = 0.0;
        for (int i = 0; i < data.length; ++i) {
            sum += data[i].doubleValue();
        }
        return sum;
    }

    public static double sumOfSquares(double[] data) {
        double sum = 0.0;
        for (int i = 0; i < data.length; ++i) {
            sum += Math.pow(data[i], 2.0);
        }
        return sum;
    }

    public static double sumOfSquares(Double[] data) {
        double sum = 0.0;
        for (int i = 0; i < data.length; ++i) {
            sum += Math.pow(data[i], 2.0);
        }
        return sum;
    }

    public static double product(double[] data) {
        double prod = 1.0;
        for (int i = 0; i < data.length; ++i) {
            prod *= data[i];
        }
        return prod;
    }

    public static double standardDeviation(double[] data) {
        double sum = Statistics.sum(data);
        double sumSqrs = Statistics.sumOfSquares(data);
        int n = data.length;
        double variance = ((double)n * sumSqrs - Math.pow(sum, 2.0)) / (double)(n * (n - 1));
        return Math.sqrt(variance);
    }

    public static double standardDeviation(Double[] data) {
        double sum = Statistics.sum(data);
        double sumSqrs = Statistics.sumOfSquares(data);
        int n = data.length;
        double variance = ((double)n * sumSqrs - Math.pow(sum, 2.0)) / (double)(n * (n - 1));
        return Math.sqrt(variance);
    }

    public static void main(String[] args) {
        Vector<Double> vect = new Vector<Double>();
        vect.add(new Double(1.0));
        vect.add(new Double(2.0));
        vect.add(new Double(3.0));
        Double[] data = vect.toArray(new Double[vect.size()]);
        System.out.println("Standard Deviation = " + Statistics.standardDeviation(data));
    }
}

