/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.javaUtils.misc;

import java.lang.reflect.Method;

public class ReflectUtil {
    public static Method getMethod(Class clazz, String methodName, Class[] paramTypes) throws NoSuchMethodException {
        if (clazz == null || methodName == null || paramTypes == null) {
            throw new IllegalArgumentException();
        }
        Method currentBestCandidate = null;
        Method[] candidates = clazz.getMethods();
        for (int i = 0; i < candidates.length; ++i) {
            if (!ReflectUtil.methodApplicable(candidates[i], methodName, paramTypes)) continue;
            if (currentBestCandidate == null || ReflectUtil.methodMoreSpecific(candidates[i], currentBestCandidate)) {
                currentBestCandidate = candidates[i];
                continue;
            }
            if (ReflectUtil.methodMoreSpecific(currentBestCandidate, candidates[i])) continue;
            throw new NoSuchMethodException("Ambiguity");
        }
        if (currentBestCandidate != null) {
            return currentBestCandidate;
        }
        throw new NoSuchMethodException("No applicable public method");
    }

    public static boolean methodApplicable(Method m, String name, Class[] paramTypes) {
        if (m == null || name == null || paramTypes == null) {
            throw new IllegalArgumentException();
        }
        if (!m.getName().equals(name)) {
            return false;
        }
        Class<?>[] actualParamTypes = m.getParameterTypes();
        if (actualParamTypes.length != paramTypes.length) {
            return false;
        }
        for (int i = 0; i < paramTypes.length; ++i) {
            if (!(actualParamTypes[i].isPrimitive() ? !(actualParamTypes[i].getName().equals("int") && paramTypes[i].getName().equals("java.lang.Integer") || actualParamTypes[i].getName().equals("boolean") && paramTypes[i].getName().equals("java.lang.Boolean") || actualParamTypes[i].getName().equals("double") && paramTypes[i].getName().equals("java.lang.Double") || actualParamTypes[i].getName().equals("long") && paramTypes[i].getName().equals("java.lang.Long") || actualParamTypes[i].getName().equals("char") && paramTypes[i].getName().equals("java.lang.Char") || actualParamTypes[i].getName().equals("short") && paramTypes[i].getName().equals("java.lang.Short") || actualParamTypes[i].getName().equals("byte") && paramTypes[i].getName().equals("java.lang.Byte") || actualParamTypes[i].getName().equals("float") && paramTypes[i].getName().equals("java.lang.Float")) : paramTypes[i] != null && !actualParamTypes[i].isAssignableFrom(paramTypes[i]))) continue;
            return false;
        }
        return true;
    }

    public static boolean methodMoreSpecific(Method more, Method less) {
        Class<?>[] lessParamTypes;
        if (more == null || less == null) {
            throw new IllegalArgumentException("Null parameter");
        }
        if (!more.getName().equals(less.getName())) {
            throw new IllegalArgumentException("Different names");
        }
        Class<?>[] moreParamTypes = more.getParameterTypes();
        if (moreParamTypes.length != (lessParamTypes = less.getParameterTypes()).length) {
            throw new IllegalArgumentException("Different numbers of params");
        }
        if (!less.getDeclaringClass().isAssignableFrom(more.getDeclaringClass())) {
            return false;
        }
        for (int i = 0; i < moreParamTypes.length; ++i) {
            if (lessParamTypes[i].isAssignableFrom(moreParamTypes[i])) continue;
            return false;
        }
        return true;
    }
}

