/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.javaUtils.misc;

import gov.va.med.lom.javaUtils.misc.QSCallBack;
import java.util.Collection;
import java.util.Random;

public class QuickSort {
    private QSCallBack qsCallBack;

    public void setQSCallBack(QSCallBack qsCallBack) {
        this.qsCallBack = qsCallBack;
    }

    public void quickSort(Collection col) {
        Object[] elements = col.toArray();
        this.qsort1(elements, 0, elements.length - 1);
        col.clear();
        for (int i = 0; i < elements.length; ++i) {
            col.add(elements[i]);
        }
    }

    public void quickSort(Object[] elements) {
        this.qsort1(elements, 0, elements.length - 1);
    }

    private void qsort1(Object[] a, int lo, int hi) {
        if (lo < hi) {
            Object t;
            int l = lo;
            int h = hi;
            Object p = a[hi];
            while (true) {
                if (l < h && this.qsCallBack.compare(a[l], p) <= 0) {
                    ++l;
                    continue;
                }
                while (h > l && this.qsCallBack.compare(a[h], p) >= 0) {
                    --h;
                }
                if (l < h) {
                    t = a[l];
                    a[l] = a[h];
                    a[h] = t;
                }
                if (l >= h) break;
            }
            t = a[l];
            a[l] = a[hi];
            a[hi] = t;
            this.qsort1(a, lo, l - 1);
            this.qsort1(a, l + 1, hi);
        }
    }

    private int[] initialize(int n) {
        int i;
        Random rand = new Random(System.currentTimeMillis());
        int[] a = new int[n];
        for (i = 0; i < n; ++i) {
            a[i] = i;
        }
        for (i = 0; i < n; ++i) {
            int r = rand.nextInt(n);
            int temp = a[i];
            a[i] = a[r];
            a[r] = temp;
        }
        return a;
    }
}

