/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.javaUtils.misc;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.BindException;
import java.net.InetAddress;
import java.net.Socket;

public class Printer {
    private boolean printRaw = true;
    private boolean useOutOfBoundsPorts = false;
    private static int jobNumber = 0;

    public void setPrintRaw(boolean printRawData) {
        this.printRaw = printRawData;
    }

    public boolean getPrintRaw() {
        return this.printRaw;
    }

    public void setUseOutOfBoundPorts(boolean OutOfBoundsPorts) {
        this.useOutOfBoundsPorts = OutOfBoundsPorts;
    }

    public boolean getUseOutOfBoundPorts() {
        return this.useOutOfBoundsPorts;
    }

    private Socket getSocket(String hostName) throws IOException, InterruptedException {
        if (this.useOutOfBoundsPorts) {
            return new Socket(hostName, 515);
        }
        Socket tmpSocket = null;
        for (int j = 0; j < 30 && tmpSocket == null; ++j) {
            for (int i = 721; i <= 731 && tmpSocket == null; ++i) {
                try {
                    tmpSocket = new Socket(hostName, 515, InetAddress.getLocalHost(), i);
                    continue;
                }
                catch (BindException be) {
                    // empty catch block
                }
            }
            if (tmpSocket != null) continue;
            Thread.sleep(10000L);
        }
        if (tmpSocket == null) {
            throw new BindException("Can't bind to local port/address");
        }
        return tmpSocket;
    }

    public void printFile(String fileName, String hostName, String printerName) throws IOException, InterruptedException {
        this.printFile(fileName, hostName, printerName, fileName);
    }

    public void printStream(ByteArrayOutputStream stream, String hostName, String printerName, String documentName) throws IOException, InterruptedException {
        String controlFile = "";
        byte[] buffer = new byte[1000];
        if (++jobNumber >= 1000) {
            jobNumber = 1;
        }
        String strJobNumber = "" + jobNumber;
        while (strJobNumber.length() < 3) {
            strJobNumber = "0" + strJobNumber;
        }
        String userName = System.getProperty("user.name");
        if (userName == null) {
            userName = "Unknown";
        }
        Socket socketLpr = this.getSocket(hostName);
        socketLpr.setSoTimeout(30000);
        OutputStream sOut = socketLpr.getOutputStream();
        InputStream sIn = socketLpr.getInputStream();
        String s = "\u0002" + printerName + "\n";
        sOut.write(s.getBytes());
        sOut.flush();
        this.acknowledge(sIn, "Failed to open printer");
        controlFile = controlFile + "H" + hostName + "\n";
        controlFile = controlFile + "P" + userName + "\n";
        controlFile = controlFile + (this.printRaw ? "o" : "p") + "dfA" + strJobNumber + hostName + "\n";
        controlFile = controlFile + "UdfA" + strJobNumber + hostName + "\n";
        controlFile = controlFile + "N" + documentName + "\n";
        s = "\u0002" + controlFile.length() + " cfA" + strJobNumber + hostName + "\n";
        sOut.write(s.getBytes());
        this.acknowledge(sIn, "Failed to send control header");
        buffer = controlFile.getBytes();
        sOut.write(buffer);
        buffer[0] = 0;
        sOut.write(buffer, 0, 1);
        sOut.flush();
        this.acknowledge(sIn, "Failed to send control file");
        s = "\u0003" + stream.size() + " dfA" + strJobNumber + hostName + "\n";
        sOut.write(s.getBytes());
        sOut.flush();
        this.acknowledge(sIn, "Failed to send print file command");
        stream.writeTo(sOut);
        sOut.flush();
        buffer[0] = 0;
        sOut.write(buffer, 0, 1);
        sOut.flush();
        this.acknowledge(sIn, "Failed to send print file");
        socketLpr.close();
    }

    public void printFile(String fileName, String hostName, String printerName, String documentName) throws IOException, InterruptedException {
        int readCounter;
        File f = null;
        byte[] buffer = new byte[1000];
        f = new File(fileName);
        if (!(f.exists() && f.isFile() && f.canRead())) {
            throw new IOException("Error opening print file");
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        FileInputStream fs = new FileInputStream(f);
        do {
            if ((readCounter = fs.read(buffer)) <= 0) continue;
            output.write(buffer, 0, readCounter);
        } while (readCounter > 0);
        this.printStream(output, hostName, printerName, documentName);
    }

    private void acknowledge(InputStream in, String alert) throws IOException {
        if (in.read() != 0) {
            throw new IOException(alert);
        }
    }

    public static void main(String[] args) {
        try {
            if (args.length != 3) {
                System.out.println("Useage: Printer HostName PrinterName PrintFile");
                return;
            }
            Printer myLpr = new Printer();
            myLpr.setPrintRaw(true);
            myLpr.setUseOutOfBoundPorts(true);
            myLpr.printFile(args[2], args[0], args[1]);
            System.out.println("Printed");
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

