/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.javaUtils.misc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class JdbcConnection {
    private Connection conn = null;
    private Statement stmt = null;
    private String url = null;
    private String driver = null;

    public JdbcConnection() {
    }

    public JdbcConnection(String url, String driver) throws Exception {
        this();
        this.setUrl(url);
        this.setDriver(driver);
    }

    public void connect(String username, String password) throws SQLException {
        this.conn = DriverManager.getConnection(this.url, username, password);
        this.stmt = this.conn.createStatement();
    }

    public void disconnect() {
        try {
            if (this.conn != null) {
                this.conn.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public PreparedStatement getPreparedStatement(String sql) throws SQLException {
        return this.conn.prepareStatement(sql);
    }

    public PreparedStatement getPreparedStatementWithGeneratedKeys(String sql) throws SQLException {
        return this.conn.prepareStatement(sql, 1);
    }

    public int doUpdate(String sql) throws SQLException {
        return this.stmt.executeUpdate(sql);
    }

    public int doUpdate(PreparedStatement pstmt) throws SQLException {
        return pstmt.executeUpdate();
    }

    public ResultSet doQuery(String sql) throws SQLException {
        return this.stmt.executeQuery(sql);
    }

    public ResultSet doQuery(PreparedStatement pstmt) throws SQLException {
        return pstmt.executeQuery();
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) throws Exception {
        this.driver = driver;
        Class.forName(driver).newInstance();
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Connection getConnection() {
        return this.conn;
    }
}

