/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.javaUtils.misc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public class DatabaseConnection
implements Serializable {
    private Statement stmt;
    private String url;
    private String dbDriver;
    private String prefix;
    private String serverHost;
    private String database;
    private String username;
    private String password;
    private Properties dbProperties;
    private int connectionMethod = 0;

    public DatabaseConnection() {
    }

    public DatabaseConnection(String dbDriver) throws Exception {
        this();
        this.setDbDriver(dbDriver);
    }

    public void initialize(String url) throws SQLException {
        this.connectionMethod = 1;
        this.url = url;
        this.stmt = DatabaseConnection.doCreateStatement(url);
    }

    public void initialize() throws SQLException {
        this.connectionMethod = 2;
        this.url = this.prefix + "://" + this.serverHost + "/" + this.database;
        this.stmt = DatabaseConnection.doCreateStatement(this.url, this.username, this.password);
    }

    public void initialize(String url, String username, String password) throws SQLException {
        this.connectionMethod = 2;
        this.url = url;
        this.username = username;
        this.password = password;
        this.stmt = DatabaseConnection.doCreateStatement(url, username, password);
    }

    public void initialize(String url, String username, String password, String database) throws SQLException {
        this.connectionMethod = 2;
        this.url = this.url + "/" + database;
        this.username = username;
        this.password = password;
        this.database = database;
        this.stmt = DatabaseConnection.doCreateStatement(url, username, password);
    }

    public void initialize(String prefix, String serverHost, String database, String username, String password) throws SQLException {
        this.prefix = prefix;
        this.serverHost = serverHost;
        this.database = database;
        this.username = username;
        this.password = password;
        this.initialize();
    }

    public void initialize(String prefix, String serverHost, String database, Properties dbProperties) throws SQLException {
        this.connectionMethod = 3;
        this.url = prefix + "://" + serverHost + "/" + database;
        this.prefix = prefix;
        this.serverHost = serverHost;
        this.database = database;
        this.dbProperties = dbProperties;
        this.stmt = DatabaseConnection.doCreateStatement(this.url, dbProperties);
    }

    public boolean logoff() throws SQLException {
        Connection conn;
        if (this.stmt != null && (conn = this.stmt.getConnection()) != null) {
            conn.close();
            return true;
        }
        return false;
    }

    public int doUpdate(String sql) throws SQLException {
        if (this.checkConnection()) {
            return this.stmt.executeUpdate(sql);
        }
        return 0;
    }

    public ResultSet doQuery(String sql) throws SQLException {
        if (this.checkConnection()) {
            return this.stmt.executeQuery(sql);
        }
        return null;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getDbDriver() {
        return this.dbDriver;
    }

    public void setDbDriver(String dbDriver) throws Exception {
        this.dbDriver = dbDriver;
        Class.forName(dbDriver).newInstance();
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getServerHost() {
        return this.serverHost;
    }

    public void setServerHost(String serverHost) {
        this.serverHost = serverHost;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    private boolean checkConnection() throws SQLException {
        if (this.stmt != null) {
            Connection conn = this.stmt.getConnection();
            if (conn.isClosed()) {
                if (this.connectionMethod == 1) {
                    this.stmt = DatabaseConnection.doCreateStatement(this.url);
                } else if (this.connectionMethod == 2) {
                    this.stmt = DatabaseConnection.doCreateStatement(this.url, this.username, this.password);
                } else if (this.connectionMethod == 3) {
                    this.stmt = DatabaseConnection.doCreateStatement(this.url, this.dbProperties);
                }
                if (this.stmt == null || this.stmt.getConnection().isClosed()) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private static Statement doCreateStatement(String url) throws SQLException {
        Connection conn = DriverManager.getConnection(url);
        Statement stmt = conn.createStatement();
        return stmt;
    }

    private static Statement doCreateStatement(String url, String username, String password) throws SQLException {
        Connection conn = DriverManager.getConnection(url, username, password);
        Statement stmt = conn.createStatement();
        return stmt;
    }

    private static Statement doCreateStatement(String url, Properties dbProperties) throws SQLException {
        Connection conn = DriverManager.getConnection(url, dbProperties);
        Statement stmt = conn.createStatement();
        return stmt;
    }
}

