/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.javaUtils.misc;

import gov.va.med.lom.javaUtils.misc.ConnectionReaper;
import gov.va.med.lom.javaUtils.misc.ConnectionWrapper;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBConnectionPool {
    private static final int DB_LOGIN_TIMEOUT = 5;
    private Hashtable<String, ConnectionWrapper> connections;
    private int minPoolSize = 10;
    private String dbServer = null;
    private int dbPort = 0;
    private String dbName = null;
    private String domain = null;
    private String username = null;
    private String password = null;
    private String driver = null;
    private String drivertype = null;
    private String database = null;
    private long inactiveTimeout = 0L;
    private ConnectionReaper reaper = null;

    public DBConnectionPool(String drivertype, String database, String dbServer, int dbPort, String dbName, String domain, String username, String password, String driver, int minPoolSize, long reapDelay, long inactiveTimeout) throws Exception {
        this.drivertype = drivertype;
        this.database = database;
        this.dbServer = dbServer;
        this.dbPort = dbPort;
        this.dbName = dbName;
        this.domain = domain;
        this.username = username;
        this.password = password;
        this.driver = driver;
        if (minPoolSize > 0) {
            this.minPoolSize = minPoolSize;
        }
        this.inactiveTimeout = inactiveTimeout;
        this.connections = new Hashtable();
        this.reaper = new ConnectionReaper(this, reapDelay);
        this.reaper.start();
    }

    public synchronized void reapConnections() throws Exception {
        List<ConnectionWrapper> list = this.getConnections();
        for (ConnectionWrapper connWrapper : list) {
            if (!connWrapper.isClosed() && (this.inactiveTimeout <= 0L || new Date().getTime() - connWrapper.getLastLeased() <= this.inactiveTimeout)) continue;
            this.removeConnection(connWrapper);
            if (this.getPoolSize() >= this.minPoolSize) continue;
            this.createConnection();
        }
    }

    public synchronized void closeConnections() {
        List<ConnectionWrapper> list = this.getConnections();
        for (ConnectionWrapper connWrapper : list) {
            connWrapper.close();
            this.removeConnection(connWrapper);
        }
    }

    public synchronized Connection getConnection() throws Exception {
        List<ConnectionWrapper> list = this.getConnections();
        for (ConnectionWrapper connWrapper : list) {
            if (connWrapper.isAvailable()) {
                return connWrapper.lease();
            }
            this.removeConnection(connWrapper);
        }
        return this.createConnection().lease();
    }

    public synchronized void returnConnection(Connection connection) {
        ConnectionWrapper connWrapper;
        if (connection != null && (connWrapper = this.connections.get(connection.toString())) != null) {
            connWrapper.expireLease();
        }
    }

    public synchronized void destroyConnection(Connection connection) {
        if (connection != null) {
            this.connections.remove(connection.toString());
        }
    }

    public int getPoolSize() {
        return this.connections.size();
    }

    public int getNumLeasedConnections() {
        Enumeration<String> keys = this.connections.keys();
        int n = 0;
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            ConnectionWrapper connWrapper = this.connections.get(key);
            if (!connWrapper.isLeased()) continue;
            ++n;
        }
        return n;
    }

    public void terminate() {
        this.closeConnections();
        this.reaper.terminate();
    }

    private List<ConnectionWrapper> getConnections() {
        ArrayList<ConnectionWrapper> list = new ArrayList<ConnectionWrapper>();
        Enumeration<String> keys = this.connections.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            list.add(this.connections.get(key));
        }
        return list;
    }

    private synchronized void removeConnection(ConnectionWrapper connWrapper) {
        connWrapper.close();
        this.connections.remove(connWrapper);
    }

    private synchronized ConnectionWrapper createConnection() throws Exception {
        Class.forName(this.driver).newInstance();
        StringBuffer sb = new StringBuffer("jdbc:");
        sb.append(this.drivertype);
        sb.append(":");
        sb.append(this.database);
        sb.append("://");
        sb.append(this.dbServer);
        sb.append(":");
        sb.append(this.dbPort);
        sb.append("/");
        sb.append(this.dbName);
        if (this.domain != null) {
            sb.append(";domain=");
            sb.append(this.domain);
        }
        DriverManager.setLoginTimeout(5);
        Connection connection = DriverManager.getConnection(sb.toString(), this.username, this.password);
        return this.addConnection(new ConnectionWrapper(connection));
    }

    private synchronized ConnectionWrapper addConnection(ConnectionWrapper connWrapper) {
        this.connections.put(connWrapper.toString(), connWrapper);
        return connWrapper;
    }
}

