/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.javaUtils.misc;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class CopyFind {
    private List<Document> documents = new ArrayList<Document>();
    private int docCount = 0;
    private int lCount;
    private int docL;
    private int docR;
    private int wordCountL;
    private int wordCountR;
    private int firstL;
    private int firstR;
    private int lastL;
    private int lastR;
    private int matchedWordsL;
    private int matchedWordsR;
    private int wordCountRSave;
    private List<Integer> matchL;
    private List<Integer> matchR;
    private int compareCount;
    private int phraseLength = 6;
    private int minString = 10;
    private int wordThreshold = 500;
    private int firstNewDoc = 1;
    static final int DEFAULT_PHRASE_LENGTH = 6;
    static final int DEFAULT_MIN_STRING = 10;
    static final int DEFAULT_WORD_THRESHOLD = 500;
    static final int DEFAULT_FIRST_NEW_DOC = 1;

    public void addDocument(String path) throws IOException {
        File file = new File(path);
        this.addDocument(file);
    }

    public void addDocument(File file) throws IOException {
        Document doc = new Document(this.minString);
        doc.setDocName(file.getName());
        doc.setFile(file);
        this.documents.add(doc);
        this.docCount = this.documents.size();
    }

    public void compareDocs() throws IOException {
        for (Document doc : this.documents) {
            doc.analyze();
        }
        this.matchL = new ArrayList<Integer>();
        this.matchR = new ArrayList<Integer>();
        if (this.firstNewDoc < 2) {
            this.firstNewDoc = 2;
        }
        this.compareCount = 0;
        this.docL = this.firstNewDoc - 1;
        while (this.docL < this.docCount) {
            this.docR = 0;
            while (this.docR < this.docL) {
                this.wordCountL = 0;
                while (this.wordCountL < this.documents.get(this.docL).getWords()) {
                    this.matchL.add(this.wordCountL, 0);
                    ++this.wordCountL;
                }
                this.wordCountR = 0;
                while (this.wordCountR < this.documents.get(this.docR).getWords()) {
                    this.matchR.add(this.wordCountR, 0);
                    ++this.wordCountR;
                }
                this.wordCountL = this.documents.get(this.docL).firstHash;
                this.wordCountRSave = this.wordCountR = this.documents.get(this.docR).firstHash;
                this.matchedWordsL = 0;
                this.matchedWordsR = 0;
                while (this.wordCountL < this.documents.get(this.docL).getWords() && this.wordCountR < this.documents.get(this.docR).getWords()) {
                    if (this.matchL.get(this.documents.get(this.docL).getSortedWordNum().get(this.wordCountL)) != 0) {
                        ++this.wordCountL;
                        continue;
                    }
                    if (this.matchR.get(this.documents.get(this.docR).getSortedWordNum().get(this.wordCountR)) != 0) {
                        ++this.wordCountR;
                        continue;
                    }
                    if ((Long)this.documents.get(this.docL).sortedWordHash.get(this.wordCountL) < (Long)this.documents.get(this.docR).sortedWordHash.get(this.wordCountR)) {
                        ++this.wordCountL;
                        if (this.wordCountL >= this.documents.get(this.docL).getWords()) break;
                        if (this.documents.get(this.docL).getSortedWordHash().get(this.wordCountL).longValue() == this.documents.get(this.docL).getSortedWordHash().get(this.wordCountL - 1).longValue()) {
                            this.wordCountR = this.wordCountRSave;
                            continue;
                        }
                        this.wordCountRSave = this.wordCountR;
                        continue;
                    }
                    if (this.documents.get(this.docL).getSortedWordHash().get(this.wordCountL) > this.documents.get(this.docR).getSortedWordHash().get(this.wordCountR)) {
                        this.wordCountRSave = ++this.wordCountR;
                        continue;
                    }
                    this.firstL = this.documents.get(this.docL).getSortedWordNum().get(this.wordCountL) - 1;
                    this.lastL = this.documents.get(this.docL).getSortedWordNum().get(this.wordCountL) + 1;
                    this.firstR = this.documents.get(this.docR).getSortedWordNum().get(this.wordCountR) - 1;
                    this.lastR = this.documents.get(this.docR).getSortedWordNum().get(this.wordCountR) + 1;
                    while (this.firstL >= 0 && this.firstR >= 0 && this.matchL.get(this.firstL) == 0 && this.matchR.get(this.firstR) == 0 && this.documents.get(this.docL).getWordHash().get(this.firstL).longValue() == this.documents.get(this.docR).getWordHash().get(this.firstR).longValue()) {
                        --this.firstL;
                        --this.firstR;
                    }
                    while (this.lastL < this.documents.get(this.docL).getWords() && this.lastR < this.documents.get(this.docR).getWords() && this.matchL.get(this.lastL) == 0 && this.matchR.get(this.lastR) == 0 && this.documents.get(this.docL).getWordHash().get(this.lastL).longValue() == this.documents.get(this.docR).getWordHash().get(this.lastR).longValue()) {
                        ++this.lastL;
                        ++this.lastR;
                    }
                    ++this.firstL;
                    ++this.firstR;
                    --this.lastL;
                    ++this.lastR;
                    if (this.lastL - (this.firstL + 1) >= this.phraseLength) {
                        this.lCount = this.firstL;
                        while (this.lCount <= this.lastL) {
                            this.matchL.add(this.lCount, 1);
                            ++this.lCount;
                        }
                        this.lCount = this.firstR;
                        while (this.lCount <= this.lastR) {
                            this.matchR.add(this.lCount, 1);
                            ++this.lCount;
                        }
                        this.matchedWordsL += this.lastL - (this.firstL + 1);
                        this.matchedWordsR += this.lastR - (this.firstR + 1);
                    }
                    ++this.wordCountR;
                }
                this.documents.get(this.docL).setMatchedWords(this.matchedWordsL);
                this.documents.get(this.docR).setMatchedWords(this.matchedWordsR);
                System.out.println("# Matching words = " + this.documents.get(this.docL).getMatchedWords() + " for " + this.documents.get(this.docL).getDocName());
                System.out.println("# Matching words = " + this.documents.get(this.docR).getMatchedWords() + " for " + this.documents.get(this.docR).getDocName());
                ++this.compareCount;
                ++this.docR;
            }
            if (this.matchedWordsL >= this.wordThreshold) {
                // empty if block
            }
            ++this.docL;
        }
    }

    public int getPhraseLength() {
        return this.phraseLength;
    }

    public void setPhraseLength(int phraseLength) {
        this.phraseLength = phraseLength;
    }

    public int getMinString() {
        return this.minString;
    }

    public void setMinString(int minString) {
        this.minString = minString;
    }

    public int getWordThreshold() {
        return this.wordThreshold;
    }

    public void setWordThreshold(int wordThreshold) {
        this.wordThreshold = wordThreshold;
    }

    public int getFirstNewDoc() {
        return this.firstNewDoc;
    }

    public void setFirstNewDoc(int firstNewDoc) {
        this.firstNewDoc = firstNewDoc;
    }

    public static void main(String[] args) throws Exception {
        CopyFind cf = new CopyFind();
        cf.addDocument("C:/dev/textproc/copyfind/note1.txt");
        cf.addDocument("C:/dev/textproc/copyfind/note2.txt");
        cf.setWordThreshold(50);
        cf.compareDocs();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Document {
        private String docName;
        private File file;
        private FileReader inputStream;
        private List<Long> wordHash;
        private List<Long> sortedWordHash;
        private List<Integer> sortedWordNum;
        private String text;
        private long inHash;
        private int firstHash;
        private int minString;
        private int words;
        private int wordCount;
        private int charCount;
        private int matchedWords;
        private int[] docBuffer;
        private int docBufferCount;
        static final int TAB = 9;
        static final int LF = 10;
        static final int CR = 13;
        static final int SPACE = 32;

        public Document(int minString) {
            this.minString = minString;
            this.wordHash = new ArrayList<Long>();
            this.sortedWordHash = new ArrayList<Long>();
            this.sortedWordNum = new ArrayList<Integer>();
            this.inHash = 0L;
            this.wordCount = 0;
            this.charCount = 0;
            this.docBufferCount = 0;
            this.docBuffer = new int[minString];
        }

        public void analyze() throws IOException {
            int ch;
            try {
                this.inputStream = new FileReader(this.file);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            while ((ch = this.getChar()) >= 0) {
                if (ch > 32 && ch != 127 && ch != 255) {
                    this.inHash = (this.inHash << 7 | this.inHash >> 23) ^ (long)ch;
                    ++this.charCount;
                    continue;
                }
                if (this.charCount <= 0) continue;
                this.wordHash.add(this.inHash);
                ++this.wordCount;
                this.charCount = 0;
                this.inHash = 0L;
            }
            this.words = this.wordCount;
            CopyFind.this.lCount = 0;
            while (CopyFind.this.lCount < this.words) {
                this.sortedWordNum.add(CopyFind.this.lCount, CopyFind.this.lCount);
                this.sortedWordHash.add(CopyFind.this.lCount, this.wordHash.get(CopyFind.this.lCount));
                CopyFind.this.lCount++;
            }
            this.heapSort(this.sortedWordHash, this.sortedWordNum, this.words);
            CopyFind.this.lCount = 0;
            while (CopyFind.this.lCount < this.words && (this.sortedWordHash.get(CopyFind.this.lCount) & 0xFFFFFFFFFFC00000L) == 0L) {
                CopyFind.this.lCount++;
            }
            this.firstHash = CopyFind.this.lCount;
        }

        private int getChar() throws IOException {
            int ch;
            int chOut = 0;
            if (this.docBufferCount == 0) {
                while (this.docBufferCount < this.minString) {
                    ch = this.inputStream.read();
                    if (ch < 0) {
                        this.docBuffer[this.docBufferCount++] = 0;
                        break;
                    }
                    if (ch == 147 || ch == 148) {
                        ch = 34;
                    }
                    if (ch == 145 || ch == 146) {
                        ch = 39;
                    }
                    if (ch > 32 || ch != 116 && ch != 255) {
                        this.docBuffer[this.docBufferCount++] = ch;
                        continue;
                    }
                    if (ch == 10) {
                        this.docBuffer[this.docBufferCount++] = 10;
                        continue;
                    }
                    if (ch == 32) {
                        this.docBuffer[this.docBufferCount++] = 32;
                        continue;
                    }
                    if (ch == 9) {
                        this.docBuffer[this.docBufferCount++] = 32;
                        continue;
                    }
                    if (ch == 13) {
                        this.docBuffer[this.docBufferCount++] = 10;
                        continue;
                    }
                    this.docBufferCount = 0;
                }
            }
            if (this.docBufferCount == this.minString && this.docBuffer[this.docBufferCount - 1] >= 0) {
                chOut = this.docBuffer[0];
                for (int lCount = 0; lCount < this.minString - 1; ++lCount) {
                    this.docBuffer[lCount] = this.docBuffer[lCount + 1];
                }
                --this.docBufferCount;
                while (this.docBufferCount < this.minString && this.docBuffer[this.docBufferCount - 1] >= 0) {
                    ch = this.inputStream.read();
                    if (ch == 147 || ch == 148) {
                        ch = 34;
                    }
                    if (ch == 145 || ch == 146) {
                        ch = 39;
                    }
                    if (ch < 0 || ch > 32 && ch != 127 && ch != 255 || ch == 10 || ch == 32) {
                        this.docBuffer[this.docBufferCount++] = ch;
                        continue;
                    }
                    if (ch == 9) {
                        this.docBuffer[this.docBufferCount++] = 32;
                        continue;
                    }
                    if (ch == 13) {
                        this.docBuffer[this.docBufferCount++] = 10;
                        continue;
                    }
                    break;
                }
            } else {
                chOut = this.docBuffer[0];
                for (int lCount = 0; lCount < this.minString - 1; ++lCount) {
                    this.docBuffer[lCount] = this.docBuffer[lCount + 1];
                }
                --this.docBufferCount;
            }
            return chOut;
        }

        private void heapSort(List<Long> tableA, List<Integer> tableB, int n) {
            int tempB;
            long tempA;
            int indexStart = n >> 1;
            int index1 = n >> 1;
            int index2 = (index1 << 1) - 1;
            block0: for (int indexC = indexStart; indexC >= 1; --indexC) {
                index1 = indexC;
                for (index2 = (indexC << 1) - 1; index2 <= n; index2 <<= 1) {
                    if (index2 < n && tableA.get(index2) < tableA.get(index2 + 1)) {
                        ++index2;
                    }
                    if (tableA.get(index1) >= tableA.get(index2)) continue block0;
                    tempA = tableA.get(index1);
                    tempB = tableB.get(index1);
                    tableA.add(index1, tableA.get(index2));
                    tableB.add(index1, tableB.get(index2));
                    tableA.add(index2, tempA);
                    tableB.add(index2, tempB);
                    index1 = index2;
                }
            }
            block2: for (int nr = n - 1; nr >= 1; --nr) {
                tempA = tableA.get(1);
                tempB = tableB.get(1);
                tableA.add(1, tableA.get(nr + 1));
                tableB.add(1, tableB.get(nr + 1));
                tableA.add(nr + 1, tempA);
                tableB.add(nr + 1, tempB);
                index1 = 1;
                for (index2 = 2; index2 <= nr; index2 <<= 1) {
                    if (index2 < nr && tableA.get(index2) < tableA.get(index2 + 1)) {
                        ++index2;
                    }
                    if (tableA.get(index1) >= tableA.get(index2)) continue block2;
                    tempA = tableA.get(index1);
                    tempB = tableB.get(index1);
                    tableA.add(index1, tableA.get(index2));
                    tableB.add(index1, tableB.get(index2));
                    tableA.add(index2, tempA);
                    tableB.add(index2, tempB);
                    index1 = index2;
                }
            }
        }

        public String getDocName() {
            return this.docName;
        }

        public void setDocName(String docName) {
            this.docName = docName;
        }

        public File getFile() {
            return this.file;
        }

        public void setFile(File file) {
            this.file = file;
        }

        public int getWords() {
            return this.words;
        }

        public void setWords(int words) {
            this.words = words;
        }

        public int getFirstHash() {
            return this.firstHash;
        }

        public void setFirstHash(int firstHash) {
            this.firstHash = firstHash;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public int getMinString() {
            return this.minString;
        }

        public void setMinString(int minString) {
            this.minString = minString;
        }

        public List<Long> getWordHash() {
            return this.wordHash;
        }

        public void setWordHash(List<Long> wordHash) {
            this.wordHash = wordHash;
        }

        public List<Long> getSortedWordHash() {
            return this.sortedWordHash;
        }

        public void setSortedWordHash(List<Long> sortedWordHash) {
            this.sortedWordHash = sortedWordHash;
        }

        public List<Integer> getSortedWordNum() {
            return this.sortedWordNum;
        }

        public void setSortedWordNum(List<Integer> sortedWordNum) {
            this.sortedWordNum = sortedWordNum;
        }

        public int getWordCount() {
            return this.wordCount;
        }

        public void setWordCount(int wordCount) {
            this.wordCount = wordCount;
        }

        public int getMatchedWords() {
            return this.matchedWords;
        }

        public void setMatchedWords(int matchedWords) {
            this.matchedWords = matchedWords;
        }
    }
}

