/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.javaUtils.misc;

import java.io.IOException;

public class Console {
    public static void print(String text) {
        System.out.print(text);
        System.out.flush();
    }

    public static void println(String text) {
        System.out.println(text);
        System.out.flush();
    }

    public static void paddedPrint(String text, int len) {
        System.out.print(text);
        for (int i = 0; i < len - text.length(); ++i) {
            System.out.print(" ");
        }
        System.out.flush();
    }

    public static void paddedPrintln(String text, int len) {
        Console.paddedPrint(text, len);
        System.out.println();
        System.out.flush();
    }

    public static String readLine() {
        String r = "";
        boolean done = false;
        while (!done) {
            try {
                int ch = System.in.read();
                if (ch < 0 || (char)ch == '\n') {
                    done = true;
                    continue;
                }
                if ((char)ch == '\r') continue;
                r = r + (char)ch;
            }
            catch (IOException e) {
                done = true;
            }
        }
        return r;
    }

    public static String readLine(String prompt) {
        Console.print(prompt + " ");
        return Console.readLine();
    }

    public static int readInt(String prompt) {
        while (true) {
            Console.print(prompt + " ");
            try {
                return Integer.valueOf(Console.readLine().trim());
            }
            catch (NumberFormatException e) {
                System.out.println("Not an integer. Please try again!");
                continue;
            }
            break;
        }
    }

    public static long readLong(String prompt) {
        while (true) {
            Console.print(prompt + " ");
            try {
                return Long.valueOf(Console.readLine().trim());
            }
            catch (NumberFormatException e) {
                System.out.println("Not an integer. Please try again!");
                continue;
            }
            break;
        }
    }

    public static double readDouble(String prompt) {
        while (true) {
            Console.print(prompt + " ");
            try {
                Double d = new Double(Console.readLine().trim());
                return d;
            }
            catch (NumberFormatException e) {
                System.out.println("Not a floating point number. Please try again!");
                continue;
            }
            break;
        }
    }
}

