/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.javaUtils.misc;

import java.sql.Connection;
import java.sql.Statement;
import java.util.Date;

class ConnectionWrapper {
    private Connection connection;
    private Date lastLeased;
    private boolean leased;

    public ConnectionWrapper(Connection connection) {
        this.connection = connection;
        this.lastLeased = new Date();
    }

    public Connection lease() {
        this.lastLeased = new Date();
        this.leased = true;
        return this.connection;
    }

    public void expireLease() {
        this.leased = false;
    }

    public long getLastLeased() {
        return this.lastLeased.getTime();
    }

    public void close() {
        try {
            this.connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isAvailable() {
        return !this.isLeased() && !this.isClosed() && this.testConnection();
    }

    public boolean isClosed() {
        try {
            return this.connection.isClosed();
        }
        catch (Exception e) {
            return true;
        }
    }

    public boolean testConnection() {
        try {
            Statement stmt = this.connection.createStatement();
            stmt.executeQuery("SELECT 1");
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean isLeased() {
        return this.leased;
    }

    public String toString() {
        return this.connection.toString();
    }
}

