/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.javaUtils.misc;

import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

public class AccessJdbcConnector {
    private static final String accessDBURLPrefix = "jdbc:odbc:Driver={Microsoft Access Driver (*.mdb)};DBQ=";
    private static final String accessDBURLSuffix = ";DriverID=22;READONLY=true}";

    public static Connection getWinAccessDBConnection(String filename) throws SQLException {
        filename = filename.replace('\\', '/').trim();
        String databaseURL = accessDBURLPrefix + filename + accessDBURLSuffix;
        return DriverManager.getConnection(databaseURL, "", "");
    }

    public static Connection getRmiAccessDBConnection(String rmiHost, String filename) throws SQLException {
        String databaseURL = "jdbc:rmi://" + rmiHost + "/" + accessDBURLPrefix + filename + accessDBURLSuffix;
        return DriverManager.getConnection(databaseURL, "", "");
    }

    public static void printResultSet(PrintStream p, ResultSet rs, String title) throws SQLException {
        if (rs != null) {
            ResultSetMetaData metaData = rs.getMetaData();
            int cols = metaData.getColumnCount();
            p.println("\n--------------------------\n" + title + "\n--------------------------");
            for (int i = 1; i <= cols; ++i) {
                p.print(metaData.getColumnLabel(i) + "\t");
            }
            p.println("\n--------------------------");
            int count = 0;
            while (rs.next()) {
                for (int i = 1; i <= cols; ++i) {
                    p.print(rs.getString(i) + "\t");
                }
                p.println("\n--------------------------");
                ++count;
            }
            p.println("Rows: " + count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length < 2 || args.length > 3) {
            System.out.println("Example: java AccessJdbcConnector [rmi_host] database_name.mdb \"database query\"");
            System.exit(1);
        }
        Connection conn = null;
        String sql = null;
        try {
            if (args.length == 2) {
                conn = AccessJdbcConnector.getWinAccessDBConnection(args[0]);
                sql = args[1];
            } else {
                conn = AccessJdbcConnector.getRmiAccessDBConnection(args[0], args[1]);
                sql = args[2];
            }
            Statement stmt = conn.createStatement();
            if (stmt.execute(sql)) {
                AccessJdbcConnector.printResultSet(System.out, stmt.getResultSet(), "Query Result");
            } else {
                System.out.println("DDL executed successfully");
            }
        }
        catch (SQLException s) {
            System.out.println(s);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    static {
        try {
            Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
        }
        catch (ClassNotFoundException e) {
            System.err.println("JdbcOdbc Bridge Driver not found!");
        }
        try {
            Class.forName("org.objectweb.rmijdbc.Driver");
        }
        catch (ClassNotFoundException e) {
            System.err.println("ObjectWeb RMI/JDBC Driver not found!");
        }
    }
}

