/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.javaUtils.logging;

import gov.va.med.lom.javaUtils.logging.LogChannel;
import gov.va.med.lom.javaUtils.logging.Logger;
import gov.va.med.lom.javaUtils.logging.StandardLogChannel;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;

public class StandardLogger
extends Logger {
    private Hashtable levelNumbers = new Hashtable();
    protected String[] levelNames = new String[14];
    protected int numLevels = 0;
    protected boolean[] enabledLevelFlags = null;
    protected boolean[] logFileLevelFlags = null;
    protected boolean[] stderrLevelFlags = null;
    File activeLogFile;
    PrintWriter logFileStream;
    PrintWriter stderrStream;
    private Hashtable logChannels = new Hashtable();

    public StandardLogger() {
        this(false);
    }

    public StandardLogger(boolean makeCentral) {
        int level;
        for (level = 0; level <= 7; ++level) {
            String name = standardLevelNames[level];
            this.levelNumbers.put(name, new Integer(level));
            this.levelNames[level] = name;
        }
        this.numLevels = level;
        if (makeCentral) {
            centralLogger = this;
        }
    }

    private int getMaxLevel(String[] levels) {
        int maxLevelNum = 0;
        for (int idx = 0; idx < levels.length; ++idx) {
            int levelNum = this.getLevel(levels[idx]);
            if (levelNum <= maxLevelNum) continue;
            maxLevelNum = levelNum;
        }
        return maxLevelNum;
    }

    private boolean[] getLevelStateArray(String[] levels, int maxLevelNum) {
        boolean[] levelNums = new boolean[maxLevelNum + 1];
        for (int idx = 0; idx < levels.length; ++idx) {
            levelNums[this.getLevel((String)levels[idx])] = true;
        }
        return levelNums;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized File switchLogFile(File logFile) throws IOException {
        PrintWriter oldLogFileStream = this.logFileStream;
        File oldActiveLogFile = this.activeLogFile;
        FileOutputStream out = new FileOutputStream(logFile.getPath(), true);
        this.logFileStream = new PrintWriter(out, false);
        this.activeLogFile = logFile;
        if (oldLogFileStream != null) {
            PrintWriter printWriter = oldLogFileStream;
            synchronized (printWriter) {
                oldLogFileStream.close();
            }
        }
        return oldActiveLogFile;
    }

    public synchronized void configure(File logFile, int[] fileLevels, int[] strerrLevels) throws IOException {
        int i;
        String[] fileLevelsStr = new String[fileLevels.length];
        String[] stderrLevelsStr = new String[strerrLevels.length];
        for (i = 0; i < fileLevels.length; ++i) {
            fileLevelsStr[i] = standardLevelNames[fileLevels[i]];
        }
        for (i = 0; i < strerrLevels.length; ++i) {
            stderrLevelsStr[i] = standardLevelNames[strerrLevels[i]];
        }
        this.configure(logFile, fileLevelsStr, stderrLevelsStr);
    }

    public synchronized void configure(File logFile, String[] fileLevels, String[] stderrLevels) throws IOException {
        int idx;
        if (logFile.getParent() != null) {
            new File(logFile.getParent()).mkdirs();
        }
        this.switchLogFile(logFile);
        this.stderrStream = new PrintWriter(System.err, false);
        int maxLevelNum = this.enabledLevelFlags != null ? this.enabledLevelFlags.length - 1 : 7;
        int levelNum = this.getMaxLevel(fileLevels);
        if (levelNum > maxLevelNum) {
            maxLevelNum = levelNum;
        }
        if ((levelNum = this.getMaxLevel(stderrLevels)) > maxLevelNum) {
            maxLevelNum = levelNum;
        }
        this.logFileLevelFlags = this.getLevelStateArray(fileLevels, maxLevelNum);
        this.stderrLevelFlags = this.getLevelStateArray(stderrLevels, maxLevelNum);
        this.enabledLevelFlags = new boolean[maxLevelNum + 1];
        for (idx = 0; idx < this.logFileLevelFlags.length; ++idx) {
            if (!this.logFileLevelFlags[idx]) continue;
            this.enabledLevelFlags[idx] = true;
        }
        for (idx = 0; idx < this.stderrLevelFlags.length; ++idx) {
            if (!this.stderrLevelFlags[idx]) continue;
            this.enabledLevelFlags[idx] = true;
        }
    }

    private synchronized StandardLogChannel createChannel(String facility) {
        StandardLogChannel channel = (StandardLogChannel)this.logChannels.get(facility);
        if (channel == null) {
            channel = new StandardLogChannel(facility, this);
            this.logChannels.put(facility, channel);
        }
        return channel;
    }

    public LogChannel getChannel(String facility) {
        StandardLogChannel channel = (StandardLogChannel)this.logChannels.get(facility);
        if (channel == null) {
            channel = this.createChannel(facility);
        }
        return channel;
    }

    private synchronized Integer createLevel(String level) {
        Integer intLevel = (Integer)this.levelNumbers.get(level);
        if (intLevel == null) {
            intLevel = new Integer(this.numLevels);
            this.levelNames[this.numLevels] = level;
            this.levelNumbers.put(level, intLevel);
            ++this.numLevels;
        }
        return intLevel;
    }

    public synchronized int getLevel(String level) {
        Integer intLevel = (Integer)this.levelNumbers.get(level);
        if (intLevel == null) {
            intLevel = this.createLevel(level);
        }
        return intLevel;
    }

    public String getLogLevelName(int level) {
        if (level >= 0 && level < this.numLevels) {
            return this.levelNames[level];
        }
        return null;
    }
}

