/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.javaUtils.html;

import gov.va.med.lom.javaUtils.html.HtmlTableCell;
import java.util.Enumeration;
import java.util.Vector;

public class HtmlTableRow {
    public static final int ALIGN_LEFT = 1;
    public static final int ALIGN_CENTER = 2;
    public static final int ALIGN_RIGHT = 3;
    public static final int VALIGN_TOP = 1;
    public static final int VALIGN_MIDDLE = 2;
    public static final int VALIGN_BOTTOM = 3;
    private String caption = null;
    private String align = null;
    private String valign = null;
    private Vector row = new Vector();
    private int colSpan = 0;
    private int rowSpan = 0;
    private String bgColor = null;

    public HtmlTableRow() {
    }

    public HtmlTableRow(HtmlTableCell td) {
        this.addCell(td);
    }

    public HtmlTableRow(String td) {
        this.addCell(td);
    }

    public void addCell(HtmlTableCell td) {
        this.row.addElement(td);
    }

    public void addCell(String td) {
        this.row.addElement(td);
    }

    public void setHorizontalAlignment(int alignment) {
        switch (alignment) {
            case 2: {
                this.align = "CENTER";
                break;
            }
            case 3: {
                this.align = "RIGHT";
                break;
            }
            default: {
                this.align = "LEFT";
            }
        }
    }

    public void setVerticalAlignment(int alignment) {
        switch (alignment) {
            case 1: {
                this.valign = "TOP";
                break;
            }
            case 2: {
                this.valign = "MIDDLE";
                break;
            }
            default: {
                this.valign = "BOTTOM";
            }
        }
    }

    public void setRowSpan(int rowSpan) {
        if (rowSpan > 0) {
            this.rowSpan = rowSpan;
        }
    }

    public void setColSpan(int colSpan) {
        if (colSpan > 0) {
            this.colSpan = colSpan;
        }
    }

    public void setBackgroundColor(String bgColor) {
        this.bgColor = bgColor;
    }

    public String toString() {
        StringBuffer html = new StringBuffer();
        html.append("<TR");
        if (this.align != null) {
            html.append(" ALIGN=" + this.align);
        }
        if (this.valign != null) {
            html.append(" VALIGN=" + this.valign);
        }
        if (this.colSpan > 0) {
            html.append(" COLSPAN=" + this.colSpan);
        }
        if (this.rowSpan > 0) {
            html.append(" ROWSPAN=" + this.rowSpan);
        }
        if (this.bgColor != null) {
            html.append(" BGCOLOR=" + this.bgColor);
        }
        html.append(">\n");
        Enumeration e = this.row.elements();
        while (e.hasMoreElements()) {
            html.append(e.nextElement().toString());
        }
        html.append("</TR>\n");
        return html.toString();
    }
}

