/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.javaUtils.html;

import gov.va.med.lom.javaUtils.html.HtmlTableRow;
import java.util.Enumeration;
import java.util.Vector;

public class HtmlTable {
    private String caption = null;
    private int percentWidth = 100;
    private int percentHeight = 100;
    private int borderWidth = -1;
    private int cellPadding = -1;
    private int cellSpacing = -1;
    private String bgColor = null;
    private String rules = null;
    private String frame = null;
    private Vector rows = new Vector();
    private Object thead = null;

    public HtmlTable() {
        this.caption = null;
    }

    public HtmlTable(String caption) {
        this.caption = caption;
    }

    public void setBorderWidth(int pixels) {
        this.borderWidth = pixels;
    }

    public void addRow(HtmlTableRow row) {
        this.rows.addElement(row);
    }

    public void addRow(String row) {
        this.rows.addElement(row);
    }

    public void setHeader(Object row) {
        this.thead = row;
    }

    public void setPercentWidth(int percent) {
        if (percent > 0 && percent <= 100) {
            this.percentWidth = percent;
        }
    }

    public void setPercentHeight(int percent) {
        if (percent > 0 && percent <= 100) {
            this.percentHeight = percent;
        }
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public void setCellSpacing(int size) {
        if (size >= 0) {
            this.cellSpacing = size;
        }
    }

    public void setCellPadding(int size) {
        if (size >= 0) {
            this.cellPadding = size;
        }
    }

    public void setBackgroundColor(String bgColor) {
        this.bgColor = bgColor;
    }

    public void setFrame(String frame) {
        this.frame = frame;
    }

    public void setRules(String rules) {
        this.rules = rules;
    }

    public String toString() {
        StringBuffer html = new StringBuffer();
        html.append("<TABLE");
        if (this.borderWidth >= 0) {
            html.append(" BORDER=" + this.borderWidth);
        }
        if (this.percentWidth > 0) {
            html.append(" WIDTH=" + this.percentWidth + "%");
        }
        if (this.cellPadding >= 0) {
            html.append(" CELLPADDING=" + this.cellPadding);
        }
        if (this.cellSpacing >= 0) {
            html.append(" CELLSPACING=" + this.cellSpacing);
        }
        if (this.bgColor != null) {
            html.append(" BGCOLOR=" + this.bgColor);
        }
        if (this.rules != null) {
            html.append(" RULES=" + this.rules);
        }
        if (this.frame != null) {
            html.append(" FRAME=" + this.frame);
        }
        html.append(">\n");
        if (this.caption != null) {
            html.append("<CAPTION>");
            html.append(this.caption);
            html.append("</CAPTION>\n");
        }
        if (this.thead != null) {
            html.append("<THEAD>");
            html.append(this.thead.toString());
            html.append("</THEAD>\n");
        }
        Enumeration e = this.rows.elements();
        while (e.hasMoreElements()) {
            html.append(e.nextElement().toString());
        }
        html.append("</TABLE>\n");
        return html.toString();
    }
}

