/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.javaUtils.html;

import gov.va.med.lom.javaUtils.misc.DateUtils;
import java.text.DateFormat;
import java.util.Date;
import java.util.Vector;

public class HTMLContent {
    private int numRows;
    private int numCols;
    private StringBuffer htmlContent;
    private String date;
    public String title;
    public String patientName;
    public String patientID;
    public String bgColor;
    public String tableBGColor;
    public String cellSpacing;
    public String cellPadding;
    public String headerColor;
    public String font;
    public String textColor;
    public String headerFontSize;
    public String fontSize;
    public String rowColor1;
    public String rowColor2;
    public String[] rowColors;
    public String[] colSizes;
    public String[] colHeaders;
    public String[][] data;

    public HTMLContent(String title, int numCols, int numRows) {
        this.numCols = numCols;
        this.numRows = numRows;
        this.title = title;
        this.bgColor = "#FFFFFF";
        this.tableBGColor = "#6D6C6C";
        this.cellSpacing = "1";
        this.cellPadding = "1";
        this.headerColor = "#CCCCCC";
        this.font = "ms sans serif";
        this.textColor = "#000000";
        this.headerFontSize = "1";
        this.fontSize = "2";
        this.rowColor1 = "#FFFFFF";
        this.rowColor2 = "#E8E8E8";
        this.rowColors = new String[numRows];
        this.colSizes = new String[numCols];
        this.colHeaders = new String[numCols];
        this.data = new String[numCols][numRows];
        this.htmlContent = new StringBuffer();
        this.date = DateFormat.getDateInstance().format(new Date());
        for (int i = 0; i < this.rowColors.length; ++i) {
            this.rowColors[i] = "";
        }
    }

    private String getCol(String width, String bgColor, String font, String fontColor, String fontSize, String value) {
        return "<TD width=\"" + width + "\" bgcolor=\"" + bgColor + "\">" + "<FONT face=\"" + font + "\" color = \"" + fontColor + "\" size=\"" + fontSize + "\">" + value + "</FONT></TD>";
    }

    public void createTable() {
        int i;
        boolean evenRow = false;
        this.htmlContent.append("<TABLE width=\"100%\" border=\"0\" cellspacing=\"" + this.cellSpacing + "\" cellpadding=\"" + this.cellPadding + "\" bgcolor=\"" + this.tableBGColor + "\">");
        this.htmlContent.append("<TR><!-- Header Row -->");
        for (i = 0; i < this.numCols; ++i) {
            this.htmlContent.append(this.getCol(this.colSizes[i], this.headerColor, this.font, this.textColor, this.headerFontSize, "<B>" + this.colHeaders[i] + "</B>"));
        }
        this.htmlContent.append("</TR>");
        String currentColor = this.rowColor1;
        for (i = 0; i < this.numRows; ++i) {
            this.htmlContent.append("<TR><!-- Data Row -->");
            for (int j = 0; j < this.numCols; ++j) {
                String color = this.rowColors[i].equals("") ? currentColor : this.rowColors[i];
                this.htmlContent.append(this.getCol(this.colSizes[j], color, this.font, this.textColor, this.fontSize, this.data[j][i]));
            }
            currentColor = currentColor.compareTo(this.rowColor1) == 0 ? this.rowColor2 : this.rowColor1;
            this.htmlContent.append("</TR>");
        }
        this.htmlContent.append("</TABLE>");
    }

    public String getHTMLContent(String title, int numRecords, String additionalContent) {
        StringBuffer content = new StringBuffer();
        content.append("<HTML><HEAD><TITLE>" + title + "</TITLE></HEAD><BODY bgcolor=\"#FFFFFF\" ");
        content.append("style=\"font-family:ms sans serif;border:0px;margin:0px\">");
        content.append("<STYLE> SPAN {BORDER-RIGHT: #CCCCCC 1px solid;");
        content.append("PADDING-RIGHT: 3px;BORDER-TOP: #CCCCCC 1px solid;");
        content.append("DISPLAY: inline;PADDING-LEFT: 3px;PADDING-BOTTOM: 2px;");
        content.append("BORDER-LEFT: #CCCCCC 1px solid;PADDING-TOP: 2px;");
        content.append("BORDER-BOTTOM: #CCCCCC 1px solid;POSITION: relative;");
        content.append("TOP: 1px;HEIGHT: 17px }");
        content.append("A.MouseOver {COLOR: #0000FF} A.MouseOut {COLOR: #000000}");
        content.append("A {COLOR: #000000;TEXT-DECORATION: none }</STYLE><SPAN>");
        content.append("<TABLE width=\"100%\" border=\"0\" cellpadding=\"1\" cellspacing=\"1\">");
        content.append("<TR><TD align=\"left\"><FONT face=\"ms sans serif\" size=\"4\" color=\"#000000\"><B>" + title + "</B></FONT></TD>");
        content.append("<TD align=\"right\"><FONT face=\"ms sans serif\" size=\"2\" color=\"#000000\">Date@Time: " + DateUtils.getEnglishDateTime() + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;# Records: " + numRecords + "</FONT></TD></TR>");
        content.append("</TABLE>");
        if (!additionalContent.equals("")) {
            content.append(additionalContent);
            content.append("<BR>");
        }
        content.append(this.getContent());
        content.append("</SPAN></BODY></HTML>");
        return content.toString();
    }

    public void setColName(int index, String name) {
        this.colHeaders[index] = name;
    }

    public void setColNames(String[] names) {
        for (int i = 0; i < names.length; ++i) {
            this.colHeaders[i] = names[i];
        }
    }

    public void setColSize(int index, String size) {
        this.colSizes[index] = size;
    }

    public void setColSizes(String[] sizes) {
        for (int i = 0; i < sizes.length; ++i) {
            this.colSizes[i] = sizes[i];
        }
    }

    public void setCellData(int colIndex, int rowIndex, String data) {
        this.data[colIndex][rowIndex] = data;
    }

    public void setCellDataAnchor(int colIndex, int rowIndex, String data, String anchorValue) {
        this.data[colIndex][rowIndex] = "<A onmouseover = \"this.className='MouseOver'\" onmouseout = \"this.className='MouseOut'\" href=\"" + anchorValue + "\">" + data + "</A>";
    }

    public void setData(String[][] data) {
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                this.data[i][j] = data[i][j];
            }
        }
    }

    public void setData(Vector[] data) {
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].size(); ++j) {
                this.data[i][j] = (String)data[i].elementAt(j);
            }
        }
    }

    public void reset() {
        this.htmlContent.replace(0, this.htmlContent.length(), "");
        this.colSizes = null;
        this.colHeaders = null;
    }

    public void clear() {
        this.reset();
    }

    public String getContent() {
        return this.htmlContent.toString();
    }

    public void setBGColor(String bgColor) {
        this.bgColor = bgColor;
    }

    public void setTableBGColor(String tableBGColor) {
        this.tableBGColor = tableBGColor;
    }

    public void setCellSpacing(String cellSpacing) {
        this.cellSpacing = cellSpacing;
    }

    public void setCellPadding(String cellPadding) {
        this.cellPadding = cellPadding;
    }

    public void setHeaderColor(String headerColor) {
        this.headerColor = headerColor;
    }

    public void setFont(String font) {
        this.font = font;
    }

    public void setTextColor(String textColor) {
        this.textColor = textColor;
    }

    public void setFontSize(String fontSize) {
        this.fontSize = fontSize;
    }

    public void setRowColor(int rowIndex, String rowColor) {
        this.rowColors[rowIndex] = rowColor;
    }

    public void setRowColor1(String rowColor1) {
        this.rowColor1 = rowColor1;
    }

    public void setRowColor2(String rowColor2) {
        this.rowColor2 = rowColor2;
    }
}

