/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.javaUtils.file;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class TextFile {
    private String filepath;
    private String text = null;
    private long numChars = -1L;

    public TextFile() {
    }

    public TextFile(String filepath) throws IOException {
        this();
        this.filepath = filepath;
        this.loadFile(filepath);
    }

    public static boolean fileExists(String filepath) {
        return new File(filepath).exists();
    }

    public String loadFile(String filepath) throws IOException {
        String line;
        this.filepath = filepath;
        StringBuffer fileContents = new StringBuffer();
        BufferedReader in = new BufferedReader(new FileReader(filepath));
        while ((line = in.readLine()) != null) {
            fileContents.append(line + "\n");
        }
        in.close();
        this.text = fileContents.toString();
        return this.text;
    }

    public String loadFile() throws IOException {
        return this.loadFile(this.filepath);
    }

    public long getCharCount() {
        if (this.numChars == -1L) {
            for (int i = 0; i < this.text.length(); ++i) {
                if (this.text.charAt(i) == '\n') continue;
                ++this.numChars;
            }
        }
        return this.numChars;
    }

    public String toLowerCase() {
        this.text = this.text.toLowerCase();
        return this.text;
    }

    public String toUpperCase() {
        this.text = this.text.toUpperCase();
        return this.text;
    }

    public void print() {
        System.out.println(this.text);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void saveFile(String filename) throws IOException {
        BufferedWriter out = new BufferedWriter(new FileWriter(filename));
        out.write(this.text);
        out.flush();
        out.close();
    }

    public void saveFile() throws IOException {
        this.saveFile(this.filepath);
    }

    public String getFileName() {
        return new File(this.filepath).getName();
    }
}

