/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.javaUtils.file;

import java.io.File;
import java.io.IOException;

class TempDir {
    File dir;

    public TempDir(String path, String baseName) throws IOException {
        block1: {
            int dirNum = 0;
            do {
                this.dir = new File(path, baseName + "." + System.currentTimeMillis() + "." + dirNum + ".tmp");
                if (this.dir.mkdirs()) break block1;
                if (this.dir.exists()) continue;
                throw new IOException("no permission to create directory " + this.dir.getAbsolutePath());
            } while (++dirNum < 25);
            throw new IOException("failed to create tmp directory named in the form \"" + this.dir.getAbsolutePath() + "\" after " + dirNum + " trys");
        }
    }

    public File file() {
        return this.dir;
    }

    void recursiveDelete(File dirPath) {
        String[] ls = dirPath.list();
        for (int idx = 0; idx < ls.length; ++idx) {
            File file = new File(dirPath, ls[idx]);
            if (file.isDirectory()) {
                this.recursiveDelete(file);
            }
            file.delete();
        }
    }

    public void delete() throws IOException {
        this.recursiveDelete(this.dir);
        if (this.dir.exists()) {
            throw new IOException("Unable to delete directory hierarchy \"" + this.dir.getAbsolutePath() + "\"");
        }
    }

    public File mkdirs(String path) throws IOException {
        File newDir = new File(this.dir.getAbsolutePath(), path);
        newDir.mkdirs();
        if (!newDir.exists()) {
            throw new IOException("Unable to create directory \"" + this.dir.getAbsolutePath() + "\"");
        }
        return newDir;
    }
}

