/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.javaUtils.exception;

import gov.va.med.lom.javaUtils.exception.ChainedThrowable;
import java.awt.print.PrinterIOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.WriteAbortedException;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationException;
import java.rmi.server.ServerCloneException;
import java.security.PrivilegedActionException;
import java.sql.SQLException;
import org.xml.sax.SAXException;

class ChainedThrowableUtil {
    private ChainedThrowableUtil() {
    }

    protected static String makeMessage(Throwable cause) {
        String causeMsg = cause.getMessage();
        if (causeMsg == null) {
            return cause.getClass().getName();
        }
        return causeMsg;
    }

    protected static String getMessage(ChainedThrowable except, String superMsg) {
        Throwable cause = except.getCause();
        if (cause == null) {
            return superMsg;
        }
        String causeMsg = cause.getMessage();
        if (causeMsg == null || causeMsg.length() == 0) {
            causeMsg = cause.getClass().getName();
        }
        return superMsg + ": " + causeMsg;
    }

    private static void printChainedCauses(Throwable cause, PrintWriter out) {
        if (cause != null) {
            out.println("*** Caused by:");
            cause.printStackTrace(out);
            if (!(cause instanceof ChainedThrowable)) {
                if (cause instanceof PrinterIOException) {
                    ChainedThrowableUtil.printChainedCauses(((PrinterIOException)cause).getIOException(), out);
                } else if (cause instanceof WriteAbortedException) {
                    ChainedThrowableUtil.printChainedCauses(((WriteAbortedException)cause).detail, out);
                } else if (cause instanceof ClassNotFoundException) {
                    ChainedThrowableUtil.printChainedCauses(((ClassNotFoundException)cause).getException(), out);
                } else if (cause instanceof ExceptionInInitializerError) {
                    ChainedThrowableUtil.printChainedCauses(((ExceptionInInitializerError)cause).getException(), out);
                } else if (cause instanceof InvocationTargetException) {
                    ChainedThrowableUtil.printChainedCauses(((InvocationTargetException)cause).getTargetException(), out);
                } else if (cause instanceof RemoteException) {
                    ChainedThrowableUtil.printChainedCauses(((RemoteException)cause).detail, out);
                } else if (cause instanceof ActivationException) {
                    ChainedThrowableUtil.printChainedCauses(((ActivationException)cause).detail, out);
                } else if (cause instanceof ServerCloneException) {
                    ChainedThrowableUtil.printChainedCauses(((ServerCloneException)cause).detail, out);
                } else if (cause instanceof PrivilegedActionException) {
                    ChainedThrowableUtil.printChainedCauses(((PrivilegedActionException)cause).getException(), out);
                } else if (cause instanceof SQLException) {
                    ChainedThrowableUtil.printChainedCauses(((SQLException)cause).getNextException(), out);
                } else if (cause instanceof SAXException) {
                    ChainedThrowableUtil.printChainedCauses(((SAXException)cause).getException(), out);
                }
            }
        }
    }

    protected static void printCauseTrace(ChainedThrowable except) {
        PrintWriter pw = new PrintWriter(System.err);
        ChainedThrowableUtil.printChainedCauses(except.getCause(), pw);
        pw.flush();
    }

    protected static void printCauseTrace(ChainedThrowable except, PrintStream s) {
        PrintWriter pw = new PrintWriter(s);
        ChainedThrowableUtil.printChainedCauses(except.getCause(), pw);
        pw.flush();
    }

    public static void printCauseTrace(ChainedThrowable except, PrintWriter out) {
        ChainedThrowableUtil.printChainedCauses(except.getCause(), out);
        out.flush();
    }
}

