/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.javaUtils.crypto;

import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.SecretKeySpec;

public class DSAKeyGen {
    private static String algorithm = "DES";
    private DSAPublicKeySpec dsaPublicKeySpec;
    private DSAPrivateKeySpec dsaPrivateKeySpec;
    private KeyGenerator kg;

    public DSAKeyGen() {
        try {
            this.kg = KeyGenerator.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }

    public void setDSAPublicKeySpec(BigInteger y, BigInteger p, BigInteger q, BigInteger g) {
        this.dsaPublicKeySpec = new DSAPublicKeySpec(y, p, q, g);
    }

    public void setDSAPrivateKeySpec(BigInteger x, BigInteger p, BigInteger q, BigInteger g) {
        this.dsaPrivateKeySpec = new DSAPrivateKeySpec(x, p, q, g);
    }

    public Key getKey() {
        PublicKey pub = null;
        try {
            KeyFactory kf = KeyFactory.getInstance("DSA");
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("DSA");
            kpg.initialize(512);
            KeyPair kp = kpg.generateKeyPair();
            this.dsaPublicKeySpec = kf.getKeySpec(kp.getPublic(), DSAPublicKeySpec.class);
            pub = kf.generatePublic(this.dsaPublicKeySpec);
        }
        catch (NoSuchAlgorithmException nsae) {
            return null;
        }
        catch (InvalidKeySpecException ikse) {
            return null;
        }
        return pub;
    }

    public Key getSecretKey(String keyData) {
        return this.getSecretKey(keyData.getBytes());
    }

    public Key getSecretKey(byte[] keyData) {
        return new SecretKeySpec(keyData, algorithm);
    }

    public static void main(String[] args) {
        DSAKeyGen keyGen = new DSAKeyGen();
        Key k = keyGen.getKey();
        System.out.println(k);
    }
}

