/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.javaUtils.config;

import gov.va.med.lom.javaUtils.config.ConfigStringParserConstants;
import gov.va.med.lom.javaUtils.config.ConfigStringParserTokenManager;
import gov.va.med.lom.javaUtils.config.ParseException;
import gov.va.med.lom.javaUtils.config.SimpleCharStream;
import gov.va.med.lom.javaUtils.config.Token;
import gov.va.med.lom.javaUtils.config.TokenMgrError;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Vector;

public class ConfigStringParser
implements ConfigStringParserConstants {
    public ConfigStringParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[7];
    private final int[] jj_la1_0 = new int[]{2, 128, 2, 64, 2, 2, 24};
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public static void main(String[] args) throws ParseException, IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        String instr = in.readLine();
        String[] values = ConfigStringParser.parseStringArray(instr);
        System.out.println(values.length + " elements");
        for (int i = 0; i < values.length; ++i) {
            System.out.println(values[i]);
        }
    }

    public static String[] parseStringArray(String valuestr) throws ParseException {
        String[] values = null;
        byte[] bb = valuestr.getBytes();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bb);
        ConfigStringParser parser = new ConfigStringParser(inputStream);
        try {
            try {
                values = parser.ParseConfigString();
            }
            catch (TokenMgrError e) {
                throw parser.generateParseException();
            }
        }
        catch (ParseException e) {
            System.err.println("Syntax error in config file at line " + e.currentToken.next.beginLine + ", column " + e.currentToken.next.beginColumn + ".");
            throw e;
        }
        return values;
    }

    private static final boolean isodigit(char c) {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': {
                return true;
            }
        }
        return false;
    }

    private static final boolean isxdigit(char c) {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': 
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                return true;
            }
        }
        return false;
    }

    public final String[] ParseConfigString() throws ParseException {
        Vector vv = this.ValueList();
        Object[] values = new String[vv.size()];
        vv.copyInto(values);
        return values;
    }

    public final Vector ValueList() throws ParseException {
        String sval = null;
        Vector vlist = null;
        sval = this.Value();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: {
                this.jj_consume_token(7);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        this.jj_consume_token(1);
                        break;
                    }
                    default: {
                        this.jj_la1[0] = this.jj_gen;
                    }
                }
                vlist = this.ValueList();
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
            }
        }
        if (vlist == null) {
            vlist = new Vector();
            vlist.addElement(sval);
        } else {
            vlist.insertElementAt(sval, 0);
        }
        return vlist;
    }

    public final String Value() throws ParseException {
        String lhs = "";
        String rhs = "";
        lhs = this.ValueFragment();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: {
                this.jj_consume_token(6);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        this.jj_consume_token(1);
                        break;
                    }
                    default: {
                        this.jj_la1[2] = this.jj_gen;
                    }
                }
                rhs = this.Value();
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
        return lhs + rhs;
    }

    public final String ValueFragment() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 3: {
                String sval = this.QuotedString();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        this.jj_consume_token(1);
                        break;
                    }
                    default: {
                        this.jj_la1[4] = this.jj_gen;
                    }
                }
                return sval;
            }
            case 4: {
                Token val = this.jj_consume_token(4);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        this.jj_consume_token(1);
                        break;
                    }
                    default: {
                        this.jj_la1[5] = this.jj_gen;
                    }
                }
                return val.image;
            }
        }
        this.jj_la1[6] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String QuotedString() throws ParseException {
        Token qs = this.jj_consume_token(3);
        StringBuffer sbuf = new StringBuffer();
        char[] cbuf = qs.image.toCharArray();
        block18: for (int i = 1; i < cbuf.length - 1; ++i) {
            switch (cbuf[i]) {
                case '\\': {
                    int val;
                    String s;
                    switch (cbuf[i + 1]) {
                        case 'n': {
                            sbuf.append("\n");
                            ++i;
                            continue block18;
                        }
                        case 't': {
                            sbuf.append("\t");
                            ++i;
                            continue block18;
                        }
                        case 'b': {
                            sbuf.append("\b");
                            ++i;
                            continue block18;
                        }
                        case 'r': {
                            sbuf.append("\r");
                            ++i;
                            continue block18;
                        }
                        case 'f': {
                            sbuf.append("\f");
                            ++i;
                            continue block18;
                        }
                        case 'u': {
                            if (cbuf.length - i >= 6 && ConfigStringParser.isxdigit(cbuf[i + 2]) && ConfigStringParser.isxdigit(cbuf[i + 3]) && ConfigStringParser.isxdigit(cbuf[i + 4]) && ConfigStringParser.isxdigit(cbuf[i + 5])) {
                                try {
                                    s = new String(cbuf, i + 2, 4);
                                    val = Integer.parseInt(s, 16);
                                    sbuf.append((char)val);
                                    i += 5;
                                }
                                catch (Throwable t) {
                                    sbuf.append(cbuf[i + 1]);
                                    ++i;
                                }
                                continue block18;
                            }
                            sbuf.append(cbuf[i + 1]);
                            ++i;
                            continue block18;
                        }
                        case 'x': {
                            if (cbuf.length - i >= 4 && ConfigStringParser.isxdigit(cbuf[i + 2]) && ConfigStringParser.isxdigit(cbuf[i + 3])) {
                                try {
                                    s = new String(cbuf, i + 2, 2);
                                    val = Integer.parseInt(s, 16);
                                    sbuf.append((char)val);
                                    i += 3;
                                }
                                catch (Throwable t) {
                                    sbuf.append(cbuf[i + 1]);
                                    ++i;
                                }
                                continue block18;
                            }
                            sbuf.append(cbuf[i + 1]);
                            ++i;
                            continue block18;
                        }
                    }
                    if (cbuf.length - i >= 4 && ConfigStringParser.isodigit(cbuf[i + 1]) && ConfigStringParser.isodigit(cbuf[i + 2]) && ConfigStringParser.isodigit(cbuf[i + 3])) {
                        try {
                            s = new String(cbuf, i + 1, 3);
                            val = Integer.parseInt(s, 8);
                            sbuf.append((char)val);
                            i += 3;
                        }
                        catch (Throwable t) {
                            sbuf.append(cbuf[i + 1]);
                            ++i;
                        }
                        continue block18;
                    }
                    sbuf.append(cbuf[i + 1]);
                    ++i;
                    continue block18;
                }
                default: {
                    sbuf.append(cbuf[i]);
                }
            }
        }
        return sbuf.toString();
    }

    public ConfigStringParser(InputStream stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new ConfigStringParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 7; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 7; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public ConfigStringParser(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new ConfigStringParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 7; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 7; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public ConfigStringParser(ConfigStringParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 7; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(ConfigStringParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 7; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public final ParseException generateParseException() {
        int i;
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[8];
        for (i = 0; i < 8; ++i) {
            la1tokens[i] = false;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 7; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((this.jj_la1_0[i] & 1 << j) == 0) continue;
                la1tokens[j] = true;
            }
        }
        for (i = 0; i < 8; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }
}

