/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.javaUtils.classloader;

import gov.va.med.lom.javaUtils.classloader.ClassLoaderStrategy;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Enumeration;

public class SocketClassLoader
extends ClassLoader
implements ClassLoaderStrategy {
    String host;
    int port;

    public SocketClassLoader(String host, int port) {
        this(SocketClassLoader.class.getClassLoader(), host, port);
    }

    public SocketClassLoader(ClassLoader parent, String host, int port) {
        super(parent);
        this.host = host;
        this.port = port;
    }

    public byte[] findClassBytes(String className) {
        try {
            Socket socket = new Socket(this.host, this.port);
            BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            PrintWriter writer = new PrintWriter(socket.getOutputStream());
            writer.println("Classname:" + className);
            writer.flush();
            String line = reader.readLine();
            if (line.equals("Error")) {
                return null;
            }
            if (line.startsWith("Content-Length")) {
                int colonLoc = line.indexOf(":");
                Integer l = new Integer(line.substring(colonLoc + 1, line.length()));
                byte[] classBytes = new byte[l.intValue()];
                while (reader.read() != 202) {
                }
                classBytes[0] = -54;
                for (int i = 1; i < classBytes.length; ++i) {
                    classBytes[i] = (byte)reader.read();
                }
                return classBytes;
            }
            return null;
        }
        catch (UnknownHostException uhEx) {
            return null;
        }
        catch (IOException ioEx) {
            return null;
        }
    }

    public URL findResourceURL(String resourceName) {
        return null;
    }

    public Enumeration findResourcesEnum(String resourceName) {
        return null;
    }

    public String findLibraryPath(String libraryName) {
        return null;
    }

    public Class findClass(String className) throws ClassNotFoundException {
        byte[] classBytes = this.findClassBytes(className);
        if (classBytes == null) {
            throw new ClassNotFoundException();
        }
        return this.defineClass(className, classBytes, 0, classBytes.length);
    }

    public String[] getClassNames() {
        return null;
    }

    public Class[] getClasses(String classPath) throws ClassNotFoundException {
        return null;
    }

    public Class[] getClasses(String sourcePath, String classPath) throws ClassNotFoundException {
        return null;
    }

    public static void main(String[] args) throws Exception {
        File file = new File("Hello.class");
        if (file.exists()) {
            System.out.println("Warning--Hello.class exists in the current directory. SocketClassLoader will NOT be used to retrieve the file; the primordial ClassLoader will.");
        }
        SocketClassLoader scl = new SocketClassLoader("localhost", 8085);
        Class<?> cls = scl.loadClass("Hello");
        Object h = cls.newInstance();
    }
}

