/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.javaUtils.classloader;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarFile;

public class PluginClassLoader {
    private URLClassLoader urlClassLoader;

    public PluginClassLoader(String dir) {
        this(dir, new Listener(){

            public void pluginLoaded(String pluginName) {
            }

            public void exception(Exception ex) {
            }
        });
    }

    public PluginClassLoader(String dir, Listener listener) {
        File file = new File(dir);
        this.reload(file, listener);
    }

    public PluginClassLoader(File dir) {
        this(dir, new Listener(){

            public void pluginLoaded(String pluginName) {
            }

            public void exception(Exception ex) {
            }
        });
    }

    public PluginClassLoader(File dir, Listener listener) {
        this.reload(dir, listener);
    }

    public void reload(String dir, Listener listener) {
        this.reload(new File(dir), listener);
    }

    public void reload(File dir, Listener listener) {
        int i;
        String[] contents = this.getPluginDirContents(dir);
        Vector<URL> urls = new Vector<URL>();
        Vector<String> plugins = new Vector<String>();
        for (i = 0; i < contents.length; ++i) {
            try {
                File jarFile = new File(dir, contents[i]);
                Attributes attribs = new JarFile(jarFile).getManifest().getMainAttributes();
                if (attribs.getValue("Plugin-Class") == null) continue;
                String pluginClass = attribs.getValue("Plugin-Class");
                urls.add(jarFile.toURL());
                plugins.add(pluginClass.trim());
                continue;
            }
            catch (IOException ioEx) {
                continue;
            }
            catch (NullPointerException npEx) {
                // empty catch block
            }
        }
        this.urlClassLoader = URLClassLoader.newInstance(this.convertUrlVectorToArray(urls), this.getClass().getClassLoader());
        for (i = 0; i < plugins.size(); ++i) {
            String plugin = (String)plugins.elementAt(i);
            try {
                this.urlClassLoader.loadClass(plugin).newInstance();
                listener.pluginLoaded(plugin);
                continue;
            }
            catch (Exception ex) {
                listener.exception(ex);
            }
        }
    }

    public void unload() {
        this.urlClassLoader = null;
    }

    private String[] getPluginDirContents(File dir) {
        if (!dir.exists() || !dir.isDirectory()) {
            return new String[0];
        }
        String[] contents = dir.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".jar") || name.endsWith(".zip");
            }
        });
        return contents;
    }

    private String[] getPluginDirClasses(File dir) {
        String[] contents = dir.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".class");
            }
        });
        return contents;
    }

    private URL[] convertUrlVectorToArray(Vector urls) {
        URL[] urlArray = new URL[urls.size()];
        for (int i = 0; i < urlArray.length; ++i) {
            urlArray[i] = (URL)urls.elementAt(i);
        }
        return urlArray;
    }

    public static void main(String[] args) throws Exception {
        PluginClassLoader pcl = new PluginClassLoader(".", new Listener(){

            public void pluginLoaded(String pluginName) {
                System.out.println(pluginName + " loaded.");
            }

            public void exception(Exception ex) {
                System.out.println("Exception:");
                ex.printStackTrace();
            }
        });
    }

    public static interface Listener {
        public void pluginLoaded(String var1);

        public void exception(Exception var1);
    }
}

