/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.javaUtils.classloader;

import gov.va.med.lom.javaUtils.classloader.ClassLoaderStrategy;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class JarClassLoader
extends ClassLoader
implements ClassLoaderStrategy {
    private Hashtable sizes;
    private Hashtable jarContents;
    private String jarFileName;

    public JarClassLoader() throws FileNotFoundException {
    }

    public JarClassLoader(String jarFileName) throws FileNotFoundException {
        this.jarFileName = jarFileName;
        this.loadClasses();
    }

    public byte[] findClassBytes(String className) {
        String classPath = className.replace('.', '/') + ".class";
        byte[] classBytes = (byte[])this.jarContents.get(classPath);
        return classBytes;
    }

    public URL findResourceURL(String resourceName) {
        return null;
    }

    public Enumeration findResourcesEnum(String resourceName) {
        return null;
    }

    public String findLibraryPath(String libraryName) {
        return null;
    }

    public Class findClass(String className) throws ClassNotFoundException {
        byte[] classBytes = this.findClassBytes(className);
        if (classBytes == null) {
            throw new ClassNotFoundException();
        }
        return this.defineClass(className, classBytes, 0, classBytes.length);
    }

    public void loadClasses() {
        try {
            JarEntry je;
            this.sizes = new Hashtable();
            ZipFile zf = new ZipFile(this.jarFileName);
            Enumeration<? extends ZipEntry> e = zf.entries();
            while (e.hasMoreElements()) {
                ZipEntry ze = e.nextElement();
                String entryName = ze.getName();
                this.sizes.put(entryName, new Integer((int)ze.getSize()));
            }
            zf.close();
            this.jarContents = new Hashtable();
            JarInputStream jis = new JarInputStream(new BufferedInputStream(new FileInputStream(this.jarFileName)));
            while ((je = jis.getNextJarEntry()) != null) {
                int r;
                String name = je.getName();
                int size = (int)je.getSize();
                if (size < 0) {
                    size = (Integer)this.sizes.get(name);
                }
                byte[] ba = new byte[size];
                for (int bytes_read = 0; bytes_read != size && (r = jis.read(ba, bytes_read, size - bytes_read)) >= 0; bytes_read += r) {
                }
                this.jarContents.put(name, ba);
            }
            jis.close();
        }
        catch (IOException ioe) {
            System.err.println(ioe.getMessage());
        }
    }

    public String[] getClassNames() {
        Vector<String> classesVect = new Vector<String>();
        try {
            ZipFile zf = new ZipFile(this.jarFileName);
            Enumeration<? extends ZipEntry> e = zf.entries();
            while (e.hasMoreElements()) {
                ZipEntry ze = e.nextElement();
                String name = ze.getName();
                if (!name.endsWith(".class")) continue;
                classesVect.add(name);
            }
        }
        catch (IOException ioe) {
            System.err.println(ioe.getMessage());
        }
        String[] classNames = new String[classesVect.size()];
        for (int i = 0; i < classesVect.size(); ++i) {
            classNames[i] = (String)classesVect.get(i);
        }
        return classNames;
    }

    public Class[] getClasses(String classPath) throws ClassNotFoundException {
        return this.getClasses(this.jarFileName, classPath);
    }

    public Class[] getClasses(String sourcePath, String classPath) throws ClassNotFoundException {
        this.jarFileName = sourcePath;
        String className = classPath.replace('.', '/');
        this.loadClasses();
        Vector classesVect = new Vector();
        Enumeration e = this.jarContents.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (!name.endsWith(".class") || !name.startsWith(className)) continue;
            StringBuffer sb = new StringBuffer(name.replace('/', '.'));
            sb.delete(sb.indexOf(".class"), sb.length());
            byte[] classBytes = (byte[])this.jarContents.get(name);
            try {
                Class<?> cls = this.defineClass(sb.toString(), classBytes, 0, classBytes.length);
                classesVect.add(cls);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
        Class[] classes = new Class[classesVect.size()];
        for (int i = 0; i < classes.length; ++i) {
            classes[i] = (Class)classesVect.get(i);
        }
        return classes;
    }
}

