/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.javaUtils.classloader;

import gov.va.med.lom.javaUtils.classloader.ByteArray;
import gov.va.med.lom.javaUtils.classloader.ClassLoaderStrategy;
import java.io.FileInputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public class HashtableClassLoader
extends ClassLoader
implements ClassLoaderStrategy {
    private Map classtable;

    public HashtableClassLoader() {
        this(HashtableClassLoader.class.getClassLoader());
    }

    public HashtableClassLoader(Map table) {
        this(HashtableClassLoader.class.getClassLoader(), table);
    }

    public HashtableClassLoader(ClassLoader parent) {
        this(parent, new HashMap());
    }

    public HashtableClassLoader(ClassLoader parent, Map table) {
        super(parent);
        this.classtable = table;
    }

    public void putClass(String className, byte[] bytes) {
        this.classtable.put(className, new ByteArray(bytes));
    }

    public byte[] findClassBytes(String className) {
        try {
            ByteArray byteArray = (ByteArray)this.classtable.get(className);
            byte[] bytes = byteArray.getBytes();
            return bytes;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public URL findResourceURL(String resourceName) {
        return null;
    }

    public Enumeration findResourcesEnum(String resourceName) {
        return null;
    }

    public String findLibraryPath(String libraryName) {
        return null;
    }

    public Class findClass(String className) throws ClassNotFoundException {
        byte[] bytes = this.findClassBytes(className);
        if (bytes == null) {
            throw new ClassNotFoundException();
        }
        return this.defineClass(className, bytes, 0, bytes.length);
    }

    public String[] getClassNames() {
        return null;
    }

    public Class[] getClasses(String classPath) throws ClassNotFoundException {
        return null;
    }

    public Class[] getClasses(String sourcePath, String classPath) throws ClassNotFoundException {
        return null;
    }

    public static void main(String[] args) throws Exception {
        HashtableClassLoader hcl = new HashtableClassLoader();
        FileInputStream fis = new FileInputStream("/Hello.class");
        int ct = fis.available();
        byte[] Hello_bytes = new byte[ct];
        fis.read(Hello_bytes);
        hcl.putClass("Hello", Hello_bytes);
        Object obj = hcl.loadClass("Hello").newInstance();
    }
}

