/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.javaUtils.classloader;

import gov.va.med.lom.javaUtils.classloader.ClassLoaderStrategy;
import gov.va.med.lom.javaUtils.classloader.ClassLoaderUtil;
import gov.va.med.lom.javaUtils.classloader.HashEntry;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class HashedMethods {
    Hashtable methodsHashtable;
    Class[] classes;
    private String[] excludedMethodNames;

    public HashedMethods(String classLoaderStrategy, String[] classLoaderArgs, String[] classNames, Class[][] constArgTypes, Object[][] constArgs, String[] excludedMethodNames) {
        this.excludedMethodNames = excludedMethodNames;
        this.methodsHashtable = new Hashtable();
        this.classes = new Class[classNames.length];
        for (int i = 0; i < classNames.length; ++i) {
            Class c;
            this.classes[i] = c = this.getClass(classLoaderStrategy, classLoaderArgs, classNames[i]);
            Method[] m = this.getMethods(c);
            this.loadHashTable(c, constArgTypes[i], constArgs[i], m);
        }
    }

    public HashedMethods(String classLoaderStrategy, String[] classLoaderArgs, String[] classNames, String[] excludedMethodNames) {
        this.excludedMethodNames = excludedMethodNames;
        this.methodsHashtable = new Hashtable();
        this.classes = new Class[classNames.length];
        for (int i = 0; i < classNames.length; ++i) {
            Class c;
            this.classes[i] = c = this.getClass(classLoaderStrategy, classLoaderArgs, classNames[i]);
            Method[] m = this.getMethods(c);
            this.loadHashTable(c, null, null, m);
        }
    }

    public HashedMethods(String classLoaderStrategy, String[] classLoaderArgs, Class[] classes, String[] excludedMethodNames) {
        this.excludedMethodNames = excludedMethodNames;
        this.methodsHashtable = new Hashtable();
        this.classes = classes;
        for (int i = 0; i < classes.length; ++i) {
            Method[] m = this.getMethods(classes[i]);
            this.loadHashTable(classes[i], null, null, m);
        }
    }

    public Class[] getClasses() {
        return this.classes;
    }

    public Method[] getMethods(Class cls) {
        if (cls != null) {
            Vector<Method> mVect = new Vector<Method>();
            try {
                Method[] methods = cls.getDeclaredMethods();
                for (int i = 0; i < methods.length; ++i) {
                    if (!Modifier.isPublic(methods[i].getModifiers())) continue;
                    mVect.add(methods[i]);
                }
                return mVect.toArray(methods);
            }
            catch (Throwable e) {
                System.err.println(e);
            }
        }
        return null;
    }

    public Class getClassForMethod(String methodName) {
        HashEntry hashEntry = this.getHashEntry(methodName);
        if (hashEntry != null) {
            return hashEntry.getEntryClass();
        }
        return null;
    }

    public Object getMethodObject(String methodName) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException, InstantiationException {
        HashEntry entry = this.getHashEntry(methodName);
        if (entry != null) {
            Class cls = entry.getEntryClass();
            Object[] constArgs = entry.getConstArgs();
            Class[] constArgTypes = entry.getConstArgTypes();
            Constructor ct = cls.getConstructor(constArgTypes);
            return ct.newInstance(constArgs);
        }
        throw new NoSuchMethodException();
    }

    public Method[] getMethods() {
        Vector<Method> v = new Vector<Method>();
        Enumeration e = this.methodsHashtable.elements();
        while (e.hasMoreElements()) {
            HashEntry entry = (HashEntry)e.nextElement();
            if (entry == null) continue;
            Method meth = entry.getMethod();
            v.add(meth);
        }
        Method[] methods = new Method[v.size()];
        for (int i = 0; i < methods.length; ++i) {
            methods[i] = (Method)v.get(i);
        }
        return methods;
    }

    public Method getMethod(String methodName) {
        HashEntry entry = this.getHashEntry(methodName);
        if (entry != null) {
            return entry.getMethod();
        }
        return null;
    }

    public Class getMethodReturnType(String methodName) {
        Method method = this.getMethod(methodName);
        if (method != null) {
            return method.getReturnType();
        }
        return null;
    }

    public Object invokeMethod(Object obj, String methodName, Object[] argValues) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException, InstantiationException {
        Method method = this.getMethod(methodName);
        if (method != null) {
            return this.invokeMethod(obj, method, argValues);
        }
        throw new NoSuchMethodException();
    }

    public Object[] invokeMethod(String methodName, Object[] argValues) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException, InstantiationException {
        HashEntry entry = this.getHashEntry(methodName);
        if (entry != null) {
            Object[] objects = new Object[2];
            objects[0] = this.getMethodObject(methodName);
            Method method = entry.getMethod();
            objects[1] = this.invokeMethod(objects[0], method, argValues);
            return objects;
        }
        throw new NoSuchMethodException();
    }

    public Object invokeMethod(Object obj, Method method, Object[] argValues) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException, InstantiationException {
        return method.invoke(obj, argValues);
    }

    private HashEntry getHashEntry(String methodName) {
        return (HashEntry)this.methodsHashtable.get(methodName);
    }

    private Class getClass(String classLoaderStrategy, String[] classLoaderArgs, String className) {
        try {
            ClassLoaderStrategy cls = ClassLoaderUtil.getClassLoader(classLoaderStrategy, classLoaderArgs);
            Class<?> c = ((ClassLoader)((Object)cls)).loadClass(className);
            return c;
        }
        catch (Throwable e) {
            System.err.println(e);
            return null;
        }
    }

    private void loadHashTable(Class c, Class[] constArgTypes, Object[] constArgs, Method[] m) {
        if (m != null) {
            for (int i = 0; i < m.length; ++i) {
                if (m[i] == null || !Modifier.isPublic(m[i].getModifiers())) continue;
                boolean excluded = false;
                if (this.excludedMethodNames != null) {
                    for (int j = 0; j < this.excludedMethodNames.length; ++j) {
                        if (!m[i].getName().equals(this.excludedMethodNames[j])) continue;
                        excluded = true;
                        break;
                    }
                }
                if (excluded) continue;
                this.methodsHashtable.put(m[i].getName(), new HashEntry(c, constArgTypes, constArgs, m[i]));
            }
        }
    }
}

