/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.javaUtils.classloader;

import gov.va.med.lom.javaUtils.classloader.ClassLoaderStrategy;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;

public class FileSystemClassLoader
extends ClassLoader
implements ClassLoaderStrategy {
    private String root = null;

    public FileSystemClassLoader() throws FileNotFoundException {
        this(FileSystemClassLoader.class.getClassLoader(), System.getProperties().getProperty("java.home"));
    }

    public FileSystemClassLoader(String root) throws FileNotFoundException {
        this(FileSystemClassLoader.class.getClassLoader(), root);
    }

    public FileSystemClassLoader(ClassLoader parent) throws FileNotFoundException {
        this(parent, System.getProperties().getProperty("java.home"));
    }

    public FileSystemClassLoader(ClassLoader parent, String root) throws FileNotFoundException {
        super(parent);
        File f = new File(root);
        if (!f.isDirectory()) {
            throw new FileNotFoundException();
        }
        this.root = root;
    }

    public byte[] findClassBytes(String className) {
        try {
            String pathName = this.root + File.separatorChar + className.replace('.', File.separatorChar) + ".class";
            FileInputStream inFile = new FileInputStream(pathName);
            byte[] classBytes = new byte[inFile.available()];
            inFile.read(classBytes);
            return classBytes;
        }
        catch (IOException ioEx) {
            return null;
        }
    }

    public URL findResourceURL(String resourceName) {
        return null;
    }

    public Enumeration findResourcesEnum(String resourceName) {
        return null;
    }

    public String findLibraryPath(String libraryName) {
        return null;
    }

    public Class findClass(String name) throws ClassNotFoundException {
        byte[] classBytes = this.findClassBytes(name);
        if (classBytes == null) {
            throw new ClassNotFoundException();
        }
        return this.defineClass(name, classBytes, 0, classBytes.length);
    }

    public String[] getClassNames() {
        File path = new File(this.root);
        String[] fileNames = path.list(new DirFilter(".class"));
        return fileNames;
    }

    public Class[] getClasses(String classPath) throws ClassNotFoundException {
        return this.getClasses(this.root, classPath);
    }

    public Class[] getClasses(String sourcePath, String classPath) {
        Vector classesVect = new Vector();
        File path = new File(sourcePath);
        String[] fileNames = path.list(new DirFilter(".class"));
        if (fileNames == null) {
            return new Class[0];
        }
        byte[] classBytes = null;
        for (int i = 0; i < fileNames.length; ++i) {
            StringBuffer sb = new StringBuffer(fileNames[i]);
            sb.delete(sb.indexOf(".class"), sb.length());
            String filename = sourcePath + String.valueOf(File.separatorChar) + fileNames[i];
            File file = new File(filename);
            if (!file.exists()) continue;
            try {
                FileInputStream inFile = new FileInputStream(file);
                classBytes = new byte[inFile.available()];
                inFile.read(classBytes);
                try {
                    Class<?> c = this.findLoadedClass(classPath + '.' + sb.toString());
                    if (c == null) {
                        c = this.defineClass(classPath + '.' + sb.toString(), classBytes, 0, classBytes.length);
                    }
                    classesVect.add(c);
                }
                catch (NoClassDefFoundError e) {}
                continue;
            }
            catch (IOException ioEx) {
                // empty catch block
            }
        }
        Class[] classes = new Class[classesVect.size()];
        for (int i = 0; i < classesVect.size(); ++i) {
            classes[i] = (Class)classesVect.get(i);
        }
        return classes;
    }

    public static void main(String[] args) throws Exception {
        FileSystemClassLoader fscl = new FileSystemClassLoader(args[0]);
        Class[] classes = fscl.getClasses(args[1]);
        for (int i = 0; i < classes.length; ++i) {
            System.out.println(classes[i]);
        }
    }

    class DirFilter
    implements FilenameFilter {
        String afn;

        DirFilter(String afn) {
            this.afn = afn;
        }

        public boolean accept(File dir, String name) {
            String f = new File(name).getName();
            return f.indexOf(this.afn) != -1;
        }
    }
}

